/**
 * vertigo - simple java starter
 *
 * Copyright (C) 2013-2016, KleeGroup, direction.technique@kleegroup.com (http://www.kleegroup.com)
 * KleeGroup, Centre d'affaire la Boursidiere - BP 159 - 92357 Le Plessis Robinson Cedex - France
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.vertigo.quarto.plugins.publisher.environment.registries;

import java.util.List;

import io.vertigo.core.definition.dsl.entity.Entity;
import io.vertigo.core.definition.dsl.entity.EntityBuilder;
import io.vertigo.core.definition.dsl.entity.EntityGrammar;
import io.vertigo.util.ListBuilder;

/**
 * Grammaire de publisher.
 *
 * @author npiedeloup
 */
final class PublisherGrammar implements EntityGrammar {
	/**
	 * Clé des FIELD_DEFINITION de type PK utilisés dans les DT_DEFINITION.
	 */
	/** String field. */
	public static final String STRING_FIELD = "stringField";
	/** Boolean field. */
	public static final String BOOLEAN_FIELD = "booleanField";
	/** Image field. */
	public static final String IMAGE_FIELD = "imageField";
	/** Data field. */
	public static final String DATA_FIELD = "dataField";
	/** List field. */
	public static final String LIST_FIELD = "listField";

	private static final String PUB_DEFINITION_META_DEFINITION = "PublisherDefinition";
	private static final String NODE_DEFINITION_META_DEFINITION = "PublisherNode";
	private static final String NODE_FIELD_META_DEFINITION = "DataField";
	private static final String NODE_DATA_FIELD_META_DEFINITION = "NodeField";

	/**Définition d'un DT.*/
	static final Entity PUBLISHER_DEFINITION;
	/**Définition d'un domain.*/
	static final Entity PUBLISHER_NODE_DEFINITION;

	/**Définition des champs.*/
	private static final Entity PUBLISHER_FIELD_DEFINITION;
	/**Définition des champs typés.*/
	private static final Entity PUBLISHER_DATA_FIELD_DEFINITION;

	/**
	 * Initialisation des métadonnées permettant de décrire le métamodèle de Dynamo.
	 */
	static {
		//On a une relation circulaire
		//On conserve donc une référence sur le builder
		final EntityBuilder builder = new EntityBuilder(NODE_DEFINITION_META_DEFINITION);
		PUBLISHER_FIELD_DEFINITION = new EntityBuilder(NODE_FIELD_META_DEFINITION).build();

		PUBLISHER_DATA_FIELD_DEFINITION = new EntityBuilder(NODE_DATA_FIELD_META_DEFINITION)//
				.addField("type", builder.build().getLink(), true)
				.build();

		PUBLISHER_NODE_DEFINITION = builder//
				.addFields(STRING_FIELD, PUBLISHER_FIELD_DEFINITION, false) // facultative
				.addFields(BOOLEAN_FIELD, PUBLISHER_FIELD_DEFINITION, false) // facultative
				.addFields(IMAGE_FIELD, PUBLISHER_FIELD_DEFINITION, false) //facultative
				.addFields(DATA_FIELD, PUBLISHER_DATA_FIELD_DEFINITION, false) //facultative
				.addFields(LIST_FIELD, PUBLISHER_DATA_FIELD_DEFINITION, false) //facultative
				.build();

		//--
		PUBLISHER_DEFINITION = new EntityBuilder(PUB_DEFINITION_META_DEFINITION)
				.addField("root", PUBLISHER_NODE_DEFINITION.getLink(), true)
				.build();
	}

	@Override
	public List<Entity> getEntities() {
		return new ListBuilder<Entity>()
				.add(PUBLISHER_DEFINITION)
				.add(PUBLISHER_NODE_DEFINITION)
				.add(PUBLISHER_FIELD_DEFINITION)
				.add(PUBLISHER_DATA_FIELD_DEFINITION)
				.unmodifiable()
				.build();
	}
}
