/**
 * vertigo - simple java starter
 *
 * Copyright (C) 2013-2018, KleeGroup, direction.technique@kleegroup.com (http://www.kleegroup.com)
 * KleeGroup, Centre d'affaire la Boursidiere - BP 159 - 92357 Le Plessis Robinson Cedex - France
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.vertigo.dynamo.environment.java.data.domain;

import io.vertigo.dynamo.domain.model.EnumVAccessor;
import io.vertigo.dynamo.domain.model.KeyConcept;
import io.vertigo.dynamo.domain.model.ListVAccessor;
import io.vertigo.dynamo.domain.model.URI;
import io.vertigo.dynamo.domain.model.VAccessor;
import io.vertigo.dynamo.domain.stereotype.Field;
import io.vertigo.dynamo.domain.util.DtObjectUtil;
import io.vertigo.lang.Generated;

/**
 * This class is automatically generated.
 * DO NOT EDIT THIS FILE DIRECTLY.
 */
@Generated
@javax.persistence.Entity
@javax.persistence.Table(name = "COMMAND")
public final class Command implements KeyConcept {
	private static final long serialVersionUID = 1L;

	private Long cmdId;

	@javax.persistence.Transient
	@io.vertigo.dynamo.domain.stereotype.Association(
			name = "A_CTY_CMD",
			fkFieldName = "CTY_ID",
			primaryDtDefinitionName = "DT_COMMAND_TYPE",
			primaryIsNavigable = true,
			primaryRole = "CommandType",
			primaryLabel = "Command type",
			primaryMultiplicity = "0..1",
			foreignDtDefinitionName = "DT_COMMAND",
			foreignIsNavigable = false,
			foreignRole = "Command",
			foreignLabel = "Command",
			foreignMultiplicity = "0..*")
	private final EnumVAccessor<CommandType, CommandTypeEnum> ctyIdAccessor = new EnumVAccessor<>(CommandType.class, "CommandType", CommandTypeEnum.class);

	@javax.persistence.Transient
	@io.vertigo.dynamo.domain.stereotype.Association(
			name = "A_CIT_CMD",
			fkFieldName = "CIT_ID",
			primaryDtDefinitionName = "DT_CITY",
			primaryIsNavigable = true,
			primaryRole = "City",
			primaryLabel = "City",
			primaryMultiplicity = "0..1",
			foreignDtDefinitionName = "DT_COMMAND",
			foreignIsNavigable = false,
			foreignRole = "Command",
			foreignLabel = "Command",
			foreignMultiplicity = "0..*")
	private final VAccessor<City> citIdAccessor = new VAccessor<>(City.class, "City");

	@javax.persistence.Transient
	@io.vertigo.dynamo.domain.stereotype.Association(
			name = "A_CMD_ATT",
			fkFieldName = "CMD_ID",
			primaryDtDefinitionName = "DT_COMMAND",
			primaryIsNavigable = true,
			primaryRole = "Command",
			primaryLabel = "Command",
			primaryMultiplicity = "0..1",
			foreignDtDefinitionName = "DT_ATTACHMENT",
			foreignIsNavigable = true,
			foreignRole = "Attachment",
			foreignLabel = "Attachment",
			foreignMultiplicity = "0..*")
	private final ListVAccessor<Attachment> attachmentAccessor = new ListVAccessor<>(this, "A_CMD_ATT", "Attachment");

	/** {@inheritDoc} */
	@javax.persistence.Transient
	@Override
	public URI<Command> getURI() {
		return DtObjectUtil.createURI(this);
	}

	/**
	 * Champ : ID.
	 * Récupère la valeur de la propriété 'id'.
	 * @return Long cmdId <b>Obligatoire</b>
	 */
	@javax.persistence.Id
	@javax.persistence.SequenceGenerator(name = "sequence", sequenceName = "SEQ_COMMAND", allocationSize = 1)
	@javax.persistence.GeneratedValue(strategy = javax.persistence.GenerationType.SEQUENCE, generator = "sequence")
	@javax.persistence.Column(name = "CMD_ID")
	@Field(domain = "DO_ID", type = "ID", required = true, label = "id")
	public Long getCmdId() {
		return cmdId;
	}

	/**
	 * Champ : ID.
	 * Définit la valeur de la propriété 'id'.
	 * @param cmdId Long <b>Obligatoire</b>
	 */
	public void setCmdId(final Long cmdId) {
		this.cmdId = cmdId;
	}

	/**
	 * Champ : FOREIGN_KEY.
	 * Récupère la valeur de la propriété 'Command type'.
	 * @return Long ctyId
	 */
	@javax.persistence.Column(name = "CTY_ID")
	@Field(domain = "DO_ID", type = "FOREIGN_KEY", label = "Command type")
	public Long getCtyId() {
		return (Long) ctyIdAccessor.getId();
	}

	/**
	 * Champ : FOREIGN_KEY.
	 * Définit la valeur de la propriété 'Command type'.
	 * @param ctyId Long
	 */
	public void setCtyId(final Long ctyId) {
		ctyIdAccessor.setId(ctyId);
	}

	/**
	 * Champ : FOREIGN_KEY.
	 * Récupère la valeur de la propriété 'City'.
	 * @return Long citId
	 */
	@javax.persistence.Column(name = "CIT_ID")
	@Field(domain = "DO_ID", type = "FOREIGN_KEY", label = "City")
	public Long getCitId() {
		return (Long) citIdAccessor.getId();
	}

	/**
	 * Champ : FOREIGN_KEY.
	 * Définit la valeur de la propriété 'City'.
	 * @param citId Long
	 */
	public void setCitId(final Long citId) {
		citIdAccessor.setId(citId);
	}

	/**
	 * Association : City.
	 * @return l'accesseur vers la propriété 'City'
	 */
	@javax.persistence.Transient
	public VAccessor<City> city() {
		return citIdAccessor;
	}

	@Deprecated
	@javax.persistence.Transient
	public City getCity() {
		// we keep the lazyness
		if (!citIdAccessor.isLoaded()) {
			citIdAccessor.load();
		}
		return citIdAccessor.get();
	}

	/**
	 * Retourne l'URI: City.
	 * @return URI de l'association
	 */
	@Deprecated
	@javax.persistence.Transient
	public io.vertigo.dynamo.domain.model.URI<City> getCityURI() {
		return citIdAccessor.getURI();
	}

	/**
	 * Association : Attachment.
	 * @return l'accesseur vers la propriété 'Attachment'
	 */
	@javax.persistence.Transient
	public ListVAccessor<Attachment> attachment() {
		return attachmentAccessor;
	}

	/**
	 * Association : Attachment.
	 * @return io.vertigo.dynamo.domain.model.DtList<Attachment>
	 */
	@Deprecated
	@javax.persistence.Transient
	public io.vertigo.dynamo.domain.model.DtList<Attachment> getAttachmentList() {
		// we keep the lazyness
		if (!attachmentAccessor.isLoaded()) {
			attachmentAccessor.load();
		}
		return attachmentAccessor.get();
	}

	/**
	 * Association URI: Attachment.
	 * @return URI de l'association
	 */
	@Deprecated
	@javax.persistence.Transient
	public io.vertigo.dynamo.domain.metamodel.association.DtListURIForSimpleAssociation getAttachmentDtListURI() {
		return (io.vertigo.dynamo.domain.metamodel.association.DtListURIForSimpleAssociation) attachmentAccessor.getDtListURI();
	}

	/**
	 * Association : Command type.
	 * @return l'accesseur vers la propriété 'Command type'
	 */
	@javax.persistence.Transient
	public EnumVAccessor<CommandType, CommandTypeEnum> commandType() {
		return ctyIdAccessor;
	}

	@Deprecated
	@javax.persistence.Transient
	public CommandType getCommandType() {
		// we keep the lazyness
		if (!ctyIdAccessor.isLoaded()) {
			ctyIdAccessor.load();
		}
		return ctyIdAccessor.get();
	}

	/**
	 * Retourne l'URI: Command type.
	 * @return URI de l'association
	 */
	@Deprecated
	@javax.persistence.Transient
	public io.vertigo.dynamo.domain.model.URI<CommandType> getCommandTypeURI() {
		return ctyIdAccessor.getURI();
	}

	/** {@inheritDoc} */
	@Override
	public String toString() {
		return DtObjectUtil.toString(this);
	}
}
