package io.vertigo.commons.impl.daemon;

import io.vertigo.commons.daemon.DaemonDefinition;
import io.vertigo.commons.daemon.DaemonStat;
import io.vertigo.lang.Assertion;

/**
 * Snapshot of execution's stats.
 * A snaphot is prefereed to a real time view to avoid complexity generated by "synchronized"
 * @author pchretien
 */
public final class DaemonStatImpl implements DaemonStat {
	private final DaemonDefinition daemonDefinition;
	private final DaemonStat.Status status;
	private final long sucesses;
	private final long failures;
	private final boolean lastExecSuccess;

	/**
	 * Constructor.
	 * @param daemonDefinition Deamon definition
	 * @param successes Nb success
	 * @param failures Nb failure
	 * @param status Current status
	 * @param lastExecSuccess if last exec was a success
	 */
	public DaemonStatImpl(final DaemonDefinition daemonDefinition, final long successes, final long failures, final DaemonStat.Status status, final boolean lastExecSuccess) {
		Assertion.checkNotNull(daemonDefinition);
		Assertion.checkNotNull(status);
		//-----
		this.daemonDefinition = daemonDefinition;
		this.failures = failures;
		sucesses = successes;
		this.status = status;
		this.lastExecSuccess = lastExecSuccess;
	}

	/** {@inheritDoc} */
	@Override
	public DaemonDefinition getDaemonDefinition() {
		return daemonDefinition;
	}

	/** {@inheritDoc} */
	@Override
	public long getCount() {
		return sucesses + failures;
	}

	/** {@inheritDoc} */
	@Override
	public long getSuccesses() {
		return sucesses;
	}

	/** {@inheritDoc} */
	@Override
	public long getFailures() {
		return failures;
	}

	/** {@inheritDoc} */
	@Override
	public boolean isLastExecSuccess() {
		return lastExecSuccess;
	}

	/** {@inheritDoc} */
	@Override
	public Status getStatus() {
		return status;
	}
}
