/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.std;

import cats.Applicative;
import cats.Foldable;
import cats.Invariant$;
import cats.UnorderedFoldable$;
import cats.arrow.FunctionK;
import cats.effect.kernel.Async;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Sync;
import cats.effect.kernel.syntax.MonadCancelOps_$;
import cats.effect.kernel.syntax.package;
import cats.effect.std.Semaphore$;
import cats.effect.std.Semaphore$impl$Done$;
import cats.effect.std.Semaphore$impl$Request$;
import cats.effect.std.Semaphore$impl$State$;
import cats.effect.std.Semaphore$impl$Wait$;
import cats.kernel.Monoid;
import cats.kernel.Semigroup$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.FlattenOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class Semaphore<F> {
    public static <F> Object apply(long l, GenConcurrent<F, ?> genConcurrent) {
        return Semaphore$.MODULE$.apply(l, genConcurrent);
    }

    public static <F, G> Object in(long l, Sync<F> sync, Async<G> async) {
        return Semaphore$.MODULE$.in(l, sync, async);
    }

    public abstract F available();

    public abstract F count();

    public abstract F acquireN(long var1);

    public F acquire() {
        return this.acquireN(1L);
    }

    public abstract F tryAcquireN(long var1);

    public F tryAcquire() {
        return this.tryAcquireN(1L);
    }

    public abstract F releaseN(long var1);

    public F release() {
        return this.releaseN(1L);
    }

    public abstract Resource<F, BoxedUnit> permit();

    public abstract <G> Semaphore<G> mapK(FunctionK<F, G> var1, MonadCancel<G, ?> var2);

    public static final class MapKSemaphore<F, G>
    extends Semaphore<G> {
        private final Semaphore<F> underlying;
        private final FunctionK<F, G> f;
        private final MonadCancel<F, ?> F;
        private final MonadCancel<G, ?> G;

        public MapKSemaphore(Semaphore<F> underlying, FunctionK<F, G> f, MonadCancel<F, ?> F, MonadCancel<G, ?> G) {
            this.underlying = underlying;
            this.f = f;
            this.F = F;
            this.G = G;
        }

        @Override
        public G available() {
            return (G)this.f.apply(this.underlying.available());
        }

        @Override
        public G count() {
            return (G)this.f.apply(this.underlying.count());
        }

        @Override
        public G acquireN(long n) {
            return (G)this.f.apply(this.underlying.acquireN(n));
        }

        @Override
        public G tryAcquireN(long n) {
            return (G)this.f.apply(this.underlying.tryAcquireN(n));
        }

        @Override
        public G releaseN(long n) {
            return (G)this.f.apply(this.underlying.releaseN(n));
        }

        @Override
        public Resource<G, BoxedUnit> permit() {
            return this.underlying.permit().mapK(this.f, this.F, this.G);
        }

        @Override
        public <H> Semaphore<H> mapK(FunctionK<G, H> f, MonadCancel<H, ?> H) {
            return new MapKSemaphore<G, H>(this, f, this.G, H);
        }
    }

    private static class impl<F> {
        private final long n;
        public final GenConcurrent<F, ?> cats$effect$std$Semaphore$impl$$F;
        public final Semaphore$impl$Request$ Request$lzy1;
        public final Semaphore$impl$State$ State$lzy1;
        private Semaphore$impl$Wait$ Wait$lzy1;
        private boolean Waitbitmap$1;
        private Semaphore$impl$Done$ Done$lzy1;
        private boolean Donebitmap$1;

        public impl(long n, GenConcurrent<F, ?> F) {
            this.n = n;
            this.cats$effect$std$Semaphore$impl$$F = F;
            this.Request$lzy1 = new Semaphore$impl$Request$(this);
            this.State$lzy1 = new Semaphore$impl$State$(this);
            this.requireNonNegative(n);
        }

        public void requireNonNegative(long n) {
            Predef$.MODULE$.require(n >= 0L, () -> this.requireNonNegative$$anonfun$1(n));
        }

        public final Semaphore$impl$Request$ Request() {
            return this.Request$lzy1;
        }

        public F newRequest() {
            return (F)package.all$.MODULE$.toFunctorOps(this.cats$effect$std$Semaphore$impl$$F.deferred(), this.cats$effect$std$Semaphore$impl$$F).map((Function1 & Serializable)_$7 -> this.Request().apply(0L, _$7));
        }

        public final Semaphore$impl$State$ State() {
            return this.State$lzy1;
        }

        public State initialState() {
            return this.State().apply(this.n, (Queue<Request>)Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])));
        }

        public final Semaphore$impl$Wait$ Wait() {
            if (!this.Waitbitmap$1) {
                this.Wait$lzy1 = new Semaphore$impl$Wait$();
                this.Waitbitmap$1 = true;
            }
            return this.Wait$lzy1;
        }

        public final Semaphore$impl$Done$ Done() {
            if (!this.Donebitmap$1) {
                this.Done$lzy1 = new Semaphore$impl$Done$();
                this.Donebitmap$1 = true;
            }
            return this.Done$lzy1;
        }

        public Semaphore<F> semaphore(Ref<F, State> state) {
            return new Semaphore<F>(state, this){
                private final Ref state$1;
                private final impl $outer;
                {
                    this.state$1 = state$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Object acquireN(long n) {
                    this.$outer.requireNonNegative(n);
                    return n == 0L ? this.$outer.cats$effect$std$Semaphore$impl$$F.unit() : this.$outer.cats$effect$std$Semaphore$impl$$F.uncancelable((Function1 & Serializable)poll -> package.all$.MODULE$.toFlatMapOps(this.$outer.newRequest(), this.$outer.cats$effect$std$Semaphore$impl$$F).flatMap((Function1 & Serializable)req -> {
                        Object object = package.all$.MODULE$.catsSyntaxFlatten(this.state$1.modify((Function1 & Serializable)x$12 -> {
                            Object object;
                            Tuple2 tuple2;
                            Tuple2 tuple22;
                            State state = x$12;
                            if (state == null) throw new MatchError((Object)state);
                            State state2 = this.$outer.State().unapply(state);
                            long l = state2._1();
                            Queue<Request> queue = state2._2();
                            long permits = l;
                            Queue<Request> waiting = queue;
                            if (waiting.nonEmpty()) {
                                State state3 = (State)Predef$.MODULE$.ArrowAssoc((Object)this.$outer.State().apply(0L, (Queue<Request>)waiting.enqueue((Object)req.of(n))));
                                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state3, (Object)this.$outer.Wait());
                            } else {
                                long diff = permits - n;
                                if (diff >= 0L) {
                                    State state4 = (State)Predef$.MODULE$.ArrowAssoc((Object)this.$outer.State().apply(diff, (Queue<Request>)Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))));
                                    tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state4, (Object)this.$outer.Done());
                                } else {
                                    Request request = (Request)package.all$.MODULE$.catsSyntaxApplicativeId((Object)req.of(RichLong$.MODULE$.abs$extension(Predef$.MODULE$.longWrapper(diff))));
                                    State state5 = (State)Predef$.MODULE$.ArrowAssoc((Object)this.$outer.State().apply(0L, (Queue<Request>)((Queue)ApplicativeIdOps$.MODULE$.pure$extension((Object)request, (Applicative)Invariant$.MODULE$.catsInstancesForQueue()))));
                                    tuple22 = tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state5, (Object)this.$outer.Wait());
                                }
                            }
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            State newState = (State)tuple2._1();
                            Action decision = (Action)tuple2._2();
                            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)newState, (Object)decision);
                            State newState2 = (State)tuple23._1();
                            Action decision2 = (Action)tuple23._2();
                            Object object2 = package.all$.MODULE$.catsSyntaxFlatten(this.state$1.modify((Function1 & Serializable)x$1 -> {
                                State state = x$1;
                                if (state == null) {
                                    throw new MatchError((Object)state);
                                }
                                State state2 = this.$outer.State().unapply(state);
                                long l = state2._1();
                                Queue<Request> queue = state2._2();
                                long permits = l;
                                Queue<Request> waiting = queue;
                                long permitsAcquiredSoFar = n - BoxesRunTime.unboxToLong((Object)package.all$.MODULE$.toFoldableOps((Object)waiting.find(arg_0 -> Semaphore$.cats$effect$std$Semaphore$$anon$1$$_$_$$anonfun$1(req, arg_0)), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForOption()).foldMap(Semaphore$::cats$effect$std$Semaphore$$anon$1$$_$_$$anonfun$2, (Monoid)Semigroup$.MODULE$.catsKernelCommutativeGroupForLong()));
                                Queue waitingNow = (Queue)waiting.filterNot(arg_0 -> Semaphore$.cats$effect$std$Semaphore$$anon$1$$_$_$$anonfun$3(req, arg_0));
                                State state3 = (State)Predef$.MODULE$.ArrowAssoc((Object)this.$outer.State().apply(permits, (Queue<Request>)waitingNow));
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state3, this.releaseN(permitsAcquiredSoFar));
                            }), this.$outer.cats$effect$std$Semaphore$impl$$F);
                            Object cleanup = FlattenOps$.MODULE$.flatten$extension(object2, this.$outer.cats$effect$std$Semaphore$impl$$F);
                            Action action = decision2;
                            if (this.$outer.Done().equals(action)) {
                                object = this.$outer.cats$effect$std$Semaphore$impl$$F.unit();
                            } else {
                                if (!this.$outer.Wait().equals(action)) throw new MatchError((Object)action);
                                Object object3 = package.all$.MODULE$.monadCancelOps_(poll.apply(req.wait_()));
                                object = MonadCancelOps_$.MODULE$.onCancel$extension(object3, cleanup, this.$outer.cats$effect$std$Semaphore$impl$$F);
                            }
                            Object action2 = object;
                            State state6 = (State)Predef$.MODULE$.ArrowAssoc((Object)newState2);
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state6, action2);
                        }), this.$outer.cats$effect$std$Semaphore$impl$$F);
                        return FlattenOps$.MODULE$.flatten$extension(object, this.$outer.cats$effect$std$Semaphore$impl$$F);
                    }));
                }

                public Object releaseN(long n) {
                    Object object;
                    this.$outer.requireNonNegative(n);
                    if (n == 0L) {
                        object = this.$outer.cats$effect$std$Semaphore$impl$$F.unit();
                    } else {
                        Object object2 = package.all$.MODULE$.catsSyntaxFlatten(this.state$1.modify((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2;
                            State state = x$1;
                            if (state != null) {
                                State state2 = this.$outer.State().unapply(state);
                                long l = state2._1();
                                Queue<Request> queue = state2._2();
                                long permits = l;
                                Queue<Request> waiting = queue;
                                if (waiting.isEmpty()) {
                                    State state3 = (State)Predef$.MODULE$.ArrowAssoc((Object)this.$outer.State().apply(permits + n, waiting));
                                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state3, this.$outer.cats$effect$std$Semaphore$impl$$F.unit());
                                } else {
                                    Tuple3 tuple3 = Semaphore$.cats$effect$std$Semaphore$$anon$1$$_$fulfil$1(n, waiting, Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])));
                                    if (tuple3 == null) {
                                        throw new MatchError((Object)tuple3);
                                    }
                                    long newN = BoxesRunTime.unboxToLong((Object)tuple3._1());
                                    Queue waitingNow = (Queue)tuple3._2();
                                    Queue wakeup = (Queue)tuple3._3();
                                    Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)newN), (Object)waitingNow, (Object)wakeup);
                                    long newN2 = BoxesRunTime.unboxToLong((Object)tuple32._1());
                                    Queue waitingNow2 = (Queue)tuple32._2();
                                    Queue wakeup2 = (Queue)tuple32._3();
                                    State state4 = (State)Predef$.MODULE$.ArrowAssoc((Object)this.$outer.State().apply(newN2, (Queue<Request>)waitingNow2));
                                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state4, package.all$.MODULE$.toFoldableOps((Object)wakeup2, (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForQueue()).traverse_(Semaphore$::cats$effect$std$Semaphore$$anon$1$$_$releaseN$$anonfun$1$$anonfun$1, this.$outer.cats$effect$std$Semaphore$impl$$F));
                                }
                            } else {
                                throw new MatchError((Object)state);
                            }
                            return tuple2;
                        }), this.$outer.cats$effect$std$Semaphore$impl$$F);
                        Object object3 = package.all$.MODULE$.monadCancelOps_(FlattenOps$.MODULE$.flatten$extension(object2, this.$outer.cats$effect$std$Semaphore$impl$$F));
                        object = MonadCancelOps_$.MODULE$.uncancelable$extension(object3, this.$outer.cats$effect$std$Semaphore$impl$$F);
                    }
                    return object;
                }

                public Object available() {
                    return package.all$.MODULE$.toFunctorOps(this.state$1.get(), this.$outer.cats$effect$std$Semaphore$impl$$F).map(Semaphore$::cats$effect$std$Semaphore$$anon$1$$_$available$$anonfun$1);
                }

                public Object count() {
                    return package.all$.MODULE$.toFunctorOps(this.state$1.get(), this.$outer.cats$effect$std$Semaphore$impl$$F).map((Function1 & Serializable)x$1 -> {
                        long permits;
                        Queue<Request> queue;
                        State state = x$1;
                        if (state != null) {
                            State state2 = this.$outer.State().unapply(state);
                            long l = state2._1();
                            queue = state2._2();
                            permits = l;
                        } else {
                            throw new MatchError((Object)state);
                        }
                        Queue<Request> waiting = queue;
                        return waiting.nonEmpty() ? -BoxesRunTime.unboxToLong((Object)package.all$.MODULE$.toFoldableOps(waiting, (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForQueue()).foldMap(Semaphore$::cats$effect$std$Semaphore$$anon$1$$_$count$$anonfun$1$$anonfun$1, (Monoid)Semigroup$.MODULE$.catsKernelCommutativeGroupForLong())) : permits;
                    });
                }

                public Resource permit() {
                    return Resource$.MODULE$.makeFull((Function1 & Serializable)poll -> poll.apply(this.acquire()), (Function1 & Serializable)_$14 -> this.release(), this.$outer.cats$effect$std$Semaphore$impl$$F);
                }

                public Object tryAcquireN(long n) {
                    this.$outer.requireNonNegative(n);
                    return n == 0L ? this.$outer.cats$effect$std$Semaphore$impl$$F.pure((Object)BoxesRunTime.boxToBoolean((boolean)true)) : this.state$1.modify(arg_0 -> Semaphore$.cats$effect$std$Semaphore$$anon$1$$_$tryAcquireN$$anonfun$1(n, arg_0));
                }

                public Semaphore mapK(FunctionK f, MonadCancel G) {
                    return new MapKSemaphore<F, G>(this, f, this.$outer.cats$effect$std$Semaphore$impl$$F, G);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{acquireN$$anonfun$1(long cats.effect.kernel.Poll ), releaseN$$anonfun$1(long cats.effect.std.Semaphore$impl$State ), cats$effect$std$Semaphore$$anon$1$$_$available$$anonfun$1(cats.effect.std.Semaphore$impl$State ), count$$anonfun$1(cats.effect.std.Semaphore$impl$State ), permit$$anonfun$1(cats.effect.kernel.Poll ), permit$$anonfun$2(scala.runtime.BoxedUnit ), cats$effect$std$Semaphore$$anon$1$$_$tryAcquireN$$anonfun$1(long cats.effect.std.Semaphore$impl$State ), cats$effect$std$Semaphore$$anon$1$$_$_$$anonfun$1(cats.effect.std.Semaphore$impl$Request cats.effect.std.Semaphore$impl$Request ), cats$effect$std$Semaphore$$anon$1$$_$_$$anonfun$2(cats.effect.std.Semaphore$impl$Request ), cats$effect$std$Semaphore$$anon$1$$_$_$$anonfun$3(cats.effect.std.Semaphore$impl$Request cats.effect.std.Semaphore$impl$Request ), $anonfun$1(long cats.effect.std.Semaphore$impl$Request cats.effect.std.Semaphore$impl$State ), acquireN$$anonfun$2$$anonfun$1$$anonfun$1(long cats.effect.kernel.Poll cats.effect.std.Semaphore$impl$Request cats.effect.std.Semaphore$impl$State ), acquireN$$anonfun$3$$anonfun$2(long cats.effect.kernel.Poll cats.effect.std.Semaphore$impl$Request ), cats$effect$std$Semaphore$$anon$1$$_$releaseN$$anonfun$1$$anonfun$1(cats.effect.std.Semaphore$impl$Request ), cats$effect$std$Semaphore$$anon$1$$_$count$$anonfun$1$$anonfun$1(cats.effect.std.Semaphore$impl$Request )}, serializedLambda);
                }
            };
        }

        private final String requireNonNegative$$anonfun$1(long n$1) {
            return "n must be nonnegative, was: " + n$1;
        }

        public interface Action {
        }

        public class Request
        implements Product,
        Serializable {
            private final long n;
            private final Deferred gate;
            private final impl<F> $outer;

            public Request(impl $outer, long n, Deferred<F, BoxedUnit> gate) {
                this.n = n;
                this.gate = gate;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)Statics.longHash((long)this.n()));
                n = Statics.mix((int)n, (int)Statics.anyHash(this.gate()));
                return Statics.finalizeHash((int)n, (int)2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Request)) return false;
                if (((Request)object).cats$effect$std$Semaphore$impl$Request$$$outer() != this.$outer) return false;
                Request request = (Request)object;
                if (this.n() != request.n()) return false;
                Deferred deferred = this.gate();
                Deferred deferred2 = request.gate();
                if (deferred == null) {
                    if (deferred2 != null) {
                        return false;
                    }
                } else if (!deferred.equals(deferred2)) return false;
                if (!request.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Request;
            }

            public int productArity() {
                return 2;
            }

            public String productPrefix() {
                return "Request";
            }

            public Object productElement(int n) {
                Deferred deferred;
                int n2 = n;
                if (0 == n2) {
                    deferred = BoxesRunTime.boxToLong((long)this._1());
                } else if (1 == n2) {
                    deferred = this._2();
                } else {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return deferred;
            }

            public String productElementName(int n) {
                String string;
                int n2 = n;
                if (0 == n2) {
                    string = "n";
                } else if (1 == n2) {
                    string = "gate";
                } else {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return string;
            }

            public long n() {
                return this.n;
            }

            public Deferred<F, BoxedUnit> gate() {
                return this.gate;
            }

            public boolean sameAs(Request r) {
                return r.gate() == this.gate();
            }

            public Request of(long newN) {
                return this.$outer.Request().apply(newN, this.gate());
            }

            public F wait_() {
                return this.gate().get();
            }

            public F complete() {
                return this.gate().complete((Object)BoxedUnit.UNIT);
            }

            public Request copy(long n, Deferred<F, BoxedUnit> gate) {
                return new Request(this.$outer, n, gate);
            }

            public long copy$default$1() {
                return this.n();
            }

            public Deferred<F, BoxedUnit> copy$default$2() {
                return this.gate();
            }

            public long _1() {
                return this.n();
            }

            public Deferred<F, BoxedUnit> _2() {
                return this.gate();
            }

            public final impl<F> cats$effect$std$Semaphore$impl$Request$$$outer() {
                return this.$outer;
            }
        }

        public class State
        implements Product,
        Serializable {
            private final long permits;
            private final Queue waiting;
            private final impl<F> $outer;

            public State(impl $outer, long permits, Queue<Request> waiting) {
                this.permits = permits;
                this.waiting = waiting;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)Statics.longHash((long)this.permits()));
                n = Statics.mix((int)n, (int)Statics.anyHash(this.waiting()));
                return Statics.finalizeHash((int)n, (int)2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof State)) return false;
                if (((State)object).cats$effect$std$Semaphore$impl$State$$$outer() != this.$outer) return false;
                State state = (State)object;
                if (this.permits() != state.permits()) return false;
                Queue<Request> queue = this.waiting();
                Queue<Request> queue2 = state.waiting();
                if (queue == null) {
                    if (queue2 != null) {
                        return false;
                    }
                } else if (!queue.equals(queue2)) return false;
                if (!state.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof State;
            }

            public int productArity() {
                return 2;
            }

            public String productPrefix() {
                return "State";
            }

            public Object productElement(int n) {
                Queue<Request> queue;
                int n2 = n;
                if (0 == n2) {
                    queue = BoxesRunTime.boxToLong((long)this._1());
                } else if (1 == n2) {
                    queue = this._2();
                } else {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return queue;
            }

            public String productElementName(int n) {
                String string;
                int n2 = n;
                if (0 == n2) {
                    string = "permits";
                } else if (1 == n2) {
                    string = "waiting";
                } else {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return string;
            }

            public long permits() {
                return this.permits;
            }

            public Queue<Request> waiting() {
                return this.waiting;
            }

            public State copy(long permits, Queue<Request> waiting) {
                return new State(this.$outer, permits, waiting);
            }

            public long copy$default$1() {
                return this.permits();
            }

            public Queue<Request> copy$default$2() {
                return this.waiting();
            }

            public long _1() {
                return this.permits();
            }

            public Queue<Request> _2() {
                return this.waiting();
            }

            public final impl<F> cats$effect$std$Semaphore$impl$State$$$outer() {
                return this.$outer;
            }
        }
    }
}

