/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.std;

import cats.Applicative$;
import cats.Monad$;
import cats.arrow.FunctionK;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Ref$;
import cats.effect.kernel.Sync;
import cats.effect.kernel.Sync$;
import cats.syntax.ApplicativeErrorIdOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public interface Random<F> {
    public F betweenDouble(double var1, double var3);

    public F betweenFloat(float var1, float var2);

    public F betweenInt(int var1, int var2);

    public F betweenLong(long var1, long var3);

    public F nextAlphaNumeric();

    public F nextBoolean();

    public F nextBytes(int var1);

    public F nextDouble();

    public F nextFloat();

    public F nextGaussian();

    public F nextInt();

    public F nextIntBounded(int var1);

    public F nextLong();

    public F nextLongBounded(long var1);

    public F nextPrintableChar();

    public F nextString(int var1);

    public <A> F shuffleList(List<A> var1);

    public <A> F shuffleVector(Vector<A> var1);

    public static Random mapK$(Random $this, FunctionK f) {
        return $this.mapK(f);
    }

    default public <G> Random<G> mapK(FunctionK<F, G> f) {
        return new Random<G>(f, this){
            private final FunctionK f$1;
            private final Random $outer;
            {
                this.f$1 = f$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Object betweenDouble(double minInclusive, double maxExclusive) {
                return this.f$1.apply(this.$outer.betweenDouble(minInclusive, maxExclusive));
            }

            public Object betweenFloat(float minInclusive, float maxExclusive) {
                return this.f$1.apply(this.$outer.betweenFloat(minInclusive, maxExclusive));
            }

            public Object betweenInt(int minInclusive, int maxExclusive) {
                return this.f$1.apply(this.$outer.betweenInt(minInclusive, maxExclusive));
            }

            public Object betweenLong(long minInclusive, long maxExclusive) {
                return this.f$1.apply(this.$outer.betweenLong(minInclusive, maxExclusive));
            }

            public Object nextAlphaNumeric() {
                return this.f$1.apply(this.$outer.nextAlphaNumeric());
            }

            public Object nextBoolean() {
                return this.f$1.apply(this.$outer.nextBoolean());
            }

            public Object nextBytes(int n) {
                return this.f$1.apply(this.$outer.nextBytes(n));
            }

            public Object nextDouble() {
                return this.f$1.apply(this.$outer.nextDouble());
            }

            public Object nextFloat() {
                return this.f$1.apply(this.$outer.nextFloat());
            }

            public Object nextGaussian() {
                return this.f$1.apply(this.$outer.nextGaussian());
            }

            public Object nextInt() {
                return this.f$1.apply(this.$outer.nextInt());
            }

            public Object nextIntBounded(int n) {
                return this.f$1.apply(this.$outer.nextIntBounded(n));
            }

            public Object nextLong() {
                return this.f$1.apply(this.$outer.nextLong());
            }

            public Object nextLongBounded(long n) {
                return this.f$1.apply(this.$outer.nextLongBounded(n));
            }

            public Object nextPrintableChar() {
                return this.f$1.apply(this.$outer.nextPrintableChar());
            }

            public Object nextString(int length) {
                return this.f$1.apply(this.$outer.nextString(length));
            }

            public Object shuffleList(List l) {
                return this.f$1.apply(this.$outer.shuffleList(l));
            }

            public Object shuffleVector(Vector v) {
                return this.f$1.apply(this.$outer.shuffleVector(v));
            }
        };
    }

    private static abstract class ScalaRandom<F>
    implements Random<F> {
        private final F f;
        private final Sync<F> evidence$24;

        public ScalaRandom(Object f, Sync<F> evidence$24) {
            this.f = f;
            this.evidence$24 = evidence$24;
        }

        @Override
        public F betweenLong(long minInclusive, long maxExclusive) {
            long difference = maxExclusive - minInclusive;
            return (F)package.all$.MODULE$.catsSyntaxApply(this.require(minInclusive < maxExclusive, (Function0<String>)((Function0 & Serializable)this::betweenLong$$anonfun$1)), this.evidence$24).$times$greater(package.all$.MODULE$.toFunctorOps(difference >= 0L ? package.all$.MODULE$.toFunctorOps(this.nextLongBounded(difference), this.evidence$24).map((Function1 & Serializable)_$29 -> this.betweenLong$$anonfun$2(minInclusive, BoxesRunTime.unboxToLong((Object)_$29))) : this.loop$1(minInclusive, maxExclusive), this.evidence$24).map((Function1 & Serializable)out -> this.betweenLong$$anonfun$3(BoxesRunTime.unboxToLong((Object)out))));
        }

        @Override
        public F betweenInt(int minInclusive, int maxExclusive) {
            int difference = maxExclusive - minInclusive;
            return (F)package.all$.MODULE$.catsSyntaxApply(this.require(minInclusive < maxExclusive, (Function0<String>)((Function0 & Serializable)this::betweenInt$$anonfun$1)), this.evidence$24).$times$greater(package.all$.MODULE$.toFunctorOps(difference >= 0 ? package.all$.MODULE$.toFunctorOps(this.nextIntBounded(difference), this.evidence$24).map((Function1 & Serializable)_$30 -> this.betweenInt$$anonfun$2(minInclusive, BoxesRunTime.unboxToInt((Object)_$30))) : this.loop$2(minInclusive, maxExclusive), this.evidence$24).map((Function1 & Serializable)out -> this.betweenInt$$anonfun$3(BoxesRunTime.unboxToInt((Object)out))));
        }

        @Override
        public F betweenFloat(float minInclusive, float maxExclusive) {
            return (F)package.all$.MODULE$.toFlatMapOps(this.require(minInclusive < maxExclusive, (Function0<String>)((Function0 & Serializable)this::betweenFloat$$anonfun$1)), this.evidence$24).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                return package.all$.MODULE$.toFunctorOps(this.nextFloat(), this.evidence$24).map((Function1 & Serializable)f -> this.betweenFloat$$anonfun$3$$anonfun$1(minInclusive, maxExclusive, BoxesRunTime.unboxToFloat((Object)f)));
            });
        }

        @Override
        public F betweenDouble(double minInclusive, double maxExclusive) {
            return (F)package.all$.MODULE$.toFlatMapOps(this.require(minInclusive < maxExclusive, (Function0<String>)((Function0 & Serializable)this::betweenDouble$$anonfun$1)), this.evidence$24).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                return package.all$.MODULE$.toFunctorOps(this.nextDouble(), this.evidence$24).map((Function1 & Serializable)d -> this.betweenDouble$$anonfun$3$$anonfun$1(minInclusive, maxExclusive, BoxesRunTime.unboxToDouble((Object)d)));
            });
        }

        @Override
        public F nextAlphaNumeric() {
            String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
            return (F)package.all$.MODULE$.toFunctorOps(this.nextIntBounded(chars.length()), this.evidence$24).map((Function1 & Serializable)_$31 -> this.nextAlphaNumeric$$anonfun$1(chars, BoxesRunTime.unboxToInt((Object)_$31)));
        }

        @Override
        public F nextBoolean() {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$24).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$24).delay(() -> this.nextBoolean$$anonfun$2$$anonfun$1(r)), this.evidence$24).map((Function1 & Serializable)out -> this.nextBoolean$$anonfun$3$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)out))));
        }

        @Override
        public F nextBytes(int n) {
            return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.f, this.evidence$24).map((Function1 & Serializable)r -> {
                byte[] bytes = new byte[RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), n)];
                return Tuple2$.MODULE$.apply(r, (Object)bytes);
            }), this.evidence$24).flatMap((Function1 & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                scala.util.Random r = (scala.util.Random)tuple2._1();
                byte[] bytes = (byte[])tuple2._2();
                return package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$24).delay((Function0 & Serializable)() -> {
                    this.nextBytes$$anonfun$3$$anonfun$1(r, bytes);
                    return BoxedUnit.UNIT;
                }), this.evidence$24).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = x$1;
                    return bytes;
                });
            });
        }

        @Override
        public F nextDouble() {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$24).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$24).delay(() -> this.nextDouble$$anonfun$2$$anonfun$1(r)), this.evidence$24).map((Function1 & Serializable)out -> this.nextDouble$$anonfun$3$$anonfun$2(BoxesRunTime.unboxToDouble((Object)out))));
        }

        @Override
        public F nextFloat() {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$24).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$24).delay(() -> this.nextFloat$$anonfun$2$$anonfun$1(r)), this.evidence$24).map((Function1 & Serializable)out -> this.nextFloat$$anonfun$3$$anonfun$2(BoxesRunTime.unboxToFloat((Object)out))));
        }

        @Override
        public F nextGaussian() {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$24).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$24).delay(() -> this.nextGaussian$$anonfun$2$$anonfun$1(r)), this.evidence$24).map((Function1 & Serializable)out -> this.nextGaussian$$anonfun$3$$anonfun$2(BoxesRunTime.unboxToDouble((Object)out))));
        }

        @Override
        public F nextInt() {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$24).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$24).delay(() -> this.nextInt$$anonfun$2$$anonfun$1(r)), this.evidence$24).map((Function1 & Serializable)out -> this.nextInt$$anonfun$3$$anonfun$2(BoxesRunTime.unboxToInt((Object)out))));
        }

        @Override
        public F nextIntBounded(int n) {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$24).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$24).delay(() -> this.nextIntBounded$$anonfun$2$$anonfun$1(n, r)), this.evidence$24).map((Function1 & Serializable)out -> this.nextIntBounded$$anonfun$3$$anonfun$2(BoxesRunTime.unboxToInt((Object)out))));
        }

        @Override
        public F nextLong() {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$24).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$24).delay(() -> this.nextLong$$anonfun$2$$anonfun$1(r)), this.evidence$24).map((Function1 & Serializable)out -> this.nextLong$$anonfun$3$$anonfun$2(BoxesRunTime.unboxToLong((Object)out))));
        }

        @Override
        public F nextLongBounded(long n) {
            return (F)package.all$.MODULE$.toFlatMapOps(this.require(n > 0L, (Function0<String>)((Function0 & Serializable)() -> this.nextLongBounded$$anonfun$1(n))), this.evidence$24).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                Ref.Make make = Ref$.MODULE$.apply(Ref.Make$.MODULE$.syncInstance(this.evidence$24));
                return package.all$.MODULE$.toFlatMapOps(Ref.ApplyBuilders$.MODULE$.of$extension(make, (Object)BoxesRunTime.boxToLong((long)0L)), this.evidence$24).flatMap((Function1 & Serializable)offset -> {
                    Ref.Make make = Ref$.MODULE$.apply(Ref.Make$.MODULE$.syncInstance(this.evidence$24));
                    return package.all$.MODULE$.toFlatMapOps(Ref.ApplyBuilders$.MODULE$.of$extension(make, (Object)BoxesRunTime.boxToLong((long)n)), this.evidence$24).flatMap((Function1 & Serializable)_n -> package.all$.MODULE$.toFlatMapOps(Monad$.MODULE$.apply(this.evidence$24).whileM_(package.all$.MODULE$.toFunctorOps(_n.get(), this.evidence$24).map((Function1 & Serializable)_$32 -> this.nextLongBounded$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToLong((Object)_$32))), () -> this.nextLongBounded$$anonfun$22$$anonfun$20$$anonfun$20$$anonfun$19(offset, _n)), this.evidence$24).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = x$1;
                        return package.all$.MODULE$.toFlatMapOps(offset.get(), this.evidence$24).flatMap((Function1 & Serializable)finalOffset -> this.nextLongBounded$$anonfun$27$$anonfun$25$$anonfun$25$$anonfun$24$$anonfun$5((Ref)_n, BoxesRunTime.unboxToLong((Object)finalOffset)));
                    }));
                });
            });
        }

        @Override
        public F nextPrintableChar() {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$24).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$24).delay(() -> this.nextPrintableChar$$anonfun$2$$anonfun$1(r)), this.evidence$24).map((Function1 & Serializable)out -> this.nextPrintableChar$$anonfun$3$$anonfun$2(BoxesRunTime.unboxToChar((Object)out))));
        }

        @Override
        public F nextString(int length) {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$24).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$24).delay(() -> this.nextString$$anonfun$2$$anonfun$1(length, r)), this.evidence$24).map((Function1 & Serializable)out -> out));
        }

        @Override
        public <A> F shuffleList(List<A> l) {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$24).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$24).delay(() -> this.shuffleList$$anonfun$2$$anonfun$1(l, r)), this.evidence$24).map((Function1 & Serializable)out -> out));
        }

        @Override
        public <A> F shuffleVector(Vector<A> v) {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$24).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$24).delay(() -> this.shuffleVector$$anonfun$2$$anonfun$1(v, r)), this.evidence$24).map((Function1 & Serializable)out -> out));
        }

        private F require(boolean condition, Function0<String> errorMessage) {
            Object object;
            if (condition) {
                BoxedUnit boxedUnit = (BoxedUnit)package.all$.MODULE$.catsSyntaxApplicativeId((Object)BoxedUnit.UNIT);
                object = ApplicativeIdOps$.MODULE$.pure$extension((Object)boxedUnit, this.evidence$24);
            } else {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)package.all$.MODULE$.catsSyntaxApplicativeErrorId((Object)new IllegalArgumentException((String)errorMessage.apply()));
                object = ApplicativeErrorIdOps$.MODULE$.raiseError$extension((Object)illegalArgumentException, this.evidence$24);
            }
            return (F)object;
        }

        private final String betweenLong$$anonfun$1() {
            return "Invalid bounds";
        }

        private final /* synthetic */ long betweenLong$$anonfun$2(long minInclusive$1, long _$29) {
            return _$29 + minInclusive$1;
        }

        private final /* synthetic */ Object loop$3$$anonfun$1(long minInclusive$3, long maxExclusive$2, long n) {
            Object object;
            if (n >= minInclusive$3 && n < maxExclusive$2) {
                Long l = (Long)package.all$.MODULE$.catsSyntaxApplicativeId((Object)BoxesRunTime.boxToLong((long)n));
                object = ApplicativeIdOps$.MODULE$.pure$extension((Object)l, this.evidence$24);
            } else {
                object = this.loop$1(minInclusive$3, maxExclusive$2);
            }
            return object;
        }

        private final Object loop$1(long minInclusive$2, long maxExclusive$1) {
            return package.all$.MODULE$.toFlatMapOps(this.nextLong(), this.evidence$24).flatMap((Function1 & Serializable)n -> this.loop$3$$anonfun$1(minInclusive$2, maxExclusive$1, BoxesRunTime.unboxToLong((Object)n)));
        }

        private final /* synthetic */ long betweenLong$$anonfun$3(long out) {
            return out;
        }

        private final String betweenInt$$anonfun$1() {
            return "Invalid bounds";
        }

        private final /* synthetic */ int betweenInt$$anonfun$2(int minInclusive$4, int _$30) {
            return _$30 + minInclusive$4;
        }

        private final /* synthetic */ Object loop$5$$anonfun$1(int minInclusive$6, int maxExclusive$4, int n) {
            Object object;
            if (n >= minInclusive$6 && n < maxExclusive$4) {
                Integer n2 = (Integer)package.all$.MODULE$.catsSyntaxApplicativeId((Object)BoxesRunTime.boxToInteger((int)n));
                object = ApplicativeIdOps$.MODULE$.pure$extension((Object)n2, this.evidence$24);
            } else {
                object = this.loop$2(minInclusive$6, maxExclusive$4);
            }
            return object;
        }

        private final Object loop$2(int minInclusive$5, int maxExclusive$3) {
            return package.all$.MODULE$.toFlatMapOps(this.nextInt(), this.evidence$24).flatMap((Function1 & Serializable)n -> this.loop$5$$anonfun$1(minInclusive$5, maxExclusive$3, BoxesRunTime.unboxToInt((Object)n)));
        }

        private final /* synthetic */ int betweenInt$$anonfun$3(int out) {
            return out;
        }

        private final String betweenFloat$$anonfun$1() {
            return "Invalid bounds";
        }

        private final /* synthetic */ float betweenFloat$$anonfun$3$$anonfun$1(float minInclusive$8, float maxExclusive$6, float f) {
            float next = f * (maxExclusive$6 - minInclusive$8) + minInclusive$8;
            return next < maxExclusive$6 ? next : Math.nextAfter(maxExclusive$6, Double.NEGATIVE_INFINITY);
        }

        private final String betweenDouble$$anonfun$1() {
            return "Invalid bounds";
        }

        private final /* synthetic */ double betweenDouble$$anonfun$3$$anonfun$1(double minInclusive$10, double maxExclusive$8, double d) {
            double next = d * (maxExclusive$8 - minInclusive$10) + minInclusive$10;
            return next < maxExclusive$8 ? next : Math.nextAfter(maxExclusive$8, Double.NEGATIVE_INFINITY);
        }

        private final /* synthetic */ char nextAlphaNumeric$$anonfun$1(String chars$1, int _$31) {
            return chars$1.charAt(_$31);
        }

        private final boolean nextBoolean$$anonfun$2$$anonfun$1(scala.util.Random r$1) {
            return r$1.nextBoolean();
        }

        private final /* synthetic */ boolean nextBoolean$$anonfun$3$$anonfun$2(boolean out) {
            return out;
        }

        private final void nextBytes$$anonfun$3$$anonfun$1(scala.util.Random r$2, byte[] bytes$1) {
            r$2.nextBytes(bytes$1);
        }

        private final double nextDouble$$anonfun$2$$anonfun$1(scala.util.Random r$3) {
            return r$3.nextDouble();
        }

        private final /* synthetic */ double nextDouble$$anonfun$3$$anonfun$2(double out) {
            return out;
        }

        private final float nextFloat$$anonfun$2$$anonfun$1(scala.util.Random r$4) {
            return r$4.nextFloat();
        }

        private final /* synthetic */ float nextFloat$$anonfun$3$$anonfun$2(float out) {
            return out;
        }

        private final double nextGaussian$$anonfun$2$$anonfun$1(scala.util.Random r$5) {
            return r$5.nextGaussian();
        }

        private final /* synthetic */ double nextGaussian$$anonfun$3$$anonfun$2(double out) {
            return out;
        }

        private final int nextInt$$anonfun$2$$anonfun$1(scala.util.Random r$6) {
            return r$6.nextInt();
        }

        private final /* synthetic */ int nextInt$$anonfun$3$$anonfun$2(int out) {
            return out;
        }

        private final int nextIntBounded$$anonfun$2$$anonfun$1(int n$16, scala.util.Random r$7) {
            return r$7.self().nextInt(n$16);
        }

        private final /* synthetic */ int nextIntBounded$$anonfun$3$$anonfun$2(int out) {
            return out;
        }

        private final long nextLong$$anonfun$2$$anonfun$1(scala.util.Random r$8) {
            return r$8.nextLong();
        }

        private final /* synthetic */ long nextLong$$anonfun$3$$anonfun$2(long out) {
            return out;
        }

        private final String nextLongBounded$$anonfun$1(long n$18) {
            return "n must be positive, but was " + n$18;
        }

        private final /* synthetic */ boolean nextLongBounded$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1(long _$32) {
            return _$32 >= Integer.MAX_VALUE;
        }

        private final /* synthetic */ long nextLongBounded$$anonfun$5$$anonfun$3$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$1(long _$33) {
            return _$33 >>> 1;
        }

        private final /* synthetic */ long nextLongBounded$$anonfun$7$$anonfun$5$$anonfun$5$$anonfun$4$$anonfun$3$$anonfun$2$$anonfun$1(long halfn$1, long _$34) {
            return _$34 - halfn$1;
        }

        private final /* synthetic */ long nextLongBounded$$anonfun$9$$anonfun$7$$anonfun$7$$anonfun$6$$anonfun$5$$anonfun$4$$anonfun$2$$anonfun$1$$anonfun$1(long nextN$2, long n$21, long _$35) {
            return _$35 + (n$21 - nextN$2);
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$11$$anonfun$9$$anonfun$9$$anonfun$8$$anonfun$7$$anonfun$6$$anonfun$4$$anonfun$3(Ref offset$6, long nextN$1, long n) {
            return offset$6.update((Function1 & Serializable)_$35 -> this.nextLongBounded$$anonfun$9$$anonfun$7$$anonfun$7$$anonfun$6$$anonfun$5$$anonfun$4$$anonfun$2$$anonfun$1$$anonfun$1(nextN$1, n, BoxesRunTime.unboxToLong((Object)_$35)));
        }

        private final /* synthetic */ void nextLongBounded$$anonfun$13$$anonfun$11$$anonfun$11$$anonfun$10$$anonfun$9$$anonfun$8$$anonfun$6$$anonfun$4$$anonfun$1(BoxedUnit x$1) {
            BoxedUnit boxedUnit = x$1;
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$16$$anonfun$14$$anonfun$14$$anonfun$13$$anonfun$12$$anonfun$11$$anonfun$9(Ref offset$4, Ref _n$4, int bits$2, long nextN) {
            return package.all$.MODULE$.toFlatMapOps((bits$2 & 1) == 0 ? package.all$.MODULE$.toFlatMapOps(_n$4.get(), this.evidence$24).flatMap((Function1 & Serializable)n -> this.nextLongBounded$$anonfun$11$$anonfun$9$$anonfun$9$$anonfun$8$$anonfun$7$$anonfun$6$$anonfun$4$$anonfun$3(offset$4, nextN, BoxesRunTime.unboxToLong((Object)n))) : Applicative$.MODULE$.apply(this.evidence$24).unit(), this.evidence$24).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = x$12;
                return package.all$.MODULE$.toFunctorOps(_n$4.set((Object)BoxesRunTime.boxToLong((long)nextN)), this.evidence$24).map((Function1 & Serializable)x$1 -> {
                    this.nextLongBounded$$anonfun$13$$anonfun$11$$anonfun$11$$anonfun$10$$anonfun$9$$anonfun$8$$anonfun$6$$anonfun$4$$anonfun$1((BoxedUnit)x$1);
                    return BoxedUnit.UNIT;
                });
            });
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$18$$anonfun$16$$anonfun$16$$anonfun$15$$anonfun$14$$anonfun$13(Ref offset$3, Ref _n$3, int bits$1, long halfn) {
            Object object;
            if ((bits$1 & 2) == 0) {
                Long l = (Long)package.all$.MODULE$.catsSyntaxApplicativeId((Object)BoxesRunTime.boxToLong((long)halfn));
                object = ApplicativeIdOps$.MODULE$.pure$extension((Object)l, this.evidence$24);
            } else {
                object = package.all$.MODULE$.toFunctorOps(_n$3.get(), this.evidence$24).map((Function1 & Serializable)_$34 -> this.nextLongBounded$$anonfun$7$$anonfun$5$$anonfun$5$$anonfun$4$$anonfun$3$$anonfun$2$$anonfun$1(halfn, BoxesRunTime.unboxToLong((Object)_$34)));
            }
            return package.all$.MODULE$.toFlatMapOps(object, this.evidence$24).flatMap((Function1 & Serializable)nextN -> this.nextLongBounded$$anonfun$16$$anonfun$14$$anonfun$14$$anonfun$13$$anonfun$12$$anonfun$11$$anonfun$9(offset$3, _n$3, bits$1, BoxesRunTime.unboxToLong((Object)nextN)));
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$20$$anonfun$18$$anonfun$18$$anonfun$17$$anonfun$16(Ref offset$2, Ref _n$2, int bits) {
            return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(_n$2.get(), this.evidence$24).map((Function1 & Serializable)_$33 -> this.nextLongBounded$$anonfun$5$$anonfun$3$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToLong((Object)_$33))), this.evidence$24).flatMap((Function1 & Serializable)halfn -> this.nextLongBounded$$anonfun$18$$anonfun$16$$anonfun$16$$anonfun$15$$anonfun$14$$anonfun$13(offset$2, _n$2, bits, BoxesRunTime.unboxToLong((Object)halfn)));
        }

        private final Object nextLongBounded$$anonfun$22$$anonfun$20$$anonfun$20$$anonfun$19(Ref offset$1, Ref _n$1) {
            return package.all$.MODULE$.toFlatMapOps(this.nextIntBounded(2), this.evidence$24).flatMap((Function1 & Serializable)bits -> this.nextLongBounded$$anonfun$20$$anonfun$18$$anonfun$18$$anonfun$17$$anonfun$16(offset$1, _n$1, BoxesRunTime.unboxToInt((Object)bits)));
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$23$$anonfun$21$$anonfun$21$$anonfun$20$$anonfun$1$$anonfun$1(long l) {
            return this.nextIntBounded((int)l);
        }

        private final /* synthetic */ long nextLongBounded$$anonfun$25$$anonfun$23$$anonfun$23$$anonfun$22$$anonfun$3$$anonfun$2(long finalOffset$1, int n) {
            return finalOffset$1 + (long)n;
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$27$$anonfun$25$$anonfun$25$$anonfun$24$$anonfun$5(Ref _n$7, long finalOffset) {
            return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(_n$7.get(), this.evidence$24).flatMap((Function1 & Serializable)l -> this.nextLongBounded$$anonfun$23$$anonfun$21$$anonfun$21$$anonfun$20$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToLong((Object)l))), this.evidence$24).map((Function1 & Serializable)object -> this.nextLongBounded$$anonfun$25$$anonfun$23$$anonfun$23$$anonfun$22$$anonfun$3$$anonfun$2(finalOffset, BoxesRunTime.unboxToInt((Object)object)));
        }

        private final char nextPrintableChar$$anonfun$2$$anonfun$1(scala.util.Random r$9) {
            return r$9.nextPrintableChar();
        }

        private final /* synthetic */ char nextPrintableChar$$anonfun$3$$anonfun$2(char out) {
            return out;
        }

        private final String nextString$$anonfun$2$$anonfun$1(int length$1, scala.util.Random r$10) {
            return r$10.nextString(length$1);
        }

        private final List shuffleList$$anonfun$2$$anonfun$1(List l$1, scala.util.Random r$11) {
            return (List)r$11.shuffle((IterableOnce)l$1, BuildFrom$.MODULE$.buildFromIterableOps());
        }

        private final Vector shuffleVector$$anonfun$2$$anonfun$1(Vector v$1, scala.util.Random r$12) {
            return (Vector)r$12.shuffle((IterableOnce)v$1, BuildFrom$.MODULE$.buildFromIterableOps());
        }
    }
}

