/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.std;

import cats.Functor;
import cats.Invariant;
import cats.arrow.FunctionK;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Ref;
import cats.effect.kernel.syntax.MonadCancelOps_$;
import cats.effect.kernel.syntax.package;
import cats.effect.std.PQueue$;
import cats.effect.std.PQueue$State$;
import cats.effect.std.PQueueSink;
import cats.effect.std.PQueueSource;
import cats.effect.std.internal.BinomialHeap;
import cats.implicits$;
import cats.kernel.Order;
import cats.syntax.FlattenOps$;
import cats.syntax.OptionIdOps$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.immutable.Queue;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class PQueue<F, A>
implements PQueueSource<F, A>,
PQueueSink<F, A> {
    public static <F, A> Object bounded(int n, GenConcurrent<F, Throwable> genConcurrent, Order<A> order) {
        return PQueue$.MODULE$.bounded(n, genConcurrent, order);
    }

    public static <F> Invariant<PQueue> catsInvariantForPQueue(Functor<F> functor) {
        return PQueue$.MODULE$.catsInvariantForPQueue(functor);
    }

    public static <F, A> Object unbounded(GenConcurrent<F, Throwable> genConcurrent, Order<A> order) {
        return PQueue$.MODULE$.unbounded(genConcurrent, order);
    }

    public <G> PQueue<G, A> mapK(FunctionK<F, G> f) {
        return new PQueue<G, A>(f, this){
            private final FunctionK f$1;
            private final Object take;
            private final Object tryTake;
            private final PQueue $outer;
            {
                this.f$1 = f$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.take = f$1.apply($outer.take());
                this.tryTake = f$1.apply($outer.tryTake());
            }

            public Object offer(Object a) {
                return this.f$1.apply(this.$outer.offer(a));
            }

            public Object tryOffer(Object a) {
                return this.f$1.apply(this.$outer.tryOffer(a));
            }

            public Object size() {
                return this.f$1.apply(this.$outer.size());
            }

            public Object take() {
                return this.take;
            }

            public Object tryTake() {
                return this.tryTake;
            }
        };
    }

    public static abstract class PQueueImpl<F, A>
    extends PQueue<F, A> {
        private final Ref<F, State<F, A>> ref;
        private final int capacity;
        private final GenConcurrent<F, Throwable> F;

        public PQueueImpl(Ref<F, State<F, A>> ref, int capacity, GenConcurrent<F, Throwable> F) {
            this.ref = ref;
            this.capacity = capacity;
            this.F = F;
        }

        public abstract Order<A> Ord();

        @Override
        public F offer(A a) {
            return (F)implicits$.MODULE$.toFlatMapOps(this.F.deferred(), this.F).flatMap((Function1 & Serializable)offerer -> this.F.uncancelable((Function1 & Serializable)poll -> {
                Object object = implicits$.MODULE$.catsSyntaxFlatten(this.ref.modify((Function1 & Serializable)x$1 -> {
                    State s2;
                    State state;
                    Tuple2 tuple2;
                    State state2 = x$1;
                    if (state2 != null) {
                        State state3 = PQueue$State$.MODULE$.unapply(state2);
                        BinomialHeap<Object> binomialHeap = state3._1();
                        int n = state3._2();
                        Queue queue = state3._3();
                        Queue queue2 = state3._4();
                        BinomialHeap<Object> heap = binomialHeap;
                        int size = n;
                        Queue takers = queue;
                        Queue offerers = queue2;
                        if (takers.nonEmpty()) {
                            Tuple2 tuple22 = takers.dequeue();
                            if (tuple22 == null) throw new MatchError((Object)tuple22);
                            Deferred taker = (Deferred)tuple22._1();
                            Queue rest = (Queue)tuple22._2();
                            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)taker, (Object)rest);
                            Deferred taker2 = (Deferred)tuple23._1();
                            Queue rest2 = (Queue)tuple23._2();
                            State state4 = (State)Predef$.MODULE$.ArrowAssoc(PQueue$State$.MODULE$.apply(heap, size, rest2, offerers));
                            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state4, implicits$.MODULE$.toFunctorOps(taker2.complete(a), this.F).void());
                            return tuple2;
                        }
                        BinomialHeap<Object> heap2 = binomialHeap;
                        int size2 = n;
                        Queue takers2 = queue;
                        Queue offerers2 = queue2;
                        if (size2 < this.capacity) {
                            State state5 = (State)Predef$.MODULE$.ArrowAssoc(PQueue$State$.MODULE$.apply(heap2.insert(a), size2 + 1, takers2, offerers2));
                            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state5, this.F.unit());
                            return tuple2;
                        }
                    }
                    if ((state = (s2 = state2)) == null) throw new MatchError((Object)state);
                    State state6 = PQueue$State$.MODULE$.unapply(state);
                    BinomialHeap binomialHeap = state6._1();
                    int n = state6._2();
                    Queue queue = state6._3();
                    Queue queue3 = state6._4();
                    BinomialHeap heap = binomialHeap;
                    int size = n;
                    Queue takers = queue;
                    Queue offerers = queue3;
                    Tuple4 tuple4 = Tuple4$.MODULE$.apply(heap, (Object)BoxesRunTime.boxToInteger((int)size), takers, offerers);
                    BinomialHeap heap3 = (BinomialHeap)tuple4._1();
                    int size3 = BoxesRunTime.unboxToInt((Object)tuple4._2());
                    Queue takers3 = (Queue)tuple4._3();
                    Queue offerers3 = (Queue)tuple4._4();
                    Object cleanup = this.ref.update((Function1 & Serializable)s -> {
                        Queue queue = (Queue)s.offerers().filter((Function1 & Serializable)_$6 -> _$6._2() != offerer);
                        BinomialHeap binomialHeap = s.copy$default$1();
                        int n = s.copy$default$2();
                        Queue queue2 = s.copy$default$3();
                        return s.copy(binomialHeap, n, queue2, queue);
                    });
                    Object object = Predef$.MODULE$.ArrowAssoc(a);
                    State state7 = (State)Predef$.MODULE$.ArrowAssoc(PQueue$State$.MODULE$.apply(heap3, size3, takers3, offerers3.enqueue((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, offerer))));
                    Object object2 = package.all$.MODULE$.monadCancelOps_(poll.apply(offerer.get()));
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state7, MonadCancelOps_$.MODULE$.onCancel$extension(object2, cleanup, this.F));
                    return tuple2;
                }), this.F);
                return FlattenOps$.MODULE$.flatten$extension(object, this.F);
            }));
        }

        @Override
        public F tryOffer(A a) {
            Object object = implicits$.MODULE$.catsSyntaxFlatten(this.ref.modify((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                State state = x$1;
                if (state != null) {
                    State state2 = PQueue$State$.MODULE$.unapply(state);
                    BinomialHeap<Object> binomialHeap = state2._1();
                    int n = state2._2();
                    Queue queue = state2._3();
                    Queue queue2 = state2._4();
                    BinomialHeap<Object> heap = binomialHeap;
                    int size = n;
                    Queue takers = queue;
                    Queue offerers = queue2;
                    if (takers.nonEmpty()) {
                        Tuple2 tuple22 = takers.dequeue();
                        if (tuple22 == null) throw new MatchError((Object)tuple22);
                        Deferred taker = (Deferred)tuple22._1();
                        Queue rest = (Queue)tuple22._2();
                        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)taker, (Object)rest);
                        Deferred taker2 = (Deferred)tuple23._1();
                        Queue rest2 = (Queue)tuple23._2();
                        State state3 = (State)Predef$.MODULE$.ArrowAssoc(PQueue$State$.MODULE$.apply(heap, size, rest2, offerers));
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state3, implicits$.MODULE$.toFunctorOps(taker2.complete(a), this.F).as((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                        return tuple2;
                    }
                    BinomialHeap<Object> heap2 = binomialHeap;
                    int size2 = n;
                    Queue takers2 = queue;
                    Queue offerers2 = queue2;
                    if (size2 < this.capacity) {
                        State state4 = (State)Predef$.MODULE$.ArrowAssoc(PQueue$State$.MODULE$.apply(heap2.insert(a), size2 + 1, takers2, offerers2));
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state4, this.F.pure((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                        return tuple2;
                    }
                }
                State s = state;
                State state5 = (State)Predef$.MODULE$.ArrowAssoc((Object)s);
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state5, this.F.pure((Object)BoxesRunTime.boxToBoolean((boolean)false)));
                return tuple2;
            }), this.F);
            Object object2 = package.all$.MODULE$.monadCancelOps_(FlattenOps$.MODULE$.flatten$extension(object, this.F));
            return (F)MonadCancelOps_$.MODULE$.uncancelable$extension(object2, this.F);
        }

        @Override
        public F take() {
            return (F)implicits$.MODULE$.toFlatMapOps(this.F.deferred(), this.F).flatMap((Function1 & Serializable)taker -> this.F.uncancelable((Function1 & Serializable)poll -> {
                Object object = implicits$.MODULE$.catsSyntaxFlatten(this.ref.modify((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2;
                    State state = x$1;
                    if (state != null) {
                        State state2 = PQueue$State$.MODULE$.unapply(state);
                        BinomialHeap binomialHeap = state2._1();
                        int n = state2._2();
                        Queue queue = state2._3();
                        Queue queue2 = state2._4();
                        BinomialHeap heap = binomialHeap;
                        int size = n;
                        Queue takers = queue;
                        Queue offerers = queue2;
                        if (heap.nonEmpty() && offerers.isEmpty()) {
                            Tuple2 tuple22 = heap.take();
                            if (tuple22 == null) {
                                throw new MatchError(tuple22);
                            }
                            BinomialHeap rest = (BinomialHeap)tuple22._1();
                            Object a = tuple22._2();
                            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)rest, a);
                            BinomialHeap rest2 = (BinomialHeap)tuple23._1();
                            Object a2 = tuple23._2();
                            State state3 = (State)Predef$.MODULE$.ArrowAssoc(PQueue$State$.MODULE$.apply(rest2, size - 1, takers, offerers));
                            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state3, this.F.pure(a2));
                        } else {
                            BinomialHeap heap2 = binomialHeap;
                            int size2 = n;
                            Queue takers2 = queue;
                            Queue offerers2 = queue2;
                            if (heap2.nonEmpty()) {
                                Tuple2 tuple24;
                                Tuple2 tuple25 = heap2.take();
                                if (tuple25 == null) {
                                    throw new MatchError(tuple25);
                                }
                                BinomialHeap rest = (BinomialHeap)tuple25._1();
                                Object a = tuple25._2();
                                Tuple2 tuple26 = Tuple2$.MODULE$.apply((Object)rest, a);
                                BinomialHeap rest3 = (BinomialHeap)tuple26._1();
                                Object a3 = tuple26._2();
                                Tuple2 tuple27 = offerers2.dequeue();
                                if (tuple27 == null || (tuple24 = (Tuple2)tuple27._1()) == null) {
                                    throw new MatchError((Object)tuple27);
                                }
                                Object move = tuple24._1();
                                Deferred release = (Deferred)tuple24._2();
                                Queue tail = (Queue)tuple27._2();
                                Tuple3 tuple3 = Tuple3$.MODULE$.apply(move, (Object)release, (Object)tail);
                                Object move2 = tuple3._1();
                                Deferred release2 = (Deferred)tuple3._2();
                                Queue tail2 = (Queue)tuple3._3();
                                State state4 = (State)Predef$.MODULE$.ArrowAssoc(PQueue$State$.MODULE$.apply(rest3.insert(move2), size2, takers2, tail2));
                                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state4, implicits$.MODULE$.toFunctorOps(release2.complete((Object)BoxedUnit.UNIT), this.F).as(a3));
                            } else {
                                BinomialHeap heap3 = binomialHeap;
                                int size3 = n;
                                Queue takers3 = queue;
                                Queue offerers3 = queue2;
                                if (offerers3.nonEmpty()) {
                                    Tuple2 tuple28;
                                    Tuple2 tuple29 = offerers3.dequeue();
                                    if (tuple29 == null || (tuple28 = (Tuple2)tuple29._1()) == null) {
                                        throw new MatchError((Object)tuple29);
                                    }
                                    Object a = tuple28._1();
                                    Deferred release = (Deferred)tuple28._2();
                                    Queue rest = (Queue)tuple29._2();
                                    Tuple3 tuple3 = Tuple3$.MODULE$.apply(a, (Object)release, (Object)rest);
                                    Object a4 = tuple3._1();
                                    Deferred release3 = (Deferred)tuple3._2();
                                    Queue rest4 = (Queue)tuple3._3();
                                    State state5 = (State)Predef$.MODULE$.ArrowAssoc(PQueue$State$.MODULE$.apply(heap3, size3, takers3, rest4));
                                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state5, implicits$.MODULE$.toFunctorOps(release3.complete((Object)BoxedUnit.UNIT), this.F).as(a4));
                                } else {
                                    BinomialHeap heap4 = binomialHeap;
                                    int size4 = n;
                                    Queue takers4 = queue;
                                    Queue offerers4 = queue2;
                                    Object cleanup = this.ref.update((Function1 & Serializable)s -> {
                                        Queue queue = (Queue)s.takers().filter((Function1 & Serializable)_$7 -> _$7 != taker);
                                        BinomialHeap binomialHeap = s.copy$default$1();
                                        int n = s.copy$default$2();
                                        Queue queue2 = s.copy$default$4();
                                        return s.copy(binomialHeap, n, queue, queue2);
                                    });
                                    State state6 = (State)Predef$.MODULE$.ArrowAssoc(PQueue$State$.MODULE$.apply(heap4, size4, takers4.enqueue(taker), offerers4));
                                    Object object = package.all$.MODULE$.monadCancelOps_(poll.apply(taker.get()));
                                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state6, MonadCancelOps_$.MODULE$.onCancel$extension(object, cleanup, this.F));
                                }
                            }
                        }
                    } else {
                        throw new MatchError((Object)state);
                    }
                    return tuple2;
                }), this.F);
                return FlattenOps$.MODULE$.flatten$extension(object, this.F);
            }));
        }

        @Override
        public F tryTake() {
            Object object = implicits$.MODULE$.catsSyntaxFlatten(this.ref.modify((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                State state = x$1;
                if (state != null) {
                    State state2 = PQueue$State$.MODULE$.unapply(state);
                    BinomialHeap binomialHeap = state2._1();
                    int n = state2._2();
                    Queue queue = state2._3();
                    Queue queue2 = state2._4();
                    BinomialHeap heap = binomialHeap;
                    int size = n;
                    Queue takers = queue;
                    Queue offerers = queue2;
                    if (heap.nonEmpty() && offerers.isEmpty()) {
                        Tuple2 tuple22 = heap.take();
                        if (tuple22 == null) throw new MatchError(tuple22);
                        BinomialHeap rest = (BinomialHeap)tuple22._1();
                        Object a = tuple22._2();
                        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)rest, a);
                        BinomialHeap rest2 = (BinomialHeap)tuple23._1();
                        Object a2 = tuple23._2();
                        State state3 = (State)Predef$.MODULE$.ArrowAssoc(PQueue$State$.MODULE$.apply(rest2, size - 1, takers, offerers));
                        Object object = implicits$.MODULE$.catsSyntaxOptionId(a2);
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state3, this.F.pure((Object)OptionIdOps$.MODULE$.some$extension(object)));
                        return tuple2;
                    }
                    BinomialHeap heap2 = binomialHeap;
                    int size2 = n;
                    Queue takers2 = queue;
                    Queue offerers2 = queue2;
                    if (heap2.nonEmpty()) {
                        Tuple2 tuple24 = heap2.take();
                        if (tuple24 == null) throw new MatchError(tuple24);
                        BinomialHeap rest = (BinomialHeap)tuple24._1();
                        Object a = tuple24._2();
                        Tuple2 tuple25 = Tuple2$.MODULE$.apply((Object)rest, a);
                        BinomialHeap rest3 = (BinomialHeap)tuple25._1();
                        Object a3 = tuple25._2();
                        Tuple2 tuple26 = offerers2.dequeue();
                        if (tuple26 == null) throw new MatchError((Object)tuple26);
                        Tuple2 tuple27 = (Tuple2)tuple26._1();
                        if (tuple27 == null) throw new MatchError((Object)tuple26);
                        Object move = tuple27._1();
                        Deferred release = (Deferred)tuple27._2();
                        Queue tail = (Queue)tuple26._2();
                        Tuple3 tuple3 = Tuple3$.MODULE$.apply(move, (Object)release, (Object)tail);
                        Object move2 = tuple3._1();
                        Deferred release2 = (Deferred)tuple3._2();
                        Queue tail2 = (Queue)tuple3._3();
                        State state4 = (State)Predef$.MODULE$.ArrowAssoc(PQueue$State$.MODULE$.apply(rest3.insert(move2), size2, takers2, tail2));
                        Object object = implicits$.MODULE$.catsSyntaxOptionId(a3);
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state4, implicits$.MODULE$.toFunctorOps(release2.complete((Object)BoxedUnit.UNIT), this.F).as((Object)OptionIdOps$.MODULE$.some$extension(object)));
                        return tuple2;
                    }
                    BinomialHeap heap3 = binomialHeap;
                    int size3 = n;
                    Queue takers3 = queue;
                    Queue offerers3 = queue2;
                    if (offerers3.nonEmpty()) {
                        Tuple2 tuple28 = offerers3.dequeue();
                        if (tuple28 == null) throw new MatchError((Object)tuple28);
                        Tuple2 tuple29 = (Tuple2)tuple28._1();
                        if (tuple29 == null) throw new MatchError((Object)tuple28);
                        Object a = tuple29._1();
                        Deferred release = (Deferred)tuple29._2();
                        Queue rest = (Queue)tuple28._2();
                        Tuple3 tuple3 = Tuple3$.MODULE$.apply(a, (Object)release, (Object)rest);
                        Object a4 = tuple3._1();
                        Deferred release3 = (Deferred)tuple3._2();
                        Queue rest4 = (Queue)tuple3._3();
                        State state5 = (State)Predef$.MODULE$.ArrowAssoc(PQueue$State$.MODULE$.apply(heap3, size3, takers3, rest4));
                        Object object = implicits$.MODULE$.catsSyntaxOptionId(a4);
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state5, implicits$.MODULE$.toFunctorOps(release3.complete((Object)BoxedUnit.UNIT), this.F).as((Object)OptionIdOps$.MODULE$.some$extension(object)));
                        return tuple2;
                    }
                }
                State s = state;
                State state6 = (State)Predef$.MODULE$.ArrowAssoc((Object)s);
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state6, this.F.pure((Object)implicits$.MODULE$.none()));
                return tuple2;
            }), this.F);
            Object object2 = package.all$.MODULE$.monadCancelOps_(FlattenOps$.MODULE$.flatten$extension(object, this.F));
            return (F)MonadCancelOps_$.MODULE$.uncancelable$extension(object2, this.F);
        }

        @Override
        public F size() {
            return (F)implicits$.MODULE$.toFunctorOps(this.ref.get(), this.F).map((Function1 & Serializable)_$8 -> _$8.size());
        }
    }

    public static final class State<F, A>
    implements Product,
    Serializable {
        private final BinomialHeap heap;
        private final int size;
        private final Queue takers;
        private final Queue offerers;

        public static <F, A> State<F, A> apply(BinomialHeap<A> binomialHeap, int n, Queue<Deferred<F, A>> queue, Queue<Tuple2<A, Deferred<F, BoxedUnit>>> queue2) {
            return PQueue$State$.MODULE$.apply(binomialHeap, n, queue, queue2);
        }

        public static <F, A> State<F, A> empty(Order<A> order) {
            return PQueue$State$.MODULE$.empty(order);
        }

        public static State fromProduct(Product product) {
            return PQueue$State$.MODULE$.fromProduct(product);
        }

        public static <F, A> State<F, A> unapply(State<F, A> state) {
            return PQueue$State$.MODULE$.unapply(state);
        }

        public State(BinomialHeap<A> heap, int size, Queue<Deferred<F, A>> takers, Queue<Tuple2<A, Deferred<F, BoxedUnit>>> offerers) {
            this.heap = heap;
            this.size = size;
            this.takers = takers;
            this.offerers = offerers;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.heap()));
            n = Statics.mix((int)n, (int)this.size());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.takers()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.offerers()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.size() != state.size()) return false;
            BinomialHeap<A> binomialHeap = this.heap();
            BinomialHeap<A> binomialHeap2 = state.heap();
            if (binomialHeap == null) {
                if (binomialHeap2 != null) {
                    return false;
                }
            } else if (!((Object)binomialHeap).equals(binomialHeap2)) return false;
            Queue<Deferred<F, A>> queue = this.takers();
            Queue<Deferred<F, A>> queue2 = state.takers();
            if (queue == null) {
                if (queue2 != null) {
                    return false;
                }
            } else if (!queue.equals(queue2)) return false;
            Queue<Tuple2<A, Deferred<F, BoxedUnit>>> queue3 = this.offerers();
            Queue<Tuple2<A, Deferred<F, BoxedUnit>>> queue4 = state.offerers();
            if (queue3 == null) {
                if (queue4 == null) return true;
                return false;
            } else {
                if (!queue3.equals(queue4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            Serializable serializable;
            int n2 = n;
            switch (n2) {
                case 0: {
                    serializable = this._1();
                    break;
                }
                case 1: {
                    serializable = BoxesRunTime.boxToInteger((int)this._2());
                    break;
                }
                case 2: {
                    serializable = this._3();
                    break;
                }
                case 3: {
                    serializable = this._4();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return serializable;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "heap";
                    break;
                }
                case 1: {
                    string = "size";
                    break;
                }
                case 2: {
                    string = "takers";
                    break;
                }
                case 3: {
                    string = "offerers";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public BinomialHeap<A> heap() {
            return this.heap;
        }

        public int size() {
            return this.size;
        }

        public Queue<Deferred<F, A>> takers() {
            return this.takers;
        }

        public Queue<Tuple2<A, Deferred<F, BoxedUnit>>> offerers() {
            return this.offerers;
        }

        public <F, A> State<F, A> copy(BinomialHeap<A> heap, int size, Queue<Deferred<F, A>> takers, Queue<Tuple2<A, Deferred<F, BoxedUnit>>> offerers) {
            return new State<F, A>(heap, size, takers, offerers);
        }

        public <F, A> BinomialHeap<A> copy$default$1() {
            return this.heap();
        }

        public int copy$default$2() {
            return this.size();
        }

        public <F, A> Queue<Deferred<F, A>> copy$default$3() {
            return this.takers();
        }

        public <F, A> Queue<Tuple2<A, Deferred<F, BoxedUnit>>> copy$default$4() {
            return this.offerers();
        }

        public BinomialHeap<A> _1() {
            return this.heap();
        }

        public int _2() {
            return this.size();
        }

        public Queue<Deferred<F, A>> _3() {
            return this.takers();
        }

        public Queue<Tuple2<A, Deferred<F, BoxedUnit>>> _4() {
            return this.offerers();
        }
    }
}

