/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.std;

import cats.Show;
import cats.Show$;
import cats.arrow.FunctionK;
import cats.effect.kernel.Sync;
import cats.syntax.package;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public interface Console<F> {
    public static Object readLine$(Console $this) {
        return $this.readLine();
    }

    default public F readLine() {
        return this.readLineWithCharset(Charset.defaultCharset());
    }

    public F readLineWithCharset(Charset var1);

    public <A> F print(A var1, Show<A> var2);

    public static Show print$default$2$(Console $this, Object a) {
        return $this.print$default$2(a);
    }

    default public <A> Show<A> print$default$2(A a) {
        return Show$.MODULE$.fromToString();
    }

    public <A> F println(A var1, Show<A> var2);

    public static Show println$default$2$(Console $this, Object a) {
        return $this.println$default$2(a);
    }

    default public <A> Show<A> println$default$2(A a) {
        return Show$.MODULE$.fromToString();
    }

    public <A> F error(A var1, Show<A> var2);

    public static Show error$default$2$(Console $this, Object a) {
        return $this.error$default$2(a);
    }

    default public <A> Show<A> error$default$2(A a) {
        return Show$.MODULE$.fromToString();
    }

    public <A> F errorln(A var1, Show<A> var2);

    public static Show errorln$default$2$(Console $this, Object a) {
        return $this.errorln$default$2(a);
    }

    default public <A> Show<A> errorln$default$2(A a) {
        return Show$.MODULE$.fromToString();
    }

    public static Object printStackTrace$(Console $this, Throwable t) {
        return $this.printStackTrace(t);
    }

    default public F printStackTrace(Throwable t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        t.printStackTrace(ps);
        return this.error(baos.toString(), Show$.MODULE$.catsShowForString());
    }

    public static Console mapK$(Console $this, FunctionK f) {
        return $this.mapK(f);
    }

    default public <G> Console<G> mapK(FunctionK<F, G> f) {
        return new Console<G>(f, this){
            private final FunctionK f$1;
            private final Console $outer;
            {
                this.f$1 = f$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Object readLineWithCharset(Charset charset) {
                return this.f$1.apply(this.$outer.readLineWithCharset(charset));
            }

            public Object print(Object a, Show S) {
                return this.f$1.apply(this.$outer.print(a, S));
            }

            public Object println(Object a, Show S) {
                return this.f$1.apply(this.$outer.println(a, S));
            }

            public Object error(Object a, Show S) {
                return this.f$1.apply(this.$outer.error(a, S));
            }

            public Object errorln(Object a, Show S) {
                return this.f$1.apply(this.$outer.errorln(a, S));
            }

            public Object printStackTrace(Throwable t) {
                return this.f$1.apply(this.$outer.printStackTrace(t));
            }
        };
    }

    private static final class SyncConsole<F>
    implements Console<F> {
        private final Sync<F> F;

        public SyncConsole(Sync<F> F) {
            this.F = F;
        }

        @Override
        public F readLineWithCharset(Charset charset) {
            return (F)this.F.interruptible(false, () -> this.readLineWithCharset$$anonfun$1(charset));
        }

        @Override
        public <A> F print(A a, Show<A> S) {
            String text = package.show$.MODULE$.toShow(a, S).show();
            return (F)this.F.blocking((Function0 & Serializable)() -> {
                this.print$$anonfun$1(text);
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public <A> Show<A> print$default$2(A a) {
            return Show$.MODULE$.fromToString();
        }

        @Override
        public <A> F println(A a, Show<A> S) {
            String text = package.show$.MODULE$.toShow(a, S).show();
            return (F)this.F.blocking((Function0 & Serializable)() -> {
                this.println$$anonfun$1(text);
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public <A> Show<A> println$default$2(A a) {
            return Show$.MODULE$.fromToString();
        }

        @Override
        public <A> F error(A a, Show<A> S) {
            String text = package.show$.MODULE$.toShow(a, S).show();
            return (F)this.F.blocking((Function0 & Serializable)() -> {
                this.error$$anonfun$1(text);
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public <A> Show<A> error$default$2(A a) {
            return Show$.MODULE$.fromToString();
        }

        @Override
        public <A> F errorln(A a, Show<A> S) {
            String text = package.show$.MODULE$.toShow(a, S).show();
            return (F)this.F.blocking((Function0 & Serializable)() -> {
                this.errorln$$anonfun$1(text);
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public <A> Show<A> errorln$default$2(A a) {
            return Show$.MODULE$.fromToString();
        }

        @Override
        public F printStackTrace(Throwable t) {
            return (F)this.F.blocking((Function0 & Serializable)() -> {
                this.printStackTrace$$anonfun$1(t);
                return BoxedUnit.UNIT;
            });
        }

        private final CharBuffer decodeNext$1(InputStream in$1, CharsetDecoder decoder$1, ByteBuffer bytes$1) {
            bytes$1.clear();
            return this.decodeNextLoop$1(in$1, decoder$1, bytes$1);
        }

        private final Object liftedTree1$1(CharsetDecoder decoder$3, ByteBuffer bytes$3, int limit$1, int position$1, ObjectRef result$1) {
            Buffer buffer;
            try {
                bytes$3.flip();
                CharBuffer charBuffer = decoder$3.decode(bytes$3);
                result$1.elem = charBuffer;
                buffer = BoxedUnit.UNIT;
            }
            catch (MalformedInputException malformedInputException) {
                bytes$3.limit(limit$1);
                buffer = bytes$3.position(position$1);
            }
            return buffer;
        }

        private final CharBuffer decodeNextLoop$1(InputStream in$2, CharsetDecoder decoder$2, ByteBuffer bytes$2) {
            CharBuffer charBuffer;
            block2: {
                ObjectRef result;
                do {
                    int b;
                    if ((b = in$2.read()) == -1) {
                        charBuffer = null;
                        break block2;
                    }
                    bytes$2.put((byte)b);
                    int limit = bytes$2.limit();
                    int position = bytes$2.position();
                    result = ObjectRef.create(null);
                    this.liftedTree1$1(decoder$2, bytes$2, limit, position, result);
                } while ((CharBuffer)result.elem == null);
                charBuffer = (CharBuffer)result.elem;
            }
            return charBuffer;
        }

        private final String loop$1(InputStream in$3, CharsetDecoder decoder$4, ByteBuffer bytes$4, StringBuilder builder$1) {
            String string;
            while (true) {
                String decoded;
                CharBuffer buffer;
                if ((buffer = this.decodeNext$1(in$3, decoder$4, bytes$4)) == null) {
                    String result = builder$1.toString();
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(result))) {
                        string = result;
                        break;
                    }
                    throw new EOFException();
                }
                String string2 = decoded = buffer.toString();
                String string3 = "\n";
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    int len = builder$1.length();
                    if (len > 0 && builder$1.charAt(len - 1) == '\r') {
                        builder$1.deleteCharAt(len - 1);
                    }
                    string = builder$1.toString();
                    break;
                }
                builder$1.append(decoded);
            }
            return string;
        }

        private final String readLineWithCharset$$anonfun$1(Charset charset$1) {
            InputStream in = System.in;
            CharsetDecoder decoder = charset$1.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPLACE);
            ByteBuffer bytes = ByteBuffer.allocate(64);
            StringBuilder builder = new StringBuilder();
            return this.loop$1(in, decoder, bytes, builder);
        }

        private final void print$$anonfun$1(String text$1) {
            System.out.print(text$1);
        }

        private final void println$$anonfun$1(String text$2) {
            System.out.println(text$2);
        }

        private final void error$$anonfun$1(String text$3) {
            System.err.print(text$3);
        }

        private final void errorln$$anonfun$1(String text$4) {
            System.err.println(text$4);
        }

        private final void printStackTrace$$anonfun$1(Throwable t$1) {
            t$1.printStackTrace();
        }
    }
}

