/*
 * Copyright 2020-2021 Typelevel
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cats.effect.kernel

import cats.{Applicative, Hash}

trait Unique[F[_]] {
  def applicative: Applicative[F]
  def unique: F[Unique.Token]
}

object Unique {

  def apply[F[_]](implicit F: Unique[F]): F.type = F

  final class Token

  object Token {
    implicit val tokenHash: Hash[Token] =
      Hash.fromUniversalHashCode[Token]
  }
}
