/*
 * Decompiled with CFR 0.152.
 */
package io.vacco.metolithe.codegen.liquibase;

import io.vacco.metolithe.annotations.MtCompIndex;
import io.vacco.metolithe.annotations.MtField;
import io.vacco.metolithe.annotations.MtFk;
import io.vacco.metolithe.annotations.MtIndex;
import io.vacco.metolithe.annotations.MtNotNull;
import io.vacco.metolithe.annotations.MtPk;
import io.vacco.metolithe.annotations.MtUnique;
import io.vacco.metolithe.annotations.MtVarchar;
import io.vacco.metolithe.codegen.liquibase.type.AddForeignKeyConstraint;
import io.vacco.metolithe.codegen.liquibase.type.AddUniqueConstraint;
import io.vacco.metolithe.codegen.liquibase.type.ChangeSet;
import io.vacco.metolithe.codegen.liquibase.type.Column;
import io.vacco.metolithe.codegen.liquibase.type.Constraints;
import io.vacco.metolithe.codegen.liquibase.type.CreateIndex;
import io.vacco.metolithe.codegen.liquibase.type.CreateTable;
import io.vacco.metolithe.codegen.liquibase.type.MtLbType;
import io.vacco.metolithe.codegen.liquibase.type.Root;
import io.vacco.metolithe.core.MtCaseFormat;
import io.vacco.metolithe.core.MtDescriptor;
import io.vacco.metolithe.core.MtException;
import io.vacco.metolithe.core.MtFieldDescriptor;
import io.vacco.metolithe.core.MtTypeMapper;
import io.vacco.metolithe.core.MtUtil;
import io.vacco.metolithe.hashing.MtMurmur3;
import io.vacco.oriax.alg.OxKos;
import io.vacco.oriax.core.OxGrph;
import io.vacco.oriax.core.OxVtx;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MtLb {
    private Optional<Constraints> mapConstraints(MtFieldDescriptor d) {
        Optional nn = d.get(MtNotNull.class);
        Optional pk = d.get(MtPk.class);
        if (nn.isPresent() || pk.isPresent()) {
            Constraints cn = new Constraints();
            cn.nullable = false;
            if (pk.isPresent()) {
                cn.primaryKey = true;
            }
            return Optional.of(cn);
        }
        return Optional.empty();
    }

    private Column mapAttribute(MtFieldDescriptor d) {
        Column c = new Column();
        c.name = d.getFieldName();
        c.type = d.getFormat().of(MtTypeMapper.sqlTypeOf((MtFieldDescriptor)d));
        this.mapConstraints(d).ifPresent(cn -> {
            c.constraints = cn;
        });
        return c;
    }

    private CreateIndex mapIndex(MtDescriptor<?> d, MtFieldDescriptor fm) {
        CreateIndex idx = new CreateIndex();
        idx.indexName = d.getFormat().of(String.format("idx_%s_%s", d.getName(), fm.getFieldName()));
        idx.tableName = d.getName();
        idx.columns.add(new Column().withName(fm.getFieldName()));
        return idx;
    }

    private CreateIndex mapCompositeIndex(String indexName, MtDescriptor<?> d, List<MtFieldDescriptor> components) {
        Object[] fields = components.stream().sorted(Comparator.comparingInt(fd -> ((MtCompIndex)fd.get(MtCompIndex.class).get()).idx())).map(MtFieldDescriptor::getFieldName).toArray();
        String indexId = String.format("idx_%s_%s", indexName, Integer.toHexString(MtMurmur3.hash32((byte[])((byte[])MtUtil.toStringConcat((Object[])fields).get()), (int)104729)));
        CreateIndex idx = new CreateIndex().withIndexName(d.getFormat().of(indexId)).withTableName(d.getName());
        for (MtFieldDescriptor fd2 : components) {
            idx.columns.add(new Column().withName(fd2.getFieldName()));
        }
        return idx;
    }

    private AddUniqueConstraint mapUniqueConstraints(MtDescriptor<?> d) {
        AddUniqueConstraint uc = new AddUniqueConstraint();
        uc.tableName = d.getName();
        uc.constraintName = d.getFormat().of(String.format("unq_%s", d.getName()));
        uc.columnNames = d.get(MtUnique.class).sorted(Comparator.comparingInt(fd -> ((MtUnique)fd.get(MtUnique.class).get()).idx())).map(MtFieldDescriptor::getFieldName).collect(Collectors.joining(","));
        return uc;
    }

    private AddForeignKeyConstraint mapForeignKey(MtDescriptor<?> d, MtFieldDescriptor fd) {
        MtFk fk = (MtFk)fd.get(MtFk.class).get();
        MtDescriptor fkTarget = new MtDescriptor(fk.value(), fd.getFormat());
        MtFieldDescriptor targetPk = (MtFieldDescriptor)fkTarget.get(MtPk.class).findFirst().get();
        if (!fd.getType().equals(targetPk.getType())) {
            throw new MtException.MtForeignKeyMismatchException(d.getName(), fd.getFieldName(), fd.getType().getTypeName(), fkTarget.getName(), targetPk.getFieldName(), targetPk.getType().getTypeName());
        }
        String from = d.getName();
        String fromField = fd.getFieldName();
        String to = fkTarget.getName();
        String toField = targetPk.getFieldName();
        String fkId = String.format("fk_%s", Integer.toHexString(MtMurmur3.hash32((byte[])((byte[])MtUtil.toStringConcat((Object[])new Object[]{from, fromField, to, toField}).get()), (int)104729)));
        AddForeignKeyConstraint fkc = new AddForeignKeyConstraint();
        fkc.baseColumnNames = fromField;
        fkc.baseTableName = from;
        fkc.constraintName = d.getFormat().of(fkId);
        fkc.referencedColumnNames = toField;
        fkc.referencedTableName = to;
        return fkc;
    }

    private List<ChangeSet> mapForeignKeys(List<OxVtx<String, MtDescriptor<?>>> classGroup) {
        return classGroup.stream().map(v -> (MtDescriptor)v.data).flatMap(d -> d.get(MtFk.class).map(fd -> this.mapForeignKey((MtDescriptor<?>)d, (MtFieldDescriptor)fd))).map(fkc -> new ChangeSet().withId(fkc.constraintName).add((MtLbType)fkc)).collect(Collectors.toList());
    }

    private ChangeSet mapTable(MtDescriptor<?> d) {
        ChangeSet cs = new ChangeSet().withId(d.getName());
        CreateTable ct = new CreateTable().withTableName(d.getName());
        cs.changes.add(ct);
        Arrays.asList(MtPk.class, MtFk.class, MtField.class, MtVarchar.class).forEach(cl -> d.get(cl).map(this::mapAttribute).forEach(col -> ct.columns.add((Column)col)));
        d.get(MtUnique.class).findFirst().ifPresent(fd -> cs.changes.add(this.mapUniqueConstraints(d)));
        d.get(MtIndex.class).map(fd -> this.mapIndex(d, (MtFieldDescriptor)fd)).forEach(idx -> cs.changes.add((MtLbType)idx));
        d.getCompositeIndexes().forEach((k, v) -> cs.changes.add(this.mapCompositeIndex((String)k, d, (List<MtFieldDescriptor>)v)));
        return cs;
    }

    public Root build(MtCaseFormat fmt, Class<?> ... schemaClasses) {
        List descriptors = Arrays.stream(schemaClasses).map(clazz -> new MtDescriptor(clazz, fmt)).map(fd -> new OxVtx((Object)fd.getName(), fd)).collect(Collectors.toList());
        OxGrph schema = new OxGrph();
        for (OxVtx vd : descriptors) {
            ((MtDescriptor)vd.data).getFields(true).stream().map(fd -> fd.get(MtFk.class)).filter(Optional::isPresent).map(Optional::get).forEach(fk -> descriptors.stream().filter(v -> ((MtDescriptor)v.data).matches(fk.value())).findFirst().ifPresent(v0 -> schema.addEdge(vd, v0)));
        }
        Root root = new Root();
        OxKos.apply((OxGrph)schema).forEach((k, v) -> {
            v.stream().map(v0 -> this.mapTable((MtDescriptor)v0.data)).forEach(root::append);
            this.mapForeignKeys((List<OxVtx<String, MtDescriptor<?>>>)v).forEach(root::append);
        });
        return root;
    }

    public static <T> T map(MtLbType t, Function<MtLbType, T> rootFn, Consumer3<MtLbType, T, T> onObj, Consumer3<T, String, String> onAttr, Consumer4<MtLbType, Field, T, T> onListItem) {
        try {
            T m0 = rootFn.apply(t);
            for (Field f : t.getClass().getFields()) {
                Object v = f.get(t);
                if (v == null) continue;
                if (!(v instanceof Collection)) {
                    if (v instanceof Constraints) {
                        MtLbType t0 = (MtLbType)v;
                        T m1 = MtLb.map(t0, rootFn, onObj, onAttr, onListItem);
                        onObj.accept(t0, m0, m1);
                        continue;
                    }
                    onAttr.accept(m0, f.getName(), v.toString());
                    continue;
                }
                for (Object o : (Collection)v) {
                    MtLbType t0 = (MtLbType)o;
                    T m1 = MtLb.map(t0, rootFn, onObj, onAttr, onListItem);
                    onListItem.accept(t0, f, m0, m1);
                }
            }
            return m0;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static interface Consumer4<V0, V1, V2, V3> {
        public void accept(V0 var1, V1 var2, V2 var3, V3 var4);
    }

    public static interface Consumer3<V0, V1, V2> {
        public void accept(V0 var1, V1 var2, V2 var3);
    }
}

