/*
 * Decompiled with CFR 0.152.
 */
package io.vacco.metolithe.codegen.liquibase;

import io.vacco.metolithe.annotations.MtCompIndex;
import io.vacco.metolithe.annotations.MtField;
import io.vacco.metolithe.annotations.MtFk;
import io.vacco.metolithe.annotations.MtIndex;
import io.vacco.metolithe.annotations.MtNotNull;
import io.vacco.metolithe.annotations.MtPk;
import io.vacco.metolithe.annotations.MtUnique;
import io.vacco.metolithe.annotations.MtVarchar;
import io.vacco.metolithe.core.MtCaseFormat;
import io.vacco.metolithe.core.MtDescriptor;
import io.vacco.metolithe.core.MtException;
import io.vacco.metolithe.core.MtFieldDescriptor;
import io.vacco.metolithe.core.MtTypeMapper;
import io.vacco.metolithe.hashing.MtMurmur3;
import io.vacco.oriax.alg.OxKos;
import io.vacco.oriax.core.OxGrph;
import io.vacco.oriax.core.OxVtx;
import io.vacco.oruzka.core.OzArrays;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.joox.JOOX;
import org.joox.Match;
import org.xml.sax.SAXException;

public class MtLbMapper {
    private Match mapAttribute(MtFieldDescriptor d) {
        Match cn;
        Match columnXml = JOOX.$((String)"column").attr("name", d.getFieldName()).attr("type", d.getFormat().of(MtTypeMapper.sqlTypeOf((MtFieldDescriptor)d)));
        Optional nn = d.get(MtNotNull.class);
        Optional pk = d.get(MtPk.class);
        Object object = cn = nn.isPresent() || pk.isPresent() ? JOOX.$((String)"constraints") : null;
        if (cn != null) {
            cn.attr("nullable", "false");
            if (pk.isPresent()) {
                cn.attr("primaryKey", "true");
            }
            columnXml.append(new Match[]{cn});
        }
        return columnXml;
    }

    private Match createIndex(String indexName, String tableName) {
        return JOOX.$((String)"createIndex").attr("indexName", indexName).attr("tableName", tableName);
    }

    private Match column(String name) {
        return JOOX.$((String)"column").attr("name", name);
    }

    private Match mapIndex(MtDescriptor<?> d, MtFieldDescriptor fm) {
        Match idx = this.createIndex(d.getFormat().of(String.format("idx_%s_%s", d.getName(), fm.getFieldName())), d.getName());
        idx.append(new Match[]{this.column(fm.getFieldName())});
        return idx;
    }

    private Match mapCompIndex(String indexName, MtDescriptor<?> d, List<MtFieldDescriptor> components) {
        Object[] fields = components.stream().sorted(Comparator.comparingInt(fd -> ((MtCompIndex)fd.get(MtCompIndex.class).get()).idx())).map(MtFieldDescriptor::getFieldName).toArray();
        String indexId = String.format("idx_%s_%s", indexName, Integer.toHexString(MtMurmur3.hash32((byte[])((byte[])OzArrays.toStringConcat((Object[])fields).get()), (int)104729)));
        Match idx = this.createIndex(d.getFormat().of(indexId), d.getName());
        for (MtFieldDescriptor fd2 : components) {
            idx.append(new Match[]{this.column(fd2.getFieldName())});
        }
        return idx;
    }

    private Match mapUniqueConstraints(MtDescriptor<?> d) {
        return JOOX.$((String)"addUniqueConstraint").attr("tableName", d.getName()).attr("constraintName", d.getFormat().of(String.format("unq_%s", d.getName()))).attr("columnNames", d.get(MtUnique.class).sorted(Comparator.comparingInt(fd -> ((MtUnique)fd.get(MtUnique.class).get()).idx())).map(MtFieldDescriptor::getFieldName).collect(Collectors.joining(",")));
    }

    private Match changeSet(String id) {
        return JOOX.$((String)"changeSet").attr("author", "generated").attr("id", id);
    }

    public List<Match> mapForeignKeys(List<OxVtx<String, MtDescriptor<?>>> classGroup) {
        return classGroup.stream().map(v -> (MtDescriptor)v.data).flatMap(d -> d.get(MtFk.class).map(fd -> {
            MtFk fk = (MtFk)fd.get(MtFk.class).get();
            MtDescriptor fkTarget = new MtDescriptor(fk.value(), fd.getFormat());
            MtFieldDescriptor targetPk = (MtFieldDescriptor)fkTarget.get(MtPk.class).findFirst().get();
            if (!fd.getType().equals(targetPk.getType())) {
                throw new MtException.MtForeignKeyMismatchException(d.getName(), fd.getFieldName(), fd.getType().getTypeName(), fkTarget.getName(), targetPk.getFieldName(), targetPk.getType().getTypeName());
            }
            String from = d.getName();
            String fromField = fd.getFieldName();
            String to = fkTarget.getName();
            String toField = targetPk.getFieldName();
            String fkId = String.format("fk_%s", Integer.toHexString(MtMurmur3.hash32((byte[])((byte[])OzArrays.toStringConcat((Object[])new Object[]{from, fromField, to, toField}).get()), (int)104729)));
            Match cs = this.changeSet(d.getFormat().of(fkId));
            cs.append(new Match[]{JOOX.$((String)"addForeignKeyConstraint").attr("baseColumnNames", fromField).attr("baseTableName", from).attr("constraintName", d.getFormat().of(fkId)).attr("referencedColumnNames", toField).attr("referencedTableName", to)});
            return cs;
        })).collect(Collectors.toList());
    }

    public Match mapFrom(MtDescriptor<?> d) {
        Match cs = this.changeSet(d.getName());
        Match ct = JOOX.$((String)"createTable").attr("tableName", d.getName());
        Arrays.asList(MtPk.class, MtFk.class, MtField.class, MtVarchar.class).forEach(cl -> d.get(cl).map(this::mapAttribute).forEach(xva$0 -> ct.append(new Match[]{xva$0})));
        cs.append(new Match[]{ct});
        d.get(MtUnique.class).findFirst().ifPresent(fd -> cs.append(new Match[]{this.mapUniqueConstraints(d)}));
        d.get(MtIndex.class).map(fd -> this.mapIndex(d, (MtFieldDescriptor)fd)).forEach(xva$0 -> cs.append(new Match[]{xva$0}));
        d.getCompositeIndexes().forEach((k, v) -> cs.append(new Match[]{this.mapCompIndex((String)k, d, (List<MtFieldDescriptor>)v)}));
        return cs;
    }

    public Match mapSchema(MtCaseFormat fmt, Class<?> ... schemaClasses) throws IOException, SAXException {
        List descriptors = Arrays.stream(schemaClasses).map(clazz -> new MtDescriptor(clazz, fmt)).map(fd -> new OxVtx((Object)fd.getName(), fd)).collect(Collectors.toList());
        OxGrph schema = new OxGrph();
        for (OxVtx vd : descriptors) {
            ((MtDescriptor)vd.data).getFields(true).stream().map(fd -> fd.get(MtFk.class)).filter(Optional::isPresent).map(Optional::get).forEach(fk -> descriptors.stream().filter(v -> ((MtDescriptor)v.data).matches(fk.value())).findFirst().ifPresent(v0 -> schema.addEdge(vd, v0)));
        }
        URL xmlTemplate = MtLbMapper.class.getClassLoader().getResource("io/vacco/metolithe/codegen/liquibase/changelog-template.xml");
        Match lb = JOOX.$((URL)Objects.requireNonNull(xmlTemplate));
        OxKos.apply((OxGrph)schema).forEach((k, v) -> {
            v.stream().map(v0 -> this.mapFrom((MtDescriptor)v0.data)).forEach(xva$0 -> lb.append(new Match[]{xva$0}));
            this.mapForeignKeys((List<OxVtx<String, MtDescriptor<?>>>)v).forEach(xva$0 -> lb.append(new Match[]{xva$0}));
        });
        return lb;
    }
}

