/*
 * Decompiled with CFR 0.152.
 */
package io.urf.apache.commons.configuration2.surf;

import com.globalmentor.java.Conditions;
import io.urf.surf.parser.SurfObject;
import io.urf.surf.parser.SurfParser;
import io.urf.surf.serializer.SurfSerializer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.FileBasedConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;

public class SurfConfiguration
extends BaseHierarchicalConfiguration
implements FileBasedConfiguration {
    private static final String DEFAULT_ROOT_NAME = "Configuration";
    private SurfObject surfDocument;

    public void read(@Nonnull Reader in) throws ConfigurationException, IOException {
        block14: {
            try (BufferedReader bufferedIn = new BufferedReader(Objects.requireNonNull(in));){
                Object surfDocument = new SurfParser().parse((Reader)bufferedIn).orElse(null);
                if (surfDocument instanceof SurfObject && ((SurfObject)surfDocument).getPropertyCount() != 0) {
                    this.surfDocument = surfDocument;
                    break block14;
                }
                if (surfDocument == null || ((SurfObject)surfDocument).getPropertyCount() == 0) {
                    this.surfDocument = new SurfObject(DEFAULT_ROOT_NAME);
                    break block14;
                }
                throw new ConfigurationException("The element on the file is not a valid SURF configuration file.");
            }
        }
    }

    public void write(@Nonnull Writer out) throws ConfigurationException, IOException {
        try (BufferedWriter bufferedOut = new BufferedWriter(Objects.requireNonNull(out));){
            SurfSerializer serializer = new SurfSerializer();
            serializer.setFormatted(true);
            bufferedOut.write(serializer.serialize((Object)this.surfDocument));
        }
    }

    protected Object getPropertyInternal(@Nonnull String key) {
        return this.surfDocument.getPropertyValue(Objects.requireNonNull(key, "The key to be retrieved from the configuration file cannot be <null>.")).orElse(null);
    }

    protected void addPropertyInternal(@Nonnull String key, @Nullable Object obj) {
        Conditions.checkArgument((key != null ? 1 : 0) != 0, (String)"The key of the property being added cannot be <null>.", (Object[])new Object[0]);
        this.surfDocument.setPropertyValue(key, obj);
    }

    protected void clearPropertyDirect(String key) {
        this.surfDocument.setPropertyValue(key, null);
    }

    protected boolean isEmptyInternal() {
        return this.surfDocument == null || this.size() == 0;
    }

    protected int sizeInternal() {
        if (this.surfDocument == null) {
            return 0;
        }
        return this.surfDocument.getPropertyCount();
    }

    public SurfObject getSurfDocument() {
        return this.surfDocument;
    }
}

