/*
 * Decompiled with CFR 0.152.
 */
package io.uouo.wechat.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.vdurmont.emoji.EmojiParser;
import io.uouo.wechat.exception.WeChatException;
import io.uouo.wechat.utils.DateUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeChatUtils {
    private static final Logger log = LoggerFactory.getLogger(WeChatUtils.class);
    private static final Gson GSON = new Gson();
    private static final Gson PRETTY_GSON = new GsonBuilder().setPrettyPrinting().create();

    public static String match(String reg, String text) {
        Pattern pattern = Pattern.compile(reg);
        Matcher m = pattern.matcher(text);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public static Matcher matcher(String reg, String text) {
        Pattern pattern = Pattern.compile(reg);
        return pattern.matcher(text);
    }

    public static String formatMsg(String msg) {
        msg = msg.replace("&lt;", "<").replace("&gt;", ">").replace("<br/>", "\n");
        return WeChatUtils.emojiParse(msg);
    }

    public static String getMimeType(String fileUrl) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String type = fileNameMap.getContentTypeFor(fileUrl);
        return type;
    }

    public static String emojiParse(String text) {
        Matcher m = WeChatUtils.matcher("<span class=\"emoji emoji(.{1,10})\"></span>", text);
        StringBuilder sb = new StringBuilder();
        int lastStart = 0;
        while (m.find()) {
            String str = m.group(1);
            if (str.length() == 6 || str.length() == 10) continue;
            str = "&#x" + str + ";";
            String tmp = text.substring(lastStart, m.start());
            sb.append(tmp + str);
            lastStart = m.end();
        }
        if (lastStart < text.length()) {
            sb.append(text.substring(lastStart));
        }
        if (sb.length() > 0) {
            return EmojiParser.parseToUnicode((String)sb.toString());
        }
        return text;
    }

    public static String toPrettyJson(Object bean) {
        return PRETTY_GSON.toJson(bean);
    }

    public static String toJson(Object bean) {
        return GSON.toJson(bean);
    }

    public static <T> T fromJson(String json, Class<T> from) {
        return (T)GSON.fromJson(json, from);
    }

    public static <T> T fromJson(String json, Type from) {
        return (T)GSON.fromJson(json, from);
    }

    public static <T> T fromJson(FileReader fileReader, Type from) {
        return (T)GSON.fromJson((Reader)fileReader, from);
    }

    public static <T> T fromJson(String json, TypeToken<T> typeToken) {
        return (T)GSON.fromJson(json, typeToken.getType());
    }

    public static File saveFile(InputStream inputStream, String dirPath, String id) {
        return WeChatUtils.saveFileByDay(inputStream, dirPath, id, false);
    }

    public static File saveFileByDay(InputStream inputStream, String dirPath, String id, boolean byDay) {
        OutputStream outputStream = null;
        try {
            File path;
            File dir;
            if (byDay) {
                dirPath = dirPath + "/" + DateUtils.getDateString();
            }
            if (!(dir = new File(dirPath)).isDirectory()) {
                dir.mkdirs();
            }
            if ((path = new File(dir, id)).exists()) {
                path.delete();
            }
            outputStream = new FileOutputStream(path);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, len);
            }
            outputStream.flush();
            File file = path;
            return file;
        }
        catch (Exception e) {
            throw new WeChatException(e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static <T> void writeJson(String file, T data) {
        try {
            FileWriter writer = new FileWriter(file);
            GSON.toJson(data, (Appendable)writer);
            writer.close();
        }
        catch (Exception e) {
            log.warn("\u5199\u5165JSON\u5230\u6587\u4ef6: {} \u5931\u8d25", (Object)file, (Object)e);
        }
    }

    public static int random(int min, int max) {
        Random random = new Random();
        return random.nextInt(max) % (max - min + 1) + min;
    }
}

