/*
 * Decompiled with CFR 0.152.
 */
package io.uouo.wechat.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import io.uouo.wechat.utils.BufferedImageLuminanceSource;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.util.EnumMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QRCodeUtils {
    private static final Logger log = LoggerFactory.getLogger(QRCodeUtils.class);

    public static void showQrCode(File qrCode, boolean terminal) throws WriterException {
        if (!terminal) {
            String os = System.getProperty("os.name").toLowerCase();
            try {
                if (os.contains("mac") || os.contains("win")) {
                    Desktop.getDesktop().open(qrCode);
                    return;
                }
            }
            catch (Exception e) {
                log.warn("\u5728 {} \u4e0b\u6253\u5f00\u6587\u4ef6 {} \u5931\u8d25", new Object[]{os, qrCode.getPath(), e});
            }
        }
        EnumMap<EncodeHintType, Object> hintMap = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
        hintMap.put(EncodeHintType.CHARACTER_SET, (Object)"UTF-8");
        hintMap.put(EncodeHintType.MARGIN, (Object)1);
        hintMap.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.L);
        String qrContent = QRCodeUtils.readQRCode(qrCode, hintMap);
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = qrCodeWriter.encode(qrContent, BarcodeFormat.QR_CODE, 10, 10, hintMap);
        System.out.println(QRCodeUtils.toAscii(bitMatrix));
    }

    private static String toAscii(BitMatrix bitMatrix) {
        StringBuilder sb = new StringBuilder();
        for (int rows = 0; rows < bitMatrix.getHeight(); ++rows) {
            for (int cols = 0; cols < bitMatrix.getWidth(); ++cols) {
                boolean x = bitMatrix.get(rows, cols);
                if (!x) {
                    sb.append("\u001b[47m  \u001b[0m");
                    continue;
                }
                sb.append("\u001b[30m  \u001b[0;39m");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String readQRCode(File filePath, Map hintMap) {
        try {
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new BufferedImageLuminanceSource(ImageIO.read(new FileInputStream(filePath)))));
            Result qrCodeResult = new MultiFormatReader().decode(binaryBitmap, hintMap);
            return qrCodeResult.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

