/*
 * Decompiled with CFR 0.152.
 */
package io.uouo.wechat.api.model;

import io.uouo.wechat.WeChatBot;
import io.uouo.wechat.api.enums.AccountType;
import io.uouo.wechat.api.enums.MsgType;
import io.uouo.wechat.api.model.Account;
import io.uouo.wechat.api.model.WeChatMessage;
import java.beans.ConstructorProperties;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Invoke {
    private static final Logger log = LoggerFactory.getLogger(Invoke.class);
    private static final Set<String> INVOKED_MSG = new HashSet<String>();
    private Method method;
    private List<AccountType> accountTypes;
    private MsgType msgType;

    public <T extends WeChatBot> void call(T bot, WeChatMessage message) {
        if (INVOKED_MSG.contains(message.getId())) {
            return;
        }
        try {
            if (message.getMsgType() == MsgType.ADD_FRIEND && bot.config().autoAddFriend()) {
                bot.api().verify(message.getRecommend());
                return;
            }
            Account account = bot.api().getAccountById(message.getFromUserName());
            if (null == account) {
                INVOKED_MSG.add(message.getId());
                this.method.invoke(bot, message);
                return;
            }
            if (this.msgType == MsgType.ALL || this.msgType == message.getMsgType()) {
                if (message.getMsgType() == MsgType.ADD_FRIEND) {
                    INVOKED_MSG.add(message.getId());
                    this.method.invoke(bot, message);
                } else if (this.accountTypes.contains((Object)account.getAccountType())) {
                    INVOKED_MSG.add(message.getId());
                    this.method.invoke(bot, message);
                }
            }
        }
        catch (Exception e) {
            log.warn("\u56de\u8c03\u7ed9\u5ba2\u6237\u7aef\u51fa\u9519: {}\r\n", (Object)message, (Object)e);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public List<AccountType> getAccountTypes() {
        return this.accountTypes;
    }

    public MsgType getMsgType() {
        return this.msgType;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setAccountTypes(List<AccountType> accountTypes) {
        this.accountTypes = accountTypes;
    }

    public void setMsgType(MsgType msgType) {
        this.msgType = msgType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Invoke)) {
            return false;
        }
        Invoke other = (Invoke)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Method this$method = this.getMethod();
        Method other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
            return false;
        }
        List<AccountType> this$accountTypes = this.getAccountTypes();
        List<AccountType> other$accountTypes = other.getAccountTypes();
        if (this$accountTypes == null ? other$accountTypes != null : !((Object)this$accountTypes).equals(other$accountTypes)) {
            return false;
        }
        MsgType this$msgType = this.getMsgType();
        MsgType other$msgType = other.getMsgType();
        return !(this$msgType == null ? other$msgType != null : !((Object)((Object)this$msgType)).equals((Object)other$msgType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Invoke;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        List<AccountType> $accountTypes = this.getAccountTypes();
        result = result * 59 + ($accountTypes == null ? 43 : ((Object)$accountTypes).hashCode());
        MsgType $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : ((Object)((Object)$msgType)).hashCode());
        return result;
    }

    public String toString() {
        return "Invoke(method=" + this.getMethod() + ", accountTypes=" + this.getAccountTypes() + ", msgType=" + (Object)((Object)this.getMsgType()) + ")";
    }

    @ConstructorProperties(value={"method", "accountTypes", "msgType"})
    public Invoke(Method method, List<AccountType> accountTypes, MsgType msgType) {
        this.method = method;
        this.accountTypes = accountTypes;
        this.msgType = msgType;
    }
}

