/*
 * Decompiled with CFR 0.152.
 */
package io.uouo.wechat.api.model;

import io.uouo.wechat.WeChatBot;
import io.uouo.wechat.api.enums.ApiURL;
import java.util.Arrays;

public class DownLoad {
    private ApiURL apiURL;
    private String suffix;
    private String msgId;
    private Object[] params;
    private boolean saveByDay;

    public DownLoad(ApiURL apiURL, String ... params) {
        this.apiURL = apiURL;
        this.params = params;
    }

    public DownLoad msgId(String msgId) {
        this.msgId = msgId;
        return this;
    }

    public DownLoad suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public DownLoad saveByDay() {
        this.saveByDay = true;
        return this;
    }

    public String getFileName() {
        return this.msgId + this.suffix;
    }

    public String getDir(WeChatBot bot) {
        return bot.config().assetsDir() + "/" + this.apiURL.getDir();
    }

    public ApiURL getApiURL() {
        return this.apiURL;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public Object[] getParams() {
        return this.params;
    }

    public boolean isSaveByDay() {
        return this.saveByDay;
    }

    public void setApiURL(ApiURL apiURL) {
        this.apiURL = apiURL;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public void setParams(Object[] params) {
        this.params = params;
    }

    public void setSaveByDay(boolean saveByDay) {
        this.saveByDay = saveByDay;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DownLoad)) {
            return false;
        }
        DownLoad other = (DownLoad)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ApiURL this$apiURL = this.getApiURL();
        ApiURL other$apiURL = other.getApiURL();
        if (this$apiURL == null ? other$apiURL != null : !((Object)((Object)this$apiURL)).equals((Object)other$apiURL)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
            return false;
        }
        String this$msgId = this.getMsgId();
        String other$msgId = other.getMsgId();
        if (this$msgId == null ? other$msgId != null : !this$msgId.equals(other$msgId)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getParams(), other.getParams())) {
            return false;
        }
        return this.isSaveByDay() == other.isSaveByDay();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DownLoad;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApiURL $apiURL = this.getApiURL();
        result = result * 59 + ($apiURL == null ? 43 : ((Object)((Object)$apiURL)).hashCode());
        String $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        String $msgId = this.getMsgId();
        result = result * 59 + ($msgId == null ? 43 : $msgId.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getParams());
        result = result * 59 + (this.isSaveByDay() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "DownLoad(apiURL=" + (Object)((Object)this.getApiURL()) + ", suffix=" + this.getSuffix() + ", msgId=" + this.getMsgId() + ", params=" + Arrays.deepToString(this.getParams()) + ", saveByDay=" + this.isSaveByDay() + ")";
    }
}

