/*
 * Decompiled with CFR 0.152.
 */
package io.uouo.wechat.api.constant;

import io.uouo.wechat.exception.WeChatException;
import java.io.InputStream;
import java.util.Properties;

public class Config {
    private static final String CONF_ASSETS_DIR = "wechat.assets-path";
    private static final String CONF_ASSETS_DIR_DEFAULT = "assets";
    private static final String CONF_PRINT_TERMINAL = "wechat.print-terminal";
    private static final String CONF_PRINT_TERMINAL_DEFAULT = "false";
    private static final String CONF_AUTO_REPLY = "wechat.auto-reply";
    private static final String CONF_AUTO_REPLY_DEFAULT = "false";
    private static final String CONF_AUTO_LOGIN = "wechat.auto-login";
    private static final String CONF_AUTO_LOGIN_DEFAULT = "false";
    private static final String CONF_AUTO_ADDFRIEND = "wechat.auto-addfriend";
    private static final String CONF_AUTO_ADDFRIEND_DEFAULT = "false";
    private Properties props = new Properties();

    public static Config me() {
        return new Config();
    }

    public static Config load(String filePath) {
        Config config = new Config();
        try (InputStream stream = Config.class.getResourceAsStream(filePath);){
            config.props.load(stream);
        }
        catch (Exception e) {
            throw new WeChatException("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", e);
        }
        return config;
    }

    public String get(String key) {
        return this.props.getProperty(key);
    }

    public String get(String key, String defaultValue) {
        return this.props.getProperty(key, defaultValue);
    }

    public String assetsDir() {
        return this.props.getProperty(CONF_ASSETS_DIR, CONF_ASSETS_DIR_DEFAULT);
    }

    public Config assetsDir(String dir) {
        this.props.setProperty(CONF_ASSETS_DIR, dir);
        return this;
    }

    public boolean showTerminal() {
        return Boolean.valueOf(this.props.getProperty(CONF_PRINT_TERMINAL, "false"));
    }

    public Config showTerminal(boolean show) {
        this.props.setProperty(CONF_PRINT_TERMINAL, String.valueOf(show));
        return this;
    }

    public boolean autoReply() {
        return Boolean.valueOf(this.props.getProperty(CONF_AUTO_REPLY, "false"));
    }

    public Config autoReply(boolean autoReply) {
        this.props.setProperty(CONF_AUTO_REPLY, String.valueOf(autoReply));
        return this;
    }

    public Config autoLogin(boolean autoLogin) {
        this.props.setProperty(CONF_AUTO_LOGIN, String.valueOf(autoLogin));
        return this;
    }

    public Config autoAddFriend(boolean autoAddFriend) {
        this.props.setProperty(CONF_AUTO_ADDFRIEND, String.valueOf(autoAddFriend));
        return this;
    }

    public boolean autoAddFriend() {
        return Boolean.valueOf(this.props.getProperty(CONF_AUTO_ADDFRIEND, "false"));
    }

    public boolean autoLogin() {
        return Boolean.valueOf(this.props.getProperty(CONF_AUTO_LOGIN, "false"));
    }
}

