/*
 * Decompiled with CFR 0.152.
 */
package io.uouo.wechat.api.client;

import io.uouo.wechat.api.client.Callback;
import io.uouo.wechat.api.request.ApiRequest;
import io.uouo.wechat.api.response.ApiResponse;
import io.uouo.wechat.api.response.FileResponse;
import io.uouo.wechat.exception.WeChatException;
import io.uouo.wechat.utils.WeChatUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BotClient {
    private static final Logger log = LoggerFactory.getLogger(BotClient.class);
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static Map<String, List<Cookie>> cookieStore = new ConcurrentHashMap<String, List<Cookie>>();
    private OkHttpClient client;
    private OkHttpClient clientWithTimeout;

    public BotClient(OkHttpClient client) {
        this.client = client;
        System.setProperty("https.protocols", "TLSv1");
        System.setProperty("jsse.enableSNIExtension", "false");
    }

    public static void recoverCookie(Map<String, List<Cookie>> cookieStore) {
        BotClient.cookieStore.clear();
        BotClient.cookieStore = cookieStore;
    }

    public static Map<String, List<Cookie>> cookieStore() {
        return cookieStore;
    }

    public <T extends ApiRequest, R extends ApiResponse> void send(final T request, final Callback<T, R> callback) {
        OkHttpClient client = this.getOkHttpClient(request);
        client.newCall(this.createRequest(request)).enqueue(new okhttp3.Callback(){

            public void onResponse(Call call, Response response) {
                try {
                    String body = response.body().string();
                    if (log.isDebugEnabled()) {
                        log.debug("Response:\r\n{}", (Object)body);
                    }
                    if (ApiResponse.class.equals((Object)request.getResponseType())) {
                        callback.onResponse(request, new ApiResponse(body));
                    } else {
                        ApiResponse result = (ApiResponse)WeChatUtils.fromJson(body, request.getResponseType());
                        result.setRawBody(body);
                        callback.onResponse(request, result);
                    }
                }
                catch (Exception e) {
                    IOException ioEx = e instanceof IOException ? (IOException)e : new IOException(e);
                    callback.onFailure(request, ioEx);
                }
            }

            public void onFailure(Call call, IOException e) {
                callback.onFailure(request, e);
            }
        });
    }

    public <T extends ApiRequest, R extends ApiResponse> R send(ApiRequest<T, R> request) {
        try {
            List cookies;
            OkHttpClient client = this.getOkHttpClient(request);
            Request okHttpRequest = this.createRequest(request);
            Response response = client.newCall(okHttpRequest).execute();
            String body = response.body().string();
            if (log.isDebugEnabled()) {
                log.debug("Response :\r\n{}", (Object)body);
            }
            if ((cookies = Cookie.parseAll((HttpUrl)okHttpRequest.url(), (Headers)response.headers())) != null && cookies.size() > 0) {
                cookieStore.put(okHttpRequest.url().host(), cookies);
                if (!"webpush.web.wechat.com".equals(okHttpRequest.url().host())) {
                    cookieStore.put("webpush.web.wechat.com", cookies);
                }
                if (!"webpush.wx2.qq.com".equals(okHttpRequest.url().host())) {
                    cookieStore.put("webpush.wx2.qq.com", cookies);
                }
                if (!"wx2.qq.com".equals(okHttpRequest.url().host())) {
                    cookieStore.put("wx2.qq.com", cookies);
                }
                if (!"file.web.wechat.com".equals(okHttpRequest.url().host())) {
                    cookieStore.put("file.web.wechat.com", cookies);
                }
                if (!"web.wechat.com".equals(okHttpRequest.url().host())) {
                    cookieStore.put("web.wechat.com", cookies);
                }
            }
            if (ApiResponse.class.equals((Object)request.getResponseType())) {
                return (R)new ApiResponse(body);
            }
            ApiResponse result = (ApiResponse)WeChatUtils.fromJson(body, request.getResponseType());
            result.setRawBody(body);
            return (R)result;
        }
        catch (IOException e) {
            throw new WeChatException(e);
        }
    }

    public <T extends ApiRequest, R extends ApiResponse> R download(ApiRequest<T, R> request) {
        try {
            OkHttpClient client = this.getOkHttpClient(request);
            Response response = client.newCall(this.createRequest(request)).execute();
            return (R)new FileResponse(response.body().byteStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private OkHttpClient getOkHttpClient(ApiRequest request) {
        OkHttpClient client = this.timeout(request);
        if (request.isNoRedirect()) {
            return client.newBuilder().followRedirects(false).followSslRedirects(false).build();
        }
        return this.cookie(client);
    }

    private OkHttpClient timeout(ApiRequest request) {
        int timeoutMillis = request.getTimeout() * 1000;
        if (this.client.readTimeoutMillis() == 0 || this.client.readTimeoutMillis() > timeoutMillis) {
            return this.client;
        }
        if (null != this.clientWithTimeout && this.clientWithTimeout.readTimeoutMillis() > timeoutMillis) {
            return this.clientWithTimeout;
        }
        this.clientWithTimeout = this.client.newBuilder().readTimeout((long)(timeoutMillis + 1000), TimeUnit.MILLISECONDS).build();
        return this.clientWithTimeout;
    }

    private OkHttpClient cookie(OkHttpClient client) {
        return client.newBuilder().cookieJar(new CookieJar(){

            public void saveFromResponse(HttpUrl httpUrl, List<Cookie> cookies) {
            }

            public List<Cookie> loadForRequest(HttpUrl httpUrl) {
                List cookies = (List)cookieStore.get(httpUrl.host());
                return cookies != null ? cookies : new ArrayList();
            }
        }).build();
    }

    public List<Cookie> cookies() {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        Collection<List<Cookie>> values = cookieStore.values();
        for (List<Cookie> value : values) {
            cookies.addAll(value);
        }
        return cookies;
    }

    public String cookie(String name) {
        for (Cookie cookie : this.cookies()) {
            if (!cookie.name().equalsIgnoreCase(name)) continue;
            return cookie.value();
        }
        return null;
    }

    private Request createRequest(ApiRequest request) {
        Request.Builder builder = new Request.Builder();
        if ("GET".equalsIgnoreCase(request.getMethod())) {
            builder.get();
            if (null != request.getParameters() && request.getParameters().size() > 0) {
                Set<String> keys = request.getParameters().keySet();
                StringBuilder sbuf = new StringBuilder(request.getUrl());
                if (request.getUrl().contains("=")) {
                    sbuf.append("&");
                } else {
                    sbuf.append("?");
                }
                for (String key : keys) {
                    sbuf.append(key).append('=').append(request.getParameters().get(key)).append('&');
                }
                request.url(sbuf.substring(0, sbuf.length() - 1));
            }
        } else {
            builder.method(request.getMethod(), this.createRequestBody(request));
        }
        builder.url(request.getUrl());
        if (log.isDebugEnabled()) {
            log.debug("Request : {}", (Object)request.getUrl());
        }
        if (null != request.getHeaders()) {
            builder.headers(request.getHeaders());
        }
        return builder.build();
    }

    private RequestBody createRequestBody(ApiRequest<?, ?> request) {
        if (request.isMultipart()) {
            MediaType contentType = MediaType.parse((String)request.getContentType());
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            for (Map.Entry<String, Object> parameter : request.getParameters().entrySet()) {
                String name = parameter.getKey();
                Object value = parameter.getValue();
                if (value instanceof byte[]) {
                    builder.addFormDataPart(name, request.getFileName(), RequestBody.create((MediaType)contentType, (byte[])((byte[])value)));
                    continue;
                }
                if (value instanceof File) {
                    builder.addFormDataPart(name, request.getFileName(), RequestBody.create((MediaType)contentType, (File)((File)value)));
                    continue;
                }
                if (value instanceof RequestBody) {
                    builder.addFormDataPart(name, request.getFileName(), (RequestBody)value);
                    continue;
                }
                builder.addFormDataPart(name, String.valueOf(value));
            }
            return builder.build();
        }
        if (request.isJsonBody()) {
            String json = WeChatUtils.toJson(request.getParameters());
            if (log.isDebugEnabled()) {
                log.debug("Request Body:\r\n{}", (Object)json);
            }
            return RequestBody.create((MediaType)JSON, (String)json);
        }
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<String, Object> parameter : request.getParameters().entrySet()) {
            builder.add(parameter.getKey(), String.valueOf(parameter.getValue()));
        }
        return builder.build();
    }
}

