/*
 * Decompiled with CFR 0.152.
 */
package io.uouo.wechat.api;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.uouo.wechat.WeChatBot;
import io.uouo.wechat.api.ChatLoop;
import io.uouo.wechat.api.WeChatApi;
import io.uouo.wechat.api.client.BotClient;
import io.uouo.wechat.api.constant.Constant;
import io.uouo.wechat.api.enums.AccountType;
import io.uouo.wechat.api.enums.ApiURL;
import io.uouo.wechat.api.enums.RetCode;
import io.uouo.wechat.api.model.Account;
import io.uouo.wechat.api.model.DownLoad;
import io.uouo.wechat.api.model.HotReload;
import io.uouo.wechat.api.model.LoginSession;
import io.uouo.wechat.api.model.Message;
import io.uouo.wechat.api.model.Recommend;
import io.uouo.wechat.api.model.SendMessage;
import io.uouo.wechat.api.model.SyncCheckRet;
import io.uouo.wechat.api.model.SyncKey;
import io.uouo.wechat.api.model.WeChatMessage;
import io.uouo.wechat.api.request.BaseRequest;
import io.uouo.wechat.api.request.FileRequest;
import io.uouo.wechat.api.request.JsonRequest;
import io.uouo.wechat.api.request.StringRequest;
import io.uouo.wechat.api.response.ApiResponse;
import io.uouo.wechat.api.response.FileResponse;
import io.uouo.wechat.api.response.JsonResponse;
import io.uouo.wechat.api.response.MediaResponse;
import io.uouo.wechat.api.response.WebInitResponse;
import io.uouo.wechat.api.response.WebSyncResponse;
import io.uouo.wechat.exception.WeChatException;
import io.uouo.wechat.utils.DateUtils;
import io.uouo.wechat.utils.MD5Checksum;
import io.uouo.wechat.utils.QRCodeUtils;
import io.uouo.wechat.utils.StringUtils;
import io.uouo.wechat.utils.WeChatUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeChatApiImpl
implements WeChatApi {
    private static final Logger log = LoggerFactory.getLogger(WeChatApiImpl.class);
    private static final Pattern UUID_PATTERN = Pattern.compile("window.QRLogin.code = (\\d+); window.QRLogin.uuid = \"(\\S+?)\";");
    private static final Pattern CHECK_LOGIN_PATTERN = Pattern.compile("window.code=(\\d+)");
    private static final Pattern PROCESS_LOGIN_PATTERN = Pattern.compile("window.redirect_uri=\"(\\S+)\";");
    private static final Pattern SYNC_CHECK_PATTERN = Pattern.compile("window.synccheck=\\{retcode:\"(\\d+)\",selector:\"(\\d+)\"}");
    private String uuid;
    private boolean logging;
    private int memberCount;
    private WeChatBot bot;
    private BotClient client;
    private Map<String, Account> accountMap = new HashMap<String, Account>();
    private List<Account> specialUsersList = Collections.EMPTY_LIST;
    private List<Account> publicUsersList = Collections.EMPTY_LIST;
    private List<Account> contactList = Collections.EMPTY_LIST;
    private List<Account> groupList = Collections.EMPTY_LIST;
    private Set<String> groupUserNames = new HashSet<String>();

    public WeChatApiImpl(WeChatBot bot) {
        this.bot = bot;
        this.client = bot.client();
    }

    private void autoLogin() {
        String file = this.bot.config().assetsDir() + "/login.json";
        try {
            HotReload hotReload = (HotReload)WeChatUtils.fromJson(new FileReader(file), HotReload.class);
            hotReload.reLogin(this.bot);
        }
        catch (FileNotFoundException e) {
            this.login(false);
        }
    }

    @Override
    public void login(boolean autoLogin) {
        if (this.bot.isRunning() || this.logging) {
            log.warn("\u5fae\u4fe1\u5df2\u7ecf\u767b\u5f55");
            return;
        }
        if (autoLogin) {
            this.autoLogin();
        } else {
            this.logging = true;
            while (this.logging) {
                this.uuid = this.pushLogin();
                if (null == this.uuid) {
                    while (null == this.getUUID()) {
                        DateUtils.sleep(10L);
                    }
                    log.info("\u5f00\u59cb\u4e0b\u8f7d\u4e8c\u7ef4\u7801");
                    this.getQrImage(this.uuid, this.bot.config().showTerminal());
                    log.info("\u8bf7\u4f7f\u7528\u624b\u673a\u626b\u63cf\u5c4f\u5e55\u4e8c\u7ef4\u7801");
                }
                Boolean isLoggedIn = false;
                while (null == isLoggedIn || !isLoggedIn.booleanValue()) {
                    String status = this.checkLogin(this.uuid);
                    if ("200".equals(status)) {
                        isLoggedIn = true;
                    } else if ("201".equals(status)) {
                        if (null != isLoggedIn) {
                            log.info("\u8bf7\u5728\u624b\u673a\u4e0a\u786e\u8ba4\u767b\u5f55");
                            isLoggedIn = null;
                        }
                    } else if ("408".equals(status)) break;
                    DateUtils.sleep(300L);
                }
                if (null != isLoggedIn && isLoggedIn.booleanValue()) break;
                if (!this.logging) continue;
                log.info("\u767b\u5f55\u8d85\u65f6\uff0c\u91cd\u65b0\u52a0\u8f7d\u4e8c\u7ef4\u7801");
            }
        }
        this.webInit();
        this.statusNotify();
        this.loadContact(0);
        log.info("\u5e94\u6709 {} \u4e2a\u8054\u7cfb\u4eba\uff0c\u8bfb\u53d6\u5230\u8054\u7cfb\u4eba {} \u4e2a", (Object)this.memberCount, (Object)this.accountMap.size());
        System.out.println();
        log.info("\u5171\u6709 {} \u4e2a\u7fa4 | {} \u4e2a\u76f4\u63a5\u8054\u7cfb\u4eba | {} \u4e2a\u7279\u6b8a\u8d26\u53f7 \uff5c {} \u516c\u4f17\u53f7\u6216\u670d\u52a1\u53f7", new Object[]{this.groupUserNames.size(), this.contactList.size(), this.specialUsersList.size(), this.publicUsersList.size()});
        this.loadGroupList();
        log.info("[{}] \u767b\u5f55\u6210\u529f.", (Object)this.bot.session().getNickName());
        this.startRevive();
        this.logging = false;
    }

    private String getUUID() {
        log.info("\u83b7\u53d6\u4e8c\u7ef4\u7801UUID");
        Object response = this.client.send(((StringRequest)((StringRequest)((StringRequest)((StringRequest)new StringRequest("https://login.weixin.qq.com/jslogin").add("appid", "wx782c26e4c19acffb")).add("redirect_uri", "https://wx.qq.com/cgi-bin/mmwebwx-bin/webwxnewloginpage?mod=desktop&fun")).add("fun", "new")).add("lang", "en_")).add("_", System.currentTimeMillis()));
        Matcher matcher = UUID_PATTERN.matcher(((ApiResponse)response).getRawBody());
        if (matcher.find() && "200".equals(matcher.group(1))) {
            this.uuid = matcher.group(2);
        }
        return this.uuid;
    }

    private void getQrImage(String uuid, boolean terminalShow) {
        String uid = null != uuid ? uuid : this.uuid;
        String imgDir = this.bot.config().assetsDir();
        FileResponse fileResponse = this.client.download(new FileRequest(String.format("%s/qrcode/%s", "https://login.weixin.qq.com", uid)));
        InputStream inputStream = fileResponse.getInputStream();
        File qrCode = WeChatUtils.saveFile(inputStream, imgDir, "qrcode.png");
        DateUtils.sleep(200L);
        try {
            QRCodeUtils.showQrCode(qrCode, terminalShow);
        }
        catch (Exception e) {
            this.getQrImage(uid, terminalShow);
        }
    }

    private String checkLogin(String uuid) {
        String uid = null != uuid ? uuid : this.uuid;
        String url = String.format("%s/cgi-bin/mmwebwx-bin/login", "https://login.weixin.qq.com");
        Long time = System.currentTimeMillis();
        Object response = this.client.send(((StringRequest)((StringRequest)((StringRequest)((StringRequest)((StringRequest)new StringRequest(url).add("loginicon", true)).add("uuid", uid)).add("tip", "1")).add("_", time)).add("r", (int)(-time.longValue() / 1000L) / 1579)).timeout(30));
        Matcher matcher = CHECK_LOGIN_PATTERN.matcher(((ApiResponse)response).getRawBody());
        if (matcher.find()) {
            if ("200".equals(matcher.group(1))) {
                if (!this.processLoginSession(((ApiResponse)response).getRawBody())) {
                    return "400";
                }
                return "200";
            }
            return matcher.group(1);
        }
        return "400";
    }

    private boolean processLoginSession(String loginContent) {
        LoginSession loginSession = this.bot.session();
        Matcher matcher = PROCESS_LOGIN_PATTERN.matcher(loginContent);
        if (matcher.find()) {
            loginSession.setUrl(matcher.group(1));
        }
        Object response = this.client.send(new StringRequest(loginSession.getUrl()).noRedirect());
        loginSession.setUrl(loginSession.getUrl().substring(0, loginSession.getUrl().lastIndexOf("/")));
        String body = ((ApiResponse)response).getRawBody();
        ArrayList<String> fileUrl = new ArrayList<String>();
        ArrayList<String> syncUrl = new ArrayList<String>();
        for (int i = 0; i < Constant.FILE_URL.size(); ++i) {
            fileUrl.add(String.format("https://%s/cgi-bin/mmwebwx-bin", Constant.FILE_URL.get(i)));
            syncUrl.add(String.format("https://%s/cgi-bin/mmwebwx-bin", Constant.WEB_PUSH_URL.get(i)));
        }
        boolean flag = false;
        for (int i = 0; i < Constant.FILE_URL.size(); ++i) {
            String indexUrl = Constant.INDEX_URL.get(i);
            if (!loginSession.getUrl().contains(indexUrl)) continue;
            loginSession.setFileUrl((String)fileUrl.get(i));
            loginSession.setSyncUrl((String)syncUrl.get(i));
            flag = true;
            break;
        }
        if (!flag) {
            loginSession.setFileUrl(loginSession.getUrl());
            loginSession.setSyncUrl(loginSession.getUrl());
        }
        loginSession.setDeviceId("e" + String.valueOf(System.currentTimeMillis()));
        BaseRequest baseRequest = new BaseRequest();
        loginSession.setBaseRequest(baseRequest);
        loginSession.setSKey(WeChatUtils.match("<skey>(\\S+)</skey>", body));
        loginSession.setWxSid(WeChatUtils.match("<wxsid>(\\S+)</wxsid>", body));
        loginSession.setWxUin(WeChatUtils.match("<wxuin>(\\S+)</wxuin>", body));
        loginSession.setPassTicket(WeChatUtils.match("<pass_ticket>(\\S+)</pass_ticket>", body));
        baseRequest.setSkey(loginSession.getSKey());
        baseRequest.setSid(loginSession.getWxSid());
        baseRequest.setUin(loginSession.getWxUin());
        baseRequest.setDeviceID(loginSession.getDeviceId());
        return true;
    }

    private String pushLogin() {
        String uin = this.client.cookie("wxUin");
        if (StringUtils.isEmpty(uin)) {
            return null;
        }
        String url = String.format("%s/cgi-bin/mmwebwx-bin/webwxpushloginurl?uin=%s", "https://login.weixin.qq.com", uin);
        JsonResponse jsonResponse = this.client.send(new JsonRequest(url));
        return jsonResponse.getString("uuid");
    }

    private void statusNotify() {
        log.info("\u5f00\u542f\u72b6\u6001\u901a\u77e5");
        String url = String.format("%s/webwxstatusnotify?lang=zh_CN&pass_ticket=%s", this.bot.session().getUrl(), this.bot.session().getPassTicket());
        this.client.send(((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)new JsonRequest(url).post()).jsonBody()).add("BaseRequest", this.bot.session().getBaseRequest())).add("Code", 3)).add("FromUserName", this.bot.session().getUserName())).add("ToUserName", this.bot.session().getUserName())).add("ClientMsgId", System.currentTimeMillis() / 1000L));
    }

    private void webInit() {
        log.info("\u5fae\u4fe1\u521d\u59cb\u5316...");
        int r = (int)(-System.currentTimeMillis() / 1000L) / 1579;
        String url = String.format("%s/webwxinit?r=%d&pass_ticket=%s", this.bot.session().getUrl(), r, this.bot.session().getPassTicket());
        JsonResponse response = (JsonResponse)this.client.send(((JsonRequest)((JsonRequest)new JsonRequest(url).post()).jsonBody()).add("BaseRequest", this.bot.session().getBaseRequest()));
        WebInitResponse webInitResponse = response.parse(WebInitResponse.class);
        List<Account> contactList = webInitResponse.getContactList();
        this.syncRecentContact(contactList);
        Account account = webInitResponse.getAccount();
        SyncKey syncKey = webInitResponse.getSyncKey();
        this.bot.session().setInviteStartCount(webInitResponse.getInviteStartCount());
        this.bot.session().setAccount(account);
        this.bot.session().setUserName(account.getUserName());
        this.bot.session().setNickName(account.getNickName());
        this.bot.session().setSyncKey(syncKey);
    }

    private void startRevive() {
        this.bot.setRunning(true);
        Thread thread = new Thread(new ChatLoop(this.bot));
        thread.setName("wechat-listener");
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public SyncCheckRet syncCheck() {
        String url = String.format("%s/synccheck", this.bot.session().getSyncOrUrl());
        try {
            Object response = this.client.send(((StringRequest)((StringRequest)((StringRequest)((StringRequest)((StringRequest)((StringRequest)((StringRequest)new StringRequest(url).add("r", System.currentTimeMillis())).add("skey", this.bot.session().getSKey())).add("sid", this.bot.session().getWxSid())).add("uin", this.bot.session().getWxUin())).add("deviceid", this.bot.session().getDeviceId())).add("synckey", this.bot.session().getSyncKeyStr())).add("_", System.currentTimeMillis())).timeout(30));
            Matcher matcher = SYNC_CHECK_PATTERN.matcher(((ApiResponse)response).getRawBody());
            if (matcher.find()) {
                if (!"0".equals(matcher.group(1))) {
                    log.debug("Unexpected sync check result: {}", (Object)((ApiResponse)response).getRawBody());
                    return new SyncCheckRet(RetCode.parse(Integer.valueOf(matcher.group(1))), 0);
                }
                return new SyncCheckRet(RetCode.parse(Integer.valueOf(matcher.group(1))), Integer.valueOf(matcher.group(2)));
            }
            return new SyncCheckRet(RetCode.UNKNOWN, 0);
        }
        catch (Exception e) {
            if (e instanceof SocketTimeoutException) {
                log.warn("\u5fc3\u8df3\u68c0\u67e5\u8d85\u65f6");
                return this.syncCheck();
            }
            log.error("\u5fc3\u8df3\u68c0\u67e5\u51fa\u9519", (Throwable)e);
            return new SyncCheckRet(RetCode.UNKNOWN, 0);
        }
    }

    @Override
    public WebSyncResponse webSync() {
        String url = String.format("%s/webwxsync?sid=%s&sKey=%s&passTicket=%s", this.bot.session().getUrl(), this.bot.session().getWxSid(), this.bot.session().getSKey(), this.bot.session().getPassTicket());
        JsonResponse response = (JsonResponse)this.client.send(((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)new JsonRequest(url).post()).jsonBody()).add("BaseRequest", this.bot.session().getBaseRequest())).add("SyncKey", this.bot.session().getSyncKey())).add("rr", System.currentTimeMillis() / 1000L ^ 0xFFFFFFFFFFFFFFFFL));
        WebSyncResponse webSyncResponse = response.parse(WebSyncResponse.class);
        if (!webSyncResponse.success()) {
            log.warn("\u83b7\u53d6\u6d88\u606f\u5931\u8d25");
            return webSyncResponse;
        }
        this.bot.session().setSyncKey(webSyncResponse.getSyncKey());
        return webSyncResponse;
    }

    @Override
    public void logout() {
        if (this.bot.isRunning()) {
            String url = String.format("%s/webwxlogout", this.bot.session().getUrl());
            this.client.send(((StringRequest)((StringRequest)new StringRequest(url).add("redirect", 1)).add("type", 1)).add("sKey", this.bot.session().getSKey()));
            this.bot.setRunning(false);
        }
        this.logging = false;
        this.client.cookies().clear();
        String file = this.bot.config().assetsDir() + "/login.json";
        new File(file).delete();
    }

    @Override
    public void loadContact(int seq) {
        log.info("\u5f00\u59cb\u83b7\u53d6\u8054\u7cfb\u4eba\u4fe1\u606f");
        do {
            String url = String.format("%s/webwxgetcontact?r=%s&seq=%s&skey=%s", this.bot.session().getUrl(), System.currentTimeMillis(), seq, this.bot.session().getSKey());
            JsonResponse response = (JsonResponse)this.client.send(new JsonRequest(url).jsonBody());
            JsonObject jsonObject = response.toJsonObject();
            seq = jsonObject.get("Seq").getAsInt();
            this.memberCount += jsonObject.get("MemberCount").getAsInt();
            List<Account> memberList = WeChatUtils.fromJson(WeChatUtils.toJson(jsonObject.getAsJsonArray("MemberList")), new TypeToken<List<Account>>(){});
            for (Account account : memberList) {
                if (null != account.getUserName()) continue;
                this.accountMap.put(account.getUserName(), account);
            }
        } while (seq != 0);
        this.contactList = new ArrayList<Account>(this.getAccountByType(AccountType.TYPE_FRIEND));
        this.publicUsersList = new ArrayList<Account>(this.getAccountByType(AccountType.TYPE_MP));
        this.specialUsersList = new ArrayList<Account>(this.getAccountByType(AccountType.TYPE_SPECIAL));
        Set<Account> groupAccounts = this.getAccountByType(AccountType.TYPE_GROUP);
        for (Account groupAccount : groupAccounts) {
            this.groupUserNames.add(groupAccount.getUserName());
        }
    }

    public void loadGroupList() {
        log.info("\u52a0\u8f7d\u7fa4\u804a\u4fe1\u606f");
        ArrayList list = new ArrayList(this.groupUserNames.size());
        for (String groupUserName : this.groupUserNames) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("UserName", groupUserName);
            map.put("EncryChatRoomId", "");
            list.add(map);
        }
        String url = String.format("%s/webwxbatchgetcontact?type=ex&r=%s&pass_ticket=%s", this.bot.session().getUrl(), System.currentTimeMillis() / 1000L, this.bot.session().getPassTicket());
        JsonResponse jsonResponse = (JsonResponse)this.client.send(((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)new JsonRequest(url).post()).jsonBody()).add("BaseRequest", this.bot.session().getBaseRequest())).add("Count", this.groupUserNames.size())).add("List", list));
        this.groupList = WeChatUtils.fromJson(WeChatUtils.toJson(jsonResponse.toJsonObject().getAsJsonArray("ContactList")), new TypeToken<List<Account>>(){});
    }

    @Override
    public Account getAccountById(String id) {
        return this.accountMap.get(id);
    }

    @Override
    public Account getAccountByName(String name) {
        for (Account account : this.accountMap.values()) {
            if (name.equals(account.getRemarkName())) {
                return account;
            }
            if (!name.equals(account.getNickName())) continue;
            return account;
        }
        return null;
    }

    @Override
    public boolean revokeMsg(String msgId, String toUser) {
        String url = String.format("%s/webwxrevokemsg?pass_ticket=%s&r=%s", this.bot.session().getUrl(), this.bot.session().getPassTicket(), System.currentTimeMillis() / 1000L);
        JsonResponse response = (JsonResponse)this.client.send(((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)new JsonRequest(url).post()).jsonBody()).add("SvrMsgId", msgId)).add("ToUserName", toUser)).add("ClientMsgId", System.currentTimeMillis())).add("BaseRequest", this.bot.session().getBaseRequest()));
        return null != response && response.success();
    }

    @Override
    public boolean verify(Recommend recommend) {
        String url = String.format("%s/webwxverifyuser?r=%s&lang=zh_CN&pass_ticket=%s", this.bot.session().getUrl(), System.currentTimeMillis() / 1000L, this.bot.session().getPassTicket());
        ArrayList verifyUserList = new ArrayList();
        HashMap<String, String> verifyUser = new HashMap<String, String>(2);
        verifyUser.put("Value", recommend.getUserName());
        verifyUser.put("VerifyUserTicket", recommend.getTicket());
        verifyUserList.add(verifyUser);
        JsonResponse response = (JsonResponse)this.client.send(((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)new JsonRequest(url).post()).jsonBody()).add("BaseRequest", this.bot.session().getBaseRequest())).add("Opcode", 3)).add("VerifyUserListSize", 1)).add("VerifyUserList", verifyUserList)).add("VerifyContent", "")).add("SceneListCount", 1)).add("SceneList", Arrays.asList(33))).add("skey", this.bot.session().getSyncKeyStr()));
        return null != response && response.success();
    }

    @Override
    public boolean addFriend(String friendUserName, String msg) {
        String url = String.format("%s/webwxverifyuser?r=%s&lang=zh_CN&pass_ticket=%s", this.bot.session().getUrl(), System.currentTimeMillis() / 1000L, this.bot.session().getPassTicket());
        ArrayList verifyUserList = new ArrayList();
        HashMap<String, String> verifyUser = new HashMap<String, String>(2);
        verifyUser.put("Value", friendUserName);
        verifyUser.put("VerifyUserTicket", "");
        verifyUserList.add(verifyUser);
        JsonResponse response = (JsonResponse)this.client.send(((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)new JsonRequest(url).post()).jsonBody()).add("BaseRequest", this.bot.session().getBaseRequest())).add("Opcode", 2)).add("VerifyUserListSize", 1)).add("VerifyUserList", verifyUserList)).add("VerifyContent", msg)).add("SceneListCount", 1)).add("SceneList", Arrays.asList(33))).add("skey", this.bot.session().getSyncKeyStr()));
        return null != response && response.success();
    }

    @Override
    public boolean createChatRoom(String topic, List<String> members) {
        String url = String.format("%s/webwxcreatechatroom?r=%s&lang=zh_CN", this.bot.session().getUrl());
        ArrayList memberList = new ArrayList(members.size());
        for (String member : members) {
            HashMap<String, String> m = new HashMap<String, String>(2);
            m.put("UserName", member);
            memberList.add(m);
        }
        JsonResponse response = (JsonResponse)this.client.send(((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)new JsonRequest(url).post()).jsonBody()).add("MemberCount", members.size())).add("MemberList", memberList)).add("Topic", topic)).add("BaseRequest", this.bot.session().getBaseRequest()));
        return null != response && response.success();
    }

    @Override
    public boolean removeMemberByGroup(String member, String group) {
        String url = String.format("%s/webwxupdatechatroom?fun=delmember", this.bot.session().getUrl());
        JsonResponse response = (JsonResponse)this.client.send(((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)new JsonRequest(url).post()).jsonBody()).add("DelMemberList", member)).add("ChatRoomName", group)).add("BaseRequest", this.bot.session().getBaseRequest()));
        return null != response && response.success();
    }

    @Override
    public boolean inviteJoinGroup(String member, String group) {
        String url = String.format("%s/webwxupdatechatroom?fun=addmember", this.bot.session().getUrl());
        JsonResponse response = (JsonResponse)this.client.send(((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)new JsonRequest(url).post()).jsonBody()).add("AddMemberList", member)).add("ChatRoomName", group)).add("BaseRequest", this.bot.session().getBaseRequest()));
        return null != response && response.success();
    }

    @Override
    public boolean modifyGroupName(String oldTopic, String newTopic) {
        Account account = this.getAccountByName(oldTopic);
        if (null == account) {
            log.warn("\u627e\u4e0d\u5230\u7fa4: [{}] \u66f4\u6362\u7fa4\u540d\u5931\u8d25", (Object)oldTopic);
            return false;
        }
        String url = String.format("%s/webwxupdatechatroom?fun=modtopic", this.bot.session().getUrl());
        JsonResponse response = (JsonResponse)this.client.send(((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)new JsonRequest(url).post()).jsonBody()).add("NewTopic", newTopic)).add("ChatRoomName", account.getUserName())).add("BaseRequest", this.bot.session().getBaseRequest()));
        return null != response && response.success();
    }

    private String getUserRemarkName(String id) {
        String name;
        String string = name = id.contains("@@") ? "\u672a\u77e5\u7fa4" : "\u964c\u751f\u4eba";
        if (id.equals(this.bot.session().getUserName())) {
            return this.bot.session().getNickName();
        }
        Account account = this.accountMap.get(id);
        if (null == account) {
            return name;
        }
        String nickName = StringUtils.isNotEmpty(account.getRemarkName()) ? account.getRemarkName() : account.getNickName();
        return StringUtils.isNotEmpty(nickName) ? nickName : name;
    }

    private List<Account> getNameById(String id) {
        String url = String.format("%s/webwxbatchgetcontact?type=ex&r=%s&pass_ticket=%s", this.bot.session().getUrl(), System.currentTimeMillis() / 1000L, this.bot.session().getPassTicket());
        ArrayList list = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("UserName", id);
        map.put("EncryChatRoomId", id);
        list.add(map);
        JsonResponse response = (JsonResponse)this.client.send(((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)new JsonRequest(url).post()).jsonBody()).add("BaseRequest", this.bot.session().getBaseRequest())).add("Count", this.bot.session().getBaseRequest())).add("List", list));
        return WeChatUtils.fromJson(WeChatUtils.toJson(response.toJsonObject().getAsJsonObject("")), new TypeToken<List<Account>>(){});
    }

    public Set<Account> getAccountByType(AccountType accountType) {
        HashSet<Account> accountSet = new HashSet<Account>();
        for (Account account : this.accountMap.values()) {
            if (!account.getAccountType().equals((Object)accountType)) continue;
            accountSet.add(account);
        }
        return accountSet;
    }

    public void syncRecentContact(List<Account> contactList) {
        if (null != contactList && contactList.size() > 0) {
            for (Account account : contactList) {
                this.accountMap.put(account.getUserName(), account);
            }
        }
    }

    @Override
    public List<WeChatMessage> handleMsg(List<Message> messages) {
        if (null != messages && messages.size() > 0) {
            ArrayList<WeChatMessage> weChatMessages = new ArrayList<WeChatMessage>(messages.size());
            boolean hashNewMsg = false;
            for (Message message : messages) {
                WeChatMessage weChatMessage = this.processMsg(message);
                if (null == weChatMessage) continue;
                weChatMessages.add(weChatMessage);
                hashNewMsg = true;
            }
            if (hashNewMsg) {
                log.info("\u4f60\u6709\u65b0\u7684\u6d88\u606f");
            }
            return weChatMessages;
        }
        return null;
    }

    private WeChatMessage processMsg(Message message) {
        Integer type = message.getType();
        String name = this.getUserRemarkName(message.getFromUserName());
        String msgId = message.getId();
        String content = message.getContent();
        if (message.getFromUserName().equals(this.bot.session().getUserName())) {
            return null;
        }
        if (message.isGroup()) {
            if (message.getFromUserName().contains("@@") && !this.groupUserNames.contains(message.getFromUserName())) {
                this.groupUserNames.add(message.getFromUserName());
            }
            if (message.getToUserName().contains("@@") && !this.groupUserNames.contains(message.getToUserName())) {
                this.groupUserNames.add(message.getToUserName());
            }
            if (content.contains(":<br/>")) {
                content = content.substring(content.indexOf(":<br/>") + 6);
            }
        }
        content = WeChatUtils.formatMsg(content);
        WeChatMessage.WeChatMessageBuilder weChatMessageBuilder = WeChatMessage.builder().raw(message).id(message.getId()).fromUserName(message.getFromUserName()).toUserName(message.getToUserName()).mineUserName(this.bot.session().getUserName()).mineNickName(this.bot.session().getNickName()).msgType(message.msgType()).text(content);
        Account fromAccount = this.getAccountById(message.getFromUserName());
        if (null == fromAccount) {
            log.warn("\u6d88\u606f\u7c7b\u578b: {}", (Object)message.msgType());
            log.warn("\u6d88\u606f\u4e3b\u4f53: {}", (Object)WeChatUtils.toPrettyJson(message));
        } else {
            weChatMessageBuilder.fromNickName(fromAccount.getNickName()).fromRemarkName(fromAccount.getRemarkName());
            if (log.isDebugEnabled()) {
                log.debug("\u6536\u5230\u6d88\u606fJSON: {}", (Object)WeChatUtils.toJson(message));
            }
        }
        switch (message.msgType()) {
            case TEXT: {
                if (content.startsWith("@" + this.bot.session().getNickName())) {
                    content = content.substring(content.indexOf(" "));
                }
                if (content.contains("/cgi-bin/mmwebwx-bin/webwxgetpubliclinkimg?url=")) {
                    int pos = content.indexOf(":");
                    content = content.substring(0, pos);
                    weChatMessageBuilder.isLocation(true).text(content);
                }
                return weChatMessageBuilder.text(content).build();
            }
            case IMAGE: {
                String imgPath = this.downloadImg(msgId);
                return weChatMessageBuilder.imagePath(imgPath).build();
            }
            case VOICE: {
                String voicePath = this.downloadVoice(msgId);
                return weChatMessageBuilder.voicePath(voicePath).build();
            }
            case ADD_FRIEND: {
                return weChatMessageBuilder.text(message.getRecommend().getContent()).build();
            }
            case PERSON_CARD: {
                return weChatMessageBuilder.recommend(message.getRecommend()).build();
            }
            case VIDEO: {
                String videoPath = this.downloadVideo(msgId);
                return weChatMessageBuilder.videoPath(videoPath).build();
            }
            case EMOTICONS: {
                String imgUrl = this.searchContent("cdnurl", content);
                return weChatMessageBuilder.imagePath(imgUrl).build();
            }
            case SHARE: {
                String shareUrl = message.getUrl();
                return weChatMessageBuilder.text(shareUrl).build();
            }
            case CONTACT_INIT: {
                log.info("\u8054\u7cfb\u4eba\u521d\u59cb\u5316");
                return null;
            }
            case SYSTEM: {
                break;
            }
            case REVOKE_MSG: {
                log.info("{} \u64a4\u56de\u4e86\u4e00\u6761\u6d88\u606f: {}", (Object)name, (Object)content);
                return weChatMessageBuilder.build();
            }
            default: {
                log.info("\u8be5\u6d88\u606f\u7c7b\u578b\u4e3a: {}, \u53ef\u80fd\u662f\u8868\u60c5\uff0c\u56fe\u7247, \u94fe\u63a5\u6216\u7ea2\u5305: {}", (Object)type, (Object)WeChatUtils.toJson(message));
            }
        }
        return weChatMessageBuilder.build();
    }

    private String searchContent(String key, String content) {
        String r = WeChatUtils.match(key + "\\s?=\\s?\"([^\"<]+)\"", content);
        if (StringUtils.isNotEmpty(r)) {
            return r;
        }
        r = WeChatUtils.match(String.format("<%s>([^<]+)</%s>", key, key), content);
        if (StringUtils.isNotEmpty(r)) {
            return r;
        }
        r = WeChatUtils.match(String.format("<%s><\\!\\[CDATA\\[(.*?)\\]\\]></%s>", key, key), content);
        if (StringUtils.isNotEmpty(r)) {
            return r;
        }
        return "";
    }

    private String downloadImg(String msgId) {
        return this.downloadFile(new DownLoad(ApiURL.IMAGE, this.bot.session().getUrl(), msgId, this.bot.session().getSKey()).msgId(msgId).saveByDay());
    }

    private String downloadIconImg(String msgId) {
        return this.downloadFile(new DownLoad(ApiURL.ICON, this.bot.session().getUrl(), msgId, this.bot.session().getSKey()).msgId(msgId));
    }

    private String downloadHeadImg(String userName) {
        return this.downloadFile(new DownLoad(ApiURL.HEAD_IMG, this.bot.session().getUrl(), userName, this.bot.session().getSKey()).msgId(userName));
    }

    private String downloadVideo(String msgId) {
        return this.downloadFile(new DownLoad(ApiURL.VIDEO, this.bot.session().getUrl(), msgId, this.bot.session().getSKey()).msgId(msgId).saveByDay());
    }

    private String downloadVoice(String msgId) {
        return this.downloadFile(new DownLoad(ApiURL.VOICE, this.bot.session().getUrl(), msgId, this.bot.session().getSKey()).msgId(msgId).saveByDay());
    }

    private String downloadFile(DownLoad downLoad) {
        String url = String.format(downLoad.getApiURL().getUrl(), downLoad.getParams());
        FileResponse response = this.client.download(new FileRequest(url));
        InputStream inputStream = response.getInputStream();
        String id = downLoad.getFileName();
        String dir = downLoad.getDir(this.bot);
        return WeChatUtils.saveFileByDay(inputStream, dir, id, downLoad.isSaveByDay()).getPath();
    }

    @Override
    public MediaResponse uploadMedia(String toUser, String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new WeChatException("\u6587\u4ef6[" + filePath + "]\u4e0d\u5b58\u5728");
        }
        log.info("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6: {}", (Object)filePath);
        long size = file.length();
        String mimeType = WeChatUtils.getMimeType(filePath);
        String mediatype = "doc";
        if (mediatype.contains("image")) {
            mediatype = "pic";
        }
        if (mediatype.contains("audio")) {
            mediatype = "audio";
        }
        if (mediatype.contains("video")) {
            mediatype = "video";
        }
        String url = String.format("%s/webwxuploadmedia?f=json", this.bot.session().getFileUrl());
        String mediaId = System.currentTimeMillis() / 1000L + StringUtils.random(6);
        HashMap<String, Object> uploadMediaRequest = new HashMap<String, Object>(10);
        uploadMediaRequest.put("UploadType", 2);
        uploadMediaRequest.put("BaseRequest", this.bot.session().getBaseRequest());
        uploadMediaRequest.put("ClientMediaId", mediaId);
        uploadMediaRequest.put("TotalLen", size);
        uploadMediaRequest.put("StartPos", 0);
        uploadMediaRequest.put("DataLen", size);
        uploadMediaRequest.put("MediaType", 4);
        uploadMediaRequest.put("FromUserName", this.bot.session().getUserName());
        uploadMediaRequest.put("ToUserName", toUser);
        uploadMediaRequest.put("FileMd5", MD5Checksum.getMD5Checksum(file.getPath()));
        String dataTicket = this.client.cookie("webwx_data_ticket");
        if (StringUtils.isEmpty(dataTicket)) {
            throw new WeChatException("\u7f3a\u5c11\u4e86\u9644\u4ef6Cookie");
        }
        Object response = this.client.send(((StringRequest)((StringRequest)((StringRequest)((StringRequest)((StringRequest)((StringRequest)((StringRequest)((StringRequest)((StringRequest)((StringRequest)((StringRequest)((StringRequest)new StringRequest(url).post()).multipart()).fileName(file.getName())).add("id", "WU_FILE_0")).add("name", filePath)).add("type", mimeType)).add("lastModifieDate", new SimpleDateFormat("yyyy MM dd HH:mm:ss").format(new Date()))).add("size", String.valueOf(size))).add("mediatype", mediatype)).add("uploadmediarequest", WeChatUtils.toJson(uploadMediaRequest))).add("webwx_data_ticket", dataTicket)).add("pass_ticket", this.bot.session().getPassTicket())).add("filename", RequestBody.create((MediaType)MediaType.parse((String)mimeType), (File)file)));
        MediaResponse mediaResponse = ((ApiResponse)response).parse(MediaResponse.class);
        if (!mediaResponse.success()) {
            log.warn("\u4e0a\u4f20\u9644\u4ef6\u5931\u8d25: {}", (Object)mediaResponse.getMsg());
        }
        log.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f: {}", (Object)filePath);
        return mediaResponse;
    }

    @Override
    public boolean sendImg(String toUserName, String filePath) {
        DateUtils.sendSleep();
        String mediaId = this.uploadMedia(toUserName, filePath).getMediaId();
        if (StringUtils.isEmpty(mediaId)) {
            log.warn("Media\u4e3a\u7a7a");
            return false;
        }
        String url = String.format("%s/webwxsendmsgimg?fun=async&f=json&pass_ticket=%s", this.bot.session().getUrl(), this.bot.session().getPassTicket());
        String msgId = System.currentTimeMillis() / 1000L + StringUtils.random(6);
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("Type", 3);
        msg.put("MediaId", mediaId);
        msg.put("FromUserName", this.bot.session().getUserName());
        msg.put("ToUserName", toUserName);
        msg.put("LocalID", msgId);
        msg.put("ClientMsgId", msgId);
        JsonResponse response = (JsonResponse)this.client.send(((JsonRequest)((JsonRequest)((JsonRequest)new JsonRequest(url).post()).jsonBody()).add("BaseRequest", this.bot.session().getBaseRequest())).add("Msg", msg));
        return null != response && response.success();
    }

    @Override
    public boolean sendText(String toUserName, String msg) {
        DateUtils.sendSleep();
        String url = String.format("%s/webwxsendmsg?pass_ticket=%s", this.bot.session().getUrl(), this.bot.session().getPassTicket());
        String msgId = System.currentTimeMillis() / 1000L + StringUtils.random(6);
        JsonResponse response = (JsonResponse)this.client.send(((JsonRequest)((JsonRequest)((JsonRequest)new JsonRequest(url).post()).jsonBody()).add("BaseRequest", this.bot.session().getBaseRequest())).add("Msg", new SendMessage(1, msg, this.bot.session().getUserName(), toUserName, msgId, msgId)));
        return null != response && response.success();
    }

    @Override
    public boolean sendFile(String toUser, String filePath) {
        DateUtils.sendSleep();
        String title = new File(filePath).getName();
        MediaResponse mediaResponse = this.uploadMedia(toUser, filePath);
        if (null == mediaResponse) {
            log.warn("\u4e0a\u4f20\u9644\u4ef6\u5230\u5fae\u4fe1\u51fa\u9519");
            return false;
        }
        String url = String.format("%s/webwxsendappmsg?fun=async&f=json&pass_ticket=%s", this.bot.session().getUrl(), this.bot.session().getPassTicket());
        String fileSuffix = title.substring(title.lastIndexOf(".") + 1, title.length());
        String msgId = System.currentTimeMillis() + "";
        String content = String.format("<appmsg appid='wxeb7ec651dd0aefa9' sdkver=''><title>%s</title><des></des><action></action><type>6</type><content></content><url></url><lowurl></lowurl><appattach><totallen>%s</totallen><attachid>%s</attachid><fileext>%s</fileext></appattach><extinfo></extinfo></appmsg>", title, mediaResponse.getStartPos(), mediaResponse.getMediaId(), fileSuffix);
        HashMap<String, String> msgMap = new HashMap<String, String>(6);
        msgMap.put("Type", "6");
        msgMap.put("Content", content);
        msgMap.put("FromUserName", this.bot.session().getUserName());
        msgMap.put("ToUserName", toUser);
        msgMap.put("LocalID", msgId);
        msgMap.put("ClientMsgId", msgId);
        JsonResponse response = (JsonResponse)this.client.send(((JsonRequest)((JsonRequest)((JsonRequest)((JsonRequest)new JsonRequest(url).post()).jsonBody()).add("BaseRequest", this.bot.session().getBaseRequest())).add("Msg", msgMap)).add("Scene", 0));
        return null != response && response.success();
    }

    public Map<String, Account> getAccountMap() {
        return this.accountMap;
    }

    public List<Account> getSpecialUsersList() {
        return this.specialUsersList;
    }

    public List<Account> getPublicUsersList() {
        return this.publicUsersList;
    }

    public List<Account> getContactList() {
        return this.contactList;
    }

    public List<Account> getGroupList() {
        return this.groupList;
    }
}

