/*
 * Decompiled with CFR 0.152.
 */
package io.uouo.wechat.api;

import io.uouo.wechat.WeChatBot;
import io.uouo.wechat.api.WeChatApi;
import io.uouo.wechat.api.enums.RetCode;
import io.uouo.wechat.api.model.SyncCheckRet;
import io.uouo.wechat.api.response.WebSyncResponse;
import io.uouo.wechat.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatLoop
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ChatLoop.class);
    private WeChatBot bot;
    private WeChatApi api;
    private int retryCount = 0;

    ChatLoop(WeChatBot bot) {
        this.bot = bot;
        this.api = bot.api();
    }

    @Override
    public void run() {
        while (this.bot.isRunning()) {
            try {
                SyncCheckRet syncCheckRet = this.api.syncCheck();
                if (syncCheckRet.getRetCode() == RetCode.UNKNOWN) {
                    log.info("\u672a\u77e5\u72b6\u6001");
                    continue;
                }
                if (syncCheckRet.getRetCode() == RetCode.MOBILE_LOGIN_OUT) {
                    log.info("\u4f60\u5728\u624b\u673a\u4e0a\u767b\u51fa\u4e86\u5fae\u4fe1\uff0c\u518d\u89c1");
                    this.api.logout();
                    break;
                }
                if (syncCheckRet.getRetCode() == RetCode.LOGIN_OTHERWISE) {
                    log.info("\u4f60\u5728\u5176\u4ed6\u5730\u65b9\u767b\u5f55\u4e86 WEB \u7248\u5fae\u4fe1\uff0c\u518d\u89c1");
                    this.api.logout();
                    break;
                }
                if (syncCheckRet.getRetCode() == RetCode.NORMAL) {
                    this.bot.updateLastCheck();
                    WebSyncResponse webSyncResponse = this.api.webSync();
                    switch (syncCheckRet.getSelector()) {
                        case 2: {
                            if (null == webSyncResponse) break;
                            this.bot.addMessages(this.api.handleMsg(webSyncResponse.getAddMessageList()));
                            break;
                        }
                        case 6: {
                            log.info("\u6536\u5230\u7591\u4f3c\u7ea2\u5305\u6d88\u606f");
                            break;
                        }
                    }
                }
                if (System.currentTimeMillis() - this.bot.getLastCheckTs() > 30L) continue;
                DateUtils.sleep(System.currentTimeMillis() - this.bot.getLastCheckTs());
            }
            catch (Exception e) {
                log.warn(e.getMessage());
                ++this.retryCount;
                if (this.bot.getReceiveRetryCount() < this.retryCount) {
                    this.bot.setRunning(false);
                    continue;
                }
                DateUtils.sleep(1000L);
            }
        }
    }
}

