/*
 * Decompiled with CFR 0.152.
 */
package io.uouo.wechat;

import io.uouo.wechat.api.WeChatApi;
import io.uouo.wechat.api.WeChatApiImpl;
import io.uouo.wechat.api.annotation.Bind;
import io.uouo.wechat.api.client.BotClient;
import io.uouo.wechat.api.constant.Config;
import io.uouo.wechat.api.enums.MsgType;
import io.uouo.wechat.api.model.Account;
import io.uouo.wechat.api.model.HotReload;
import io.uouo.wechat.api.model.Invoke;
import io.uouo.wechat.api.model.LoginSession;
import io.uouo.wechat.api.model.WeChatMessage;
import io.uouo.wechat.exception.WeChatException;
import io.uouo.wechat.utils.DateUtils;
import io.uouo.wechat.utils.OkHttpUtils;
import io.uouo.wechat.utils.WeChatUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeChatBot {
    private static final Logger log = LoggerFactory.getLogger(WeChatBot.class);
    private WeChatApi api;
    private BotClient botClient;
    private Config config;
    private boolean running;
    private LoginSession session;
    private long lastCheckTs;
    private final int receiveRetryCount = 5;
    private volatile BlockingQueue<WeChatMessage> messages = new LinkedBlockingQueue<WeChatMessage>();
    private final Map<MsgType, List<Invoke>> mapping = new HashMap<MsgType, List<Invoke>>(8);

    public WeChatBot(Builder builder) {
        this.config = builder.config;
        this.botClient = builder.botClient;
        this.session = new LoginSession();
        this.init();
    }

    public WeChatBot(Config config) {
        this(new Builder().config(config));
    }

    public Config config() {
        return this.config;
    }

    public LoginSession session() {
        return this.session;
    }

    public BotClient client() {
        return this.botClient;
    }

    public WeChatApi api() {
        return this.api;
    }

    public void addMessages(List<WeChatMessage> messages) {
        try {
            if (null == messages || messages.size() == 0) {
                return;
            }
            for (WeChatMessage message : messages) {
                this.messages.put(message);
            }
        }
        catch (InterruptedException e) {
            log.error("\u5411\u961f\u5217\u6dfb\u52a0 Message \u51fa\u9519", (Throwable)e);
        }
    }

    public boolean hasMessage() {
        return this.messages.size() > 0;
    }

    public WeChatMessage nextMessage() {
        try {
            return this.messages.take();
        }
        catch (InterruptedException e) {
            log.error("\u4ece\u961f\u5217\u83b7\u53d6 Message \u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    private void init() {
        Method[] methods;
        for (Method method : methods = this.getClass().getMethods()) {
            MsgType[] msgTypes;
            Bind bind = method.getAnnotation(Bind.class);
            if (null == bind) continue;
            if (method.getParameterTypes().length != 1) {
                throw new WeChatException("\u65b9\u6cd5 " + method.getName() + " \u53c2\u6570\u4e2a\u6570\u4e0d\u5bf9\uff0c\u8bf7\u68c0\u67e5");
            }
            if (!method.getParameterTypes()[0].equals(WeChatMessage.class)) {
                throw new WeChatException("\u65b9\u6cd5 " + method.getName() + " \u53c2\u6570\u7c7b\u578b\u4e0d\u5bf9\uff0c\u8bf7\u68c0\u67e5");
            }
            for (MsgType msgType : msgTypes = bind.msgType()) {
                List<Invoke> invokes = this.mapping.get((Object)msgType);
                if (null == this.mapping.get((Object)msgType)) {
                    invokes = new ArrayList<Invoke>();
                }
                invokes.add(new Invoke(method, Arrays.asList(bind.accountType()), msgType));
                this.mapping.put(msgType, invokes);
            }
            log.info("\u7ed1\u5b9a\u6d88\u606f\u76d1\u542c\u51fd\u6570 [{}] => {}", (Object)method.getName(), (Object)msgTypes);
        }
    }

    public boolean sendMsgToFileHelper(String msg) {
        return this.api.sendText("filehelper", msg);
    }

    public boolean sendMsg(String name, String msg) {
        return this.api.sendText(name, msg);
    }

    public boolean sendMsgByName(String name, String msg) {
        Account account = this.api.getAccountByName(name);
        if (null == account) {
            log.warn("\u627e\u4e0d\u5230\u7528\u6237: {}", (Object)name);
            return false;
        }
        return this.api.sendText(account.getUserName(), msg);
    }

    public boolean sendImg(String name, String imgPath) {
        return this.api.sendImg(name, imgPath);
    }

    public boolean sendImgName(String name, String imgPath) {
        Account account = this.api.getAccountByName(name);
        if (null == account) {
            log.warn("\u627e\u4e0d\u5230\u7528\u6237: {}", (Object)name);
            return false;
        }
        return this.api.sendImg(account.getUserName(), imgPath);
    }

    public boolean sendFile(String name, String filePath) {
        return this.api.sendFile(name, filePath);
    }

    public boolean sendFileName(String name, String filePath) {
        Account account = this.api.getAccountByName(name);
        if (null == account) {
            log.warn("\u627e\u4e0d\u5230\u7528\u6237: {}", (Object)name);
            return false;
        }
        return this.api.sendFile(account.getUserName(), filePath);
    }

    public void start() {
        this.api = new WeChatApiImpl(this);
        log.info("wechat-bot: {}", (Object)"1.0.5");
        this.api.login(this.config.autoLogin());
        Thread msgHandle = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    if (WeChatBot.this.hasMessage()) {
                        WeChatMessage weChatMessage = WeChatBot.this.nextMessage();
                        WeChatBot.this.callBack((List)WeChatBot.this.mapping.get((Object)MsgType.ALL), weChatMessage);
                        WeChatBot.this.callBack((List)WeChatBot.this.mapping.get((Object)weChatMessage.getMsgType()), weChatMessage);
                        continue;
                    }
                    DateUtils.sleep(50L);
                }
            }
        });
        msgHandle.setName("message-handle");
        msgHandle.setDaemon(true);
        msgHandle.start();
        this.other();
    }

    protected void other() {
        while (true) {
            String text;
            Scanner scanner;
            if ((scanner = new Scanner(System.in)).hasNext() && ("quit".equals(text = scanner.next()) || "exit".equals(text))) break;
            DateUtils.sleep(100L);
        }
        this.api.logout();
    }

    private void callBack(List<Invoke> invokes, WeChatMessage message) {
        if (null != invokes && invokes.size() > 0 && null != message) {
            for (Invoke invoke : invokes) {
                invoke.call(this, message);
            }
        }
    }

    public void updateLastCheck() {
        this.lastCheckTs = System.currentTimeMillis();
        if (this.config().autoLogin()) {
            String file = this.config().assetsDir() + "/login.json";
            WeChatUtils.writeJson(file, HotReload.build(this.session()));
            if (log.isDebugEnabled()) {
                log.debug("\u5199\u5165\u672c\u5730\u767b\u5f55JSON");
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void setSession(LoginSession session) {
        this.session = session;
    }

    public long getLastCheckTs() {
        return this.lastCheckTs;
    }

    public int getReceiveRetryCount() {
        return this.receiveRetryCount;
    }

    public BlockingQueue<WeChatMessage> getMessages() {
        return this.messages;
    }

    public static final class Builder {
        private Config config = Config.me();
        private BotClient botClient = new BotClient(Builder.client(null));
        private OkHttpClient okHttpClient;

        public Builder okHttpClient(OkHttpClient client) {
            this.okHttpClient = client;
            return this;
        }

        public Builder config(Config config) {
            this.config = config;
            return this;
        }

        public WeChatBot build() {
            if (this.okHttpClient != null) {
                this.botClient = new BotClient(this.okHttpClient);
            }
            return new WeChatBot(this);
        }

        private static OkHttpClient client(Interceptor interceptor) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            OkHttpUtils.configureToIgnoreCertificate(builder);
            if (interceptor != null) {
                builder.addInterceptor(interceptor);
            }
            return builder.build();
        }
    }
}

