/*
 * Decompiled with CFR 0.152.
 */
package io.uouo.wechat;

import io.uouo.wechat.WeChatBot;
import io.uouo.wechat.api.annotation.Bind;
import io.uouo.wechat.api.constant.Config;
import io.uouo.wechat.api.enums.AccountType;
import io.uouo.wechat.api.enums.MsgType;
import io.uouo.wechat.api.model.WeChatMessage;
import io.uouo.wechat.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBot
extends WeChatBot {
    private static final Logger log = LoggerFactory.getLogger(MyBot.class);

    public MyBot(Config config) {
        super(config);
    }

    @Bind(msgType={MsgType.ALL}, accountType={AccountType.TYPE_GROUP})
    public void groupMessage(WeChatMessage message) {
        log.info("\u63a5\u6536\u5230\u7fa4 [{}] \u7684\u6d88\u606f: {}", (Object)message.getName(), (Object)message.getText());
        this.api().sendText(message.getFromUserName(), "\u81ea\u52a8\u56de\u590d: " + message.getText());
    }

    @Bind(msgType={MsgType.TEXT, MsgType.VIDEO, MsgType.IMAGE, MsgType.EMOTICONS}, accountType={AccountType.TYPE_FRIEND})
    public void friendMessage(WeChatMessage message) {
        if (StringUtils.isNotEmpty(message.getName())) {
            log.info("\u63a5\u6536\u5230\u597d\u53cb [{}] \u7684\u6d88\u606f: {}", (Object)message.getName(), (Object)message.getText());
            this.api().sendText(message.getFromUserName(), "\u81ea\u52a8\u56de\u590d: " + message.getText());
        }
    }

    @Bind(msgType={MsgType.ADD_FRIEND})
    public void addFriend(WeChatMessage message) {
        log.info("\u6536\u5230\u597d\u53cb\u9a8c\u8bc1\u6d88\u606f: {}", (Object)message.getText());
        if (message.getText().contains("java")) {
            this.api().verify(message.getRaw().getRecommend());
        }
    }

    public static void main(String[] args) {
        new MyBot(Config.me().autoLogin(true).showTerminal(true)).start();
    }
}

