/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab.model;

import io.ultreia.maven.gitlab.model.IssueModel;
import io.ultreia.maven.gitlab.model.MilestoneReleaseArtifactModel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.gitlab.api.models.GitlabMilestone;

public class MilestoneModel {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("YYYY-MM-dd");
    private final GitlabMilestone milestone;
    private final List<IssueModel> issues;
    private final List<MilestoneReleaseArtifactModel> artifacts;

    public MilestoneModel(GitlabMilestone milestone, Set<IssueModel> issues, List<MilestoneReleaseArtifactModel> artifacts) {
        this.milestone = milestone;
        this.issues = new ArrayList<IssueModel>(issues);
        this.artifacts = artifacts;
    }

    public boolean isWithIssue() {
        return !this.issues.isEmpty();
    }

    public boolean isWithNoIssue() {
        return this.issues.isEmpty();
    }

    public boolean isWithArtifact() {
        return !this.artifacts.isEmpty();
    }

    public List<MilestoneReleaseArtifactModel> getArtifacts() {
        return this.artifacts;
    }

    public List<IssueModel> getIssues() {
        return this.issues;
    }

    public int getId() {
        return this.milestone.getIid();
    }

    public String getTitle() {
        return this.milestone.getTitle();
    }

    public String getDescription() {
        return this.milestone.getDescription();
    }

    public String getDueDate() {
        return Optional.ofNullable(this.milestone.getDueDate()).map(SIMPLE_DATE_FORMAT::format).orElse("*In progress*");
    }

    public String getState() {
        return this.milestone.getState();
    }
}

