/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab.model;

import io.ultreia.maven.gitlab.GitlabCache;
import io.ultreia.maven.gitlab.GitlabMilestoneExt;
import io.ultreia.maven.gitlab.GitlabMojoSupport;
import io.ultreia.maven.gitlab.ProjectNotFoundException;
import io.ultreia.maven.gitlab.model.IssueModel;
import io.ultreia.maven.gitlab.model.MilestoneModel;
import io.ultreia.maven.gitlab.model.MilestoneReleaseArtifactModel;
import io.ultreia.maven.gitlab.model.ProjectModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.gitlab.api.models.GitlabIssue;
import org.gitlab.api.models.GitlabMilestone;
import org.gitlab.api.models.GitlabProject;

public class ProjectModelBuilder {
    private final GitlabCache gitlabCache;
    private final Log log;
    private String milestone;
    private String title;
    private String author;
    private String authorEmail;
    private List<String> trackers;
    private String organizationId;
    private String projectId;
    private String host;
    private boolean verbose;

    public static ProjectModelBuilder create(GitlabMojoSupport mojo) {
        return new ProjectModelBuilder(mojo.newCache(), mojo.getLog()).setHost(mojo.getHost()).setVerbose(mojo.isVerbose()).setOrganizationId(mojo.getOrganizationId()).setProjectId(mojo.getProjectId());
    }

    private ProjectModelBuilder(GitlabCache gitlabCache, Log log) {
        this.gitlabCache = gitlabCache;
        this.log = log;
    }

    public ProjectModelBuilder setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public ProjectModelBuilder setHost(String host) {
        this.host = host;
        return this;
    }

    public ProjectModelBuilder setMilestone(String milestone) {
        if (milestone != null && milestone.endsWith("-SNAPSHOT")) {
            milestone = StringUtils.removeEnd((String)milestone, (String)"-SNAPSHOT");
        }
        this.milestone = milestone;
        return this;
    }

    public ProjectModelBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public ProjectModelBuilder setAuthor(String author) {
        this.author = author;
        return this;
    }

    public ProjectModelBuilder setAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
        return this;
    }

    public ProjectModelBuilder setTrackers(List<String> trackers) {
        this.trackers = trackers;
        return this;
    }

    public ProjectModelBuilder setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    public ProjectModelBuilder setProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public ProjectModel build() throws IOException, ProjectNotFoundException {
        Optional<GitlabProject> gitlabProjectOptional;
        Objects.requireNonNull(this.gitlabCache);
        Objects.requireNonNull(this.host);
        Objects.requireNonNull(this.organizationId);
        Objects.requireNonNull(this.projectId);
        Objects.requireNonNull(this.title);
        Objects.requireNonNull(this.author);
        Objects.requireNonNull(this.authorEmail);
        Objects.requireNonNull(this.trackers);
        if (this.verbose) {
            this.log.info((CharSequence)"loading project...");
        }
        if (!(gitlabProjectOptional = this.gitlabCache.getProject()).isPresent()) {
            throw new ProjectNotFoundException();
        }
        String projectPath = this.organizationId + "/" + this.projectId;
        GitlabProject gitlabProject = gitlabProjectOptional.get();
        this.log.info((CharSequence)String.format("GitLab project (%s) id: %d", projectPath, gitlabProject.getId()));
        if (this.verbose) {
            this.log.info((CharSequence)"loading milestones...");
        }
        List<GitlabMilestoneExt> gitlabMilestones = this.gitlabCache.getMilestones();
        this.log.info((CharSequence)String.format("found %d milestone(s).", gitlabMilestones.size()));
        LinkedHashSet<MilestoneModel> milestoneModels = new LinkedHashSet<MilestoneModel>();
        for (GitlabMilestone gitlabMilestone : gitlabMilestones) {
            Set<MilestoneReleaseArtifactModel> milestoneArtifacts;
            boolean onCurrentMilestone;
            String gitlabMilestoneTitle = gitlabMilestone.getTitle();
            boolean bl = onCurrentMilestone = this.milestone != null && this.milestone.equals(gitlabMilestoneTitle);
            if (!"closed".equals(gitlabMilestone.getState()) && !onCurrentMilestone) {
                this.log.info((CharSequence)String.format("Skip open milestone %s.", gitlabMilestoneTitle));
                continue;
            }
            this.log.info((CharSequence)String.format("GitLab milestone (%s) id: %d", gitlabMilestoneTitle, gitlabMilestone.getIid()));
            LinkedList<MilestoneReleaseArtifactModel> milestoneReleaseArtifactModels = new LinkedList<MilestoneReleaseArtifactModel>();
            if (this.verbose) {
                this.log.info((CharSequence)"loading artifacts...");
            }
            if ((milestoneArtifacts = this.gitlabCache.getMilestoneArtifacts(gitlabMilestone)) != null && !milestoneArtifacts.isEmpty()) {
                milestoneReleaseArtifactModels.addAll(milestoneArtifacts);
            }
            if (this.verbose) {
                this.log.info((CharSequence)String.format("found %d artifact(s).", milestoneReleaseArtifactModels.size()));
            }
            if (this.verbose) {
                this.log.info((CharSequence)"loading issues...");
            }
            Set<GitlabIssue> gitlabIssues = this.gitlabCache.getMilestoneIssues(gitlabMilestone);
            if (this.verbose) {
                this.log.info((CharSequence)String.format("found %d issue(s).", gitlabIssues.size()));
            }
            LinkedHashSet<IssueModel> issues = new LinkedHashSet<IssueModel>();
            for (String tracker : this.trackers) {
                List issueModels = gitlabIssues.stream().filter(i -> Arrays.asList(i.getLabels()).contains(tracker)).map(i -> new IssueModel((GitlabIssue)i, tracker, this.trackers)).sorted(Comparator.comparing(IssueModel::getId)).collect(Collectors.toList());
                issues.addAll(issueModels);
            }
            milestoneModels.add(new MilestoneModel(gitlabMilestone, issues, milestoneReleaseArtifactModels));
        }
        return new ProjectModel(this.host + "/" + projectPath, this.title, this.author, this.authorEmail, milestoneModels, this.trackers);
    }
}

