/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import io.ultreia.java4all.lang.Strings;
import io.ultreia.maven.gitlab.GitlabAPIExt;
import io.ultreia.maven.gitlab.GitlabCache;
import io.ultreia.maven.gitlab.MilestoneNotFoundException;
import io.ultreia.maven.gitlab.ProjectNotFoundException;
import io.ultreia.maven.gitlab.model.MilestoneReleaseArtifactModel;
import io.ultreia.maven.gitlab.model.ReleaseArtifactModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.gitlab.api.GitlabAPI;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public abstract class GitlabMojoSupport
extends AbstractMojo {
    @Parameter(property="gitlab.host", required=true)
    private String host;
    @Parameter(property="gitlab.organizationId", required=true)
    private String organizationId;
    @Parameter(property="gitlab.projectId", required=true)
    private String projectId;
    @Parameter(property="gitlab.serverId", required=true)
    private String serverId;
    @Parameter(property="gitlab.cachePath", required=true, defaultValue="${project.build.directory}/gitlab-cache")
    private File cachePath;
    @Parameter(property="gitlab.cacheExtraPath", required=true, defaultValue="src/gitlab")
    private File cacheExtraPath;
    @Parameter(property="gitlab.quiet", defaultValue="false")
    private boolean quiet;
    @Parameter(property="gitlab.runOnlyAtExecutionRoot", defaultValue="true")
    private boolean runOnlyAtExecutionRoot;
    @Parameter(property="basedir", required=true)
    private String basedir;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession mavenSession;
    @Component(hint="gitlab-maven-plugin")
    private SecDispatcher sec;

    abstract boolean isSkip();

    abstract void execute(GitlabAPIExt var1) throws IOException, MilestoneNotFoundException, ProjectNotFoundException;

    public boolean isVerbose() {
        return !this.quiet;
    }

    String getGitlabProjectPath() {
        return this.organizationId + "/" + this.projectId;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skip goal.");
            return;
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Connect to " + this.host));
        }
        GitlabAPIExt api = this.initApi();
        try {
            this.execute(api);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error with api", (Exception)e);
        }
        catch (MilestoneNotFoundException e) {
            throw new MojoExecutionException("Could not find milestone", (Exception)e);
        }
        catch (ProjectNotFoundException e) {
            throw new MojoExecutionException("Could not find project", (Exception)e);
        }
    }

    public GitlabCache newCache() {
        GitlabCache cache = new GitlabCache(this.cachePath.toPath(), this.cacheExtraPath.toPath());
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)String.format("Use cache at: %s", this.cachePath));
        }
        return cache;
    }

    public String getHost() {
        return this.host;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    boolean shouldSkip() {
        if (this.runOnlyAtExecutionRoot && !this.isThisTheExecutionRoot()) {
            this.getLog().info((CharSequence)"Skipping the Changes Report in this project because it's not the Execution Root");
            return true;
        }
        return false;
    }

    Mustache getMustache(String templateName) {
        DefaultMustacheFactory mf = new DefaultMustacheFactory("templates");
        return mf.compile(templateName);
    }

    protected String removeSnapShot(String milestone) {
        if (milestone.endsWith("-SNAPSHOT")) {
            milestone = Strings.removeEnd((String)milestone, (String)"-SNAPSHOT");
        }
        return milestone;
    }

    protected Set<MilestoneReleaseArtifactModel> loadArtifacts(List<ReleaseArtifactModel> releaseArtifacts, String version) {
        LinkedHashSet<MilestoneReleaseArtifactModel> milestoneArtifacts = new LinkedHashSet<MilestoneReleaseArtifactModel>();
        String host = "https://repo1.maven.org/maven2";
        for (ReleaseArtifactModel releaseArtifact : releaseArtifacts) {
            URL url = releaseArtifact.getUrl(host, version, false);
            try {
                InputStream urlConnection = url.openStream();
                this.getLog().info((CharSequence)String.format("Add release artifact: %s", url));
                urlConnection.close();
                milestoneArtifacts.add(new MilestoneReleaseArtifactModel(releaseArtifact.getName(), url));
            }
            catch (Exception e) {
                this.getLog().debug((CharSequence)("Could not get " + url));
            }
        }
        return milestoneArtifacts;
    }

    private GitlabAPIExt initApi() throws MojoExecutionException {
        Server server = this.settings.getServer(this.serverId);
        String encryptedPrivateKey = server.getPrivateKey();
        try {
            String privateKey = this.sec.decrypt(encryptedPrivateKey);
            return new GitlabAPIExt(GitlabAPI.connect((String)this.host, (String)privateKey));
        }
        catch (SecDispatcherException e) {
            throw new MojoExecutionException("Could not decrypt privateKey", (Exception)((Object)e));
        }
    }

    private boolean isThisTheExecutionRoot() {
        this.getLog().debug((CharSequence)("Root Folder:" + this.mavenSession.getExecutionRootDirectory()));
        this.getLog().debug((CharSequence)("Current Folder:" + this.basedir));
        boolean result = this.mavenSession.getExecutionRootDirectory().equalsIgnoreCase(this.basedir);
        if (result) {
            this.getLog().debug((CharSequence)"This is the execution root.");
        } else {
            this.getLog().debug((CharSequence)"This is NOT the execution root.");
        }
        return result;
    }
}

