/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.ultreia.java4all.util.Version;
import io.ultreia.maven.gitlab.GitlabMilestoneExt;
import io.ultreia.maven.gitlab.model.MilestoneReleaseArtifactModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.gitlab.api.models.GitlabIssue;
import org.gitlab.api.models.GitlabMilestone;
import org.gitlab.api.models.GitlabProject;

public class GitlabCache {
    private final Path cachePath;
    private final Path cacheExtraPath;
    private final Gson gson;

    GitlabCache(Path cachePath, Path cacheExtraPath) {
        this.cachePath = cachePath;
        this.cacheExtraPath = cacheExtraPath;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    public Optional<GitlabProject> getProject() throws IOException {
        Path projectPath = this.getProjectPath();
        if (Files.exists(projectPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(projectPath);){
                GitlabProject gitlabMilestone = (GitlabProject)this.gson.fromJson((Reader)reader, GitlabProject.class);
                Optional<GitlabProject> optional = Optional.of(gitlabMilestone);
                return optional;
            }
        }
        return Optional.empty();
    }

    public void setProject(GitlabProject gitlabProject) throws IOException {
        Path projectPath = this.getProjectPath();
        Files.createDirectories(projectPath.getParent(), new FileAttribute[0]);
        try (BufferedWriter reader = Files.newBufferedWriter(projectPath, new OpenOption[0]);){
            this.gson.toJson((Object)gitlabProject, (Appendable)reader);
        }
    }

    public List<GitlabMilestoneExt> getMilestones() throws IOException {
        Path milestonesPath = this.cachePath.resolve("milestones");
        Set<Path> paths = this.getPaths(milestonesPath);
        LinkedList<GitlabMilestoneExt> result = new LinkedList<GitlabMilestoneExt>();
        for (Path path : paths) {
            if (path.toFile().getName().endsWith("-issues.json") || path.toFile().getName().endsWith("-artifacts.json")) continue;
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                GitlabMilestoneExt gitlabMilestone = (GitlabMilestoneExt)this.gson.fromJson((Reader)reader, GitlabMilestoneExt.class);
                result.add(gitlabMilestone);
            }
            finally {
                if (reader == null) continue;
                ((Reader)reader).close();
            }
        }
        result.sort(Comparator.comparing(m -> Version.valueOf((String)m.getTitle())));
        return result;
    }

    public Optional<GitlabMilestoneExt> getMilestone(String gitlabMilestone) throws IOException {
        Path milestonePath = this.getMilestonePath(gitlabMilestone);
        if (Files.exists(milestonePath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(milestonePath);){
                Optional<GitlabMilestoneExt> optional = Optional.of((GitlabMilestoneExt)this.gson.fromJson((Reader)reader, GitlabMilestoneExt.class));
                return optional;
            }
        }
        return Optional.empty();
    }

    public Optional<GitlabMilestoneExt> getMilestone(GitlabMilestone gitlabMilestone) throws IOException {
        Path milestonePath = this.getMilestonePath(gitlabMilestone);
        if (Files.exists(milestonePath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(milestonePath);){
                Optional<GitlabMilestoneExt> optional = Optional.of((GitlabMilestoneExt)this.gson.fromJson((Reader)reader, GitlabMilestoneExt.class));
                return optional;
            }
        }
        return Optional.empty();
    }

    public void setMilestone(GitlabMilestone gitlabMilestone) throws IOException {
        Path milestonePath = this.getMilestonePath(gitlabMilestone);
        Files.createDirectories(milestonePath.getParent(), new FileAttribute[0]);
        try (BufferedWriter reader = Files.newBufferedWriter(milestonePath, new OpenOption[0]);){
            this.gson.toJson((Object)gitlabMilestone, (Appendable)reader);
        }
    }

    public Set<GitlabIssue> getMilestoneIssues(GitlabMilestone gitlabMilestone) throws IOException {
        Path issuesPath = this.getIssuesPath(gitlabMilestone);
        try (BufferedReader reader = Files.newBufferedReader(issuesPath);){
            Type typeOfT = new TypeToken<Set<GitlabIssue>>(){}.getType();
            Set set = (Set)this.gson.fromJson((Reader)reader, typeOfT);
            return set;
        }
    }

    public void setMilestoneIssues(GitlabMilestone gitlabMilestone, Iterable<GitlabIssue> gitlabIssues) throws IOException {
        Path issuesPath = this.getIssuesPath(gitlabMilestone);
        Files.createDirectories(issuesPath.getParent(), new FileAttribute[0]);
        try (BufferedWriter reader = Files.newBufferedWriter(issuesPath, new OpenOption[0]);){
            this.gson.toJson(gitlabIssues, (Appendable)reader);
        }
    }

    public Set<MilestoneReleaseArtifactModel> getMilestoneArtifacts(GitlabMilestone gitlabMilestone) throws IOException {
        LinkedHashSet<MilestoneReleaseArtifactModel> result = new LinkedHashSet<MilestoneReleaseArtifactModel>();
        Path artifactsPath = this.getArtifactsPath(gitlabMilestone);
        if (Files.exists(artifactsPath, new LinkOption[0])) {
            result.addAll(this.getMilestoneArtifacts(artifactsPath));
        }
        if (Files.exists(artifactsPath = this.getArtifactsExtraPath(gitlabMilestone), new LinkOption[0])) {
            result.addAll(this.getMilestoneArtifacts(artifactsPath));
        }
        return result.isEmpty() ? null : result;
    }

    Set<MilestoneReleaseArtifactModel> getMilestoneArtifacts(Path artifactsPath) throws IOException {
        if (Files.notExists(artifactsPath, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(artifactsPath);){
            Type typeOfT = new TypeToken<Set<MilestoneReleaseArtifactModel>>(){}.getType();
            Set set = (Set)this.gson.fromJson((Reader)reader, typeOfT);
            return set;
        }
    }

    public void setMilestoneArtifacts(GitlabMilestone gitlabMilestone, Iterable<MilestoneReleaseArtifactModel> gitlabArtifacts) throws IOException {
        Path artifactsPath = this.getArtifactsPath(gitlabMilestone);
        Files.createDirectories(artifactsPath.getParent(), new FileAttribute[0]);
        try (BufferedWriter reader = Files.newBufferedWriter(artifactsPath, new OpenOption[0]);){
            this.gson.toJson(gitlabArtifacts, (Appendable)reader);
        }
    }

    public void setMilestoneExtraArtifacts(GitlabMilestone gitlabMilestone, Iterable<MilestoneReleaseArtifactModel> gitlabArtifacts) throws IOException {
        Path artifactsPath = this.getArtifactsExtraPath(gitlabMilestone);
        Files.createDirectories(artifactsPath.getParent(), new FileAttribute[0]);
        try (BufferedWriter reader = Files.newBufferedWriter(artifactsPath, new OpenOption[0]);){
            this.gson.toJson(gitlabArtifacts, (Appendable)reader);
        }
    }

    private Path getProjectPath() {
        return this.cachePath.resolve("project.json");
    }

    private Path getMilestonePath(String gitlabMilestone) {
        return this.cachePath.resolve("milestones").resolve(gitlabMilestone + ".json");
    }

    private Path getMilestonePath(GitlabMilestone gitlabMilestone) {
        return this.cachePath.resolve("milestones").resolve(gitlabMilestone.getTitle() + ".json");
    }

    private Path getIssuesPath(GitlabMilestone gitlabMilestone) {
        return this.cachePath.resolve("milestones").resolve(gitlabMilestone.getTitle() + "-issues.json");
    }

    private Path getArtifactsPath(GitlabMilestone gitlabMilestone) {
        return this.cachePath.resolve("milestones").resolve(gitlabMilestone.getTitle() + "-artifacts.json");
    }

    private Path getArtifactsExtraPath(GitlabMilestone gitlabMilestone) {
        return this.cacheExtraPath.resolve("milestones").resolve(gitlabMilestone.getTitle() + "-artifacts.json");
    }

    private Set<Path> getPaths(Path path) throws IOException {
        final LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (file.toFile().getName().endsWith(".json")) {
                    paths.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return paths;
    }
}

