/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab;

import io.ultreia.maven.gitlab.GitlabAPIExt;
import io.ultreia.maven.gitlab.GitlabCache;
import io.ultreia.maven.gitlab.GitlabMilestoneExt;
import io.ultreia.maven.gitlab.GitlabMojoSupport;
import io.ultreia.maven.gitlab.MilestoneNotFoundException;
import io.ultreia.maven.gitlab.model.MilestoneReleaseArtifactModel;
import io.ultreia.maven.gitlab.model.ReleaseArtifactModel;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.gitlab.api.models.GitlabIssue;
import org.gitlab.api.models.GitlabProject;

@Mojo(name="download-milestones", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class DownloadMilestonesMojo
extends GitlabMojoSupport {
    @Parameter(property="gitlab.milestone", required=true, defaultValue="${project.version}")
    private String milestone;
    @Parameter(property="gitlab.fromMilestone")
    private String fromMilestone;
    @Parameter(property="gitlab.force")
    private boolean force;
    @Parameter(property="gitlab.forceArtifacts")
    private boolean forceArtifacts;
    @Parameter(property="gitlab.skip")
    private boolean skip;
    @Parameter(property="gitlab.forceForCurrentMilestone", defaultValue="true")
    private boolean forceForCurrentMilestone;
    @Parameter
    private List<ReleaseArtifactModel> releaseArtifacts;

    @Override
    boolean isSkip() {
        return this.skip || this.shouldSkip();
    }

    @Override
    protected void execute(GitlabAPIExt api) throws IOException, MilestoneNotFoundException {
        this.milestone = this.removeSnapShot(this.milestone);
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)"loading project...");
        }
        String projectPath = this.getGitlabProjectPath();
        GitlabProject gitlabProject = api.getProject((Serializable)((Object)projectPath));
        GitlabCache gitlabCache = this.newCache();
        gitlabCache.setProject(gitlabProject);
        this.getLog().info((CharSequence)String.format("GitLab project (%s) id: %d", projectPath, gitlabProject.getId()));
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)"loading milestones...");
        }
        List<GitlabMilestoneExt> gitlabMilestones = api.getMilestones(gitlabProject, this.fromMilestone);
        int gitlabMilestonesCount = gitlabMilestones.size();
        this.getLog().info((CharSequence)String.format("found %d milestone(s).", gitlabMilestonesCount));
        Optional<GitlabMilestoneExt> optionalMilestone = gitlabMilestones.stream().filter(m -> this.milestone.equals(m.getTitle())).findFirst();
        int index = 0;
        for (GitlabMilestoneExt gitlabMilestone : gitlabMilestones) {
            Optional<GitlabMilestoneExt> milestoneOptional;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)String.format("[%1$-4d/%2$-4d] Process GitLab milestone (%3$s) id: %4$d", ++index, gitlabMilestonesCount, gitlabMilestone.getTitle(), gitlabMilestone.getId()));
            }
            if ((milestoneOptional = gitlabCache.getMilestone(gitlabMilestone)).isPresent()) {
                if (this.force) {
                    this.storeMilestone(api, gitlabProject, gitlabCache, gitlabMilestone);
                    continue;
                }
                if (this.forceForCurrentMilestone && optionalMilestone.isPresent() && gitlabMilestone.getId() == optionalMilestone.get().getId()) {
                    this.storeMilestone(api, gitlabProject, gitlabCache, gitlabMilestone);
                    continue;
                }
                if (this.storeMilestoneArtifacts(gitlabCache, gitlabMilestone) || !this.isVerbose()) continue;
                this.getLog().info((CharSequence)"Skip existing milestone");
                continue;
            }
            this.storeMilestone(api, gitlabProject, gitlabCache, gitlabMilestone);
        }
    }

    private void storeMilestone(GitlabAPIExt api, GitlabProject gitlabProject, GitlabCache gitlabCache, GitlabMilestoneExt gitlabMilestone) throws IOException {
        gitlabCache.setMilestone(gitlabMilestone);
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)"loading issues...");
        }
        List<GitlabIssue> issues = api.getMilestoneIssues(gitlabProject, gitlabMilestone);
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)String.format("found %d issue(s).", issues.size()));
        }
        gitlabCache.setMilestoneIssues(gitlabMilestone, issues);
        this.storeMilestoneArtifacts(gitlabCache, gitlabMilestone);
    }

    private boolean storeMilestoneArtifacts(GitlabCache gitlabCache, GitlabMilestoneExt gitlabMilestone) throws IOException {
        Set<MilestoneReleaseArtifactModel> milestoneArtifacts;
        if (this.releaseArtifacts == null) {
            return false;
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)"loading artifacts...");
        }
        if ((milestoneArtifacts = gitlabCache.getMilestoneArtifacts(gitlabMilestone)) != null && !milestoneArtifacts.isEmpty() && !this.forceArtifacts) {
            return false;
        }
        milestoneArtifacts = this.loadArtifacts(this.releaseArtifacts, gitlabMilestone.getTitle());
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)String.format("found %d artifact(s).", milestoneArtifacts.size()));
        }
        gitlabCache.setMilestoneArtifacts(gitlabMilestone, milestoneArtifacts);
        return true;
    }
}

