/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab;

import io.ultreia.java4all.util.Version;
import io.ultreia.maven.gitlab.GitlabAPIExt;
import io.ultreia.maven.gitlab.GitlabCache;
import io.ultreia.maven.gitlab.GitlabMilestoneExt;
import io.ultreia.maven.gitlab.GitlabMojoSupport;
import io.ultreia.maven.gitlab.MilestoneNotFoundException;
import io.ultreia.maven.gitlab.model.MilestoneReleaseArtifactModel;
import io.ultreia.maven.gitlab.model.ReleaseArtifactModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.gitlab.api.models.GitlabProject;

@Mojo(name="download-extra-artifacts", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
@Execute(goal="download-milestones")
public class DownloadExtraArtifactsMojo
extends GitlabMojoSupport {
    @Parameter(property="gitlab.milestone", required=true, defaultValue="${project.version}")
    private String milestone;
    @Parameter(required=true)
    private List<ReleaseArtifactModel> releaseArtifacts;
    @Parameter(property="gitlab.versions")
    private String versions;
    @Parameter(property="gitlab.skip")
    private boolean skip;

    @Override
    boolean isSkip() {
        return this.skip || this.shouldSkip();
    }

    @Override
    protected void execute(GitlabAPIExt api) throws IOException, MilestoneNotFoundException {
        this.milestone = this.removeSnapShot(this.milestone);
        String projectPath = this.getGitlabProjectPath();
        GitlabCache gitlabCache = this.newCache();
        GitlabProject gitlabProject = gitlabCache.getProject().orElseThrow(RuntimeException::new);
        this.getLog().info((CharSequence)String.format("GitLab project (%s) id: %d", projectPath, gitlabProject.getId()));
        GitlabMilestoneExt milestone = gitlabCache.getMilestone(this.milestone).orElseThrow(RuntimeException::new);
        this.getLog().info((CharSequence)String.format("GitLab milestone (%s) id: %d", milestone.getTitle(), milestone.getId()));
        List versionsList = Arrays.stream(this.versions.split("\\s*,\\s*")).map(Version::valueOf).sorted().collect(Collectors.toList());
        Collections.reverse(versionsList);
        LinkedHashSet<MilestoneReleaseArtifactModel> milestoneArtifacts = new LinkedHashSet<MilestoneReleaseArtifactModel>();
        for (Version version : versionsList) {
            Set<MilestoneReleaseArtifactModel> artifactsForVersion = this.loadArtifacts(this.releaseArtifacts, version.getVersion());
            if (artifactsForVersion == null) continue;
            milestoneArtifacts.addAll(artifactsForVersion);
        }
        this.getLog().info((CharSequence)String.format("found %d artifact(s).", milestoneArtifacts.size()));
        gitlabCache.setMilestoneExtraArtifacts(milestone, milestoneArtifacts);
    }
}

