/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import io.ultreia.maven.gitlab.GitlabAPIExt;
import io.ultreia.maven.gitlab.GitlabCache;
import io.ultreia.maven.gitlab.GitlabMilestoneExt;
import io.ultreia.maven.gitlab.GitlabMojoSupport;
import io.ultreia.maven.gitlab.MilestoneNotFoundException;
import io.ultreia.maven.gitlab.ProjectNotFoundException;
import io.ultreia.maven.gitlab.model.GitlabIssueTime;
import io.ultreia.maven.gitlab.model.IssueModel;
import io.ultreia.maven.gitlab.model.MilestoneModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.gitlab.api.models.GitlabIssue;
import org.gitlab.api.models.GitlabProject;

@Mojo(name="compute-milestone-estimate-time", defaultPhase=LifecyclePhase.INITIALIZE)
public class ComputeMilestoneEstimateTimeMojo
extends GitlabMojoSupport {
    @Parameter(property="gitlab.milestone", required=true, defaultValue="${project.version}")
    private String milestone;
    @Parameter(property="gitlab.fromMilestone")
    private String fromMilestone;
    @Parameter(property="gitlab.trackers", required=true)
    private String trackers;
    @Parameter(property="gitlab.output", required=true, defaultValue="${project.build.directory}/milestone-estimate-time.md")
    private File output;
    @Parameter(property="gitlab.template", required=true, defaultValue="classpath://compute-estimate-time.md.mustache")
    private String template;
    @Parameter(property="gitlab.hoursByDay", required=true, defaultValue="6")
    private int hoursByDay;
    @Parameter(property="gitlab.managementRatio", required=true, defaultValue="0.25")
    private float managementRatio;
    @Parameter(property="gitlab.skip")
    private boolean skip;

    @Override
    boolean isSkip() {
        return this.skip || this.shouldSkip();
    }

    @Override
    void execute(GitlabAPIExt api) throws IOException, MilestoneNotFoundException, ProjectNotFoundException {
        Mustache mustache;
        this.milestone = this.removeSnapShot(this.milestone);
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)"loading project...");
        }
        String projectPath = this.getGitlabProjectPath();
        GitlabProject gitlabProject = api.getProject((Serializable)((Object)projectPath));
        GitlabCache gitlabCache = this.newCache();
        gitlabCache.setProject(gitlabProject);
        this.getLog().info((CharSequence)String.format("GitLab project (%s) id: %d", projectPath, gitlabProject.getId()));
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)"loading milestones...");
        }
        List<GitlabMilestoneExt> gitlabMilestones = api.getMilestones(gitlabProject, this.fromMilestone);
        this.getLog().info((CharSequence)String.format("found %d milestone(s).", gitlabMilestones.size()));
        Optional<GitlabMilestoneExt> optionalMilestone = gitlabMilestones.stream().filter(m -> this.milestone.equals(m.getTitle())).findFirst();
        if (!optionalMilestone.isPresent()) {
            throw new MilestoneNotFoundException(this.milestone);
        }
        GitlabMilestoneExt gitlabMilestone = optionalMilestone.get();
        this.getLog().info((CharSequence)String.format("found milestone %s", gitlabMilestone.getTitle()));
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)"loading issues...");
        }
        List<GitlabIssue> gitlabIssues = api.getMilestoneIssues(gitlabProject, gitlabMilestone);
        this.getLog().info((CharSequence)String.format("found %d issue(s).", gitlabIssues.size()));
        if (this.template.startsWith("classpath://")) {
            String file = this.template.substring("classpath://".length());
            mustache = this.getMustache(file);
        } else {
            DefaultMustacheFactory mf = new DefaultMustacheFactory();
            try (BufferedReader bufferedReader = Files.newBufferedReader(Paths.get(this.template, new String[0]));){
                mustache = mf.compile((Reader)bufferedReader, "export-milestone");
            }
        }
        List<String> trackersList = Arrays.asList(this.trackers.split("\\s*,\\s*"));
        LinkedHashSet<IssueModel> issues = new LinkedHashSet<IssueModel>();
        GitlabIssueTime issuesTotalTime = new GitlabIssueTime();
        LinkedHashMap<String, GitlabIssueTime> totalByTrackers = new LinkedHashMap<String, GitlabIssueTime>();
        for (String tracker : trackersList) {
            LinkedList<IssueModel> issueModels = new LinkedList<IssueModel>();
            GitlabIssueTime trackerTotalTime = new GitlabIssueTime();
            gitlabIssues.stream().filter(i -> Arrays.asList(i.getLabels()).contains(tracker)).forEach(i -> {
                try {
                    GitlabIssueTime issueTime = api.getIssueTime(gitlabProject, i.getId());
                    if (issueTime.getTimeEstimate() > 0) {
                        trackerTotalTime.add(issueTime, this.hoursByDay);
                        IssueModel issueModel = new IssueModel((GitlabIssue)i, issueTime, tracker, trackersList);
                        issueModels.add(issueModel);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Can't load times for issue: " + i.getTitle(), e);
                }
            });
            issueModels.sort(Comparator.comparing(IssueModel::getId));
            issues.addAll(issueModels);
            if (issueModels.isEmpty()) continue;
            trackerTotalTime.recomputeHumanValues();
            totalByTrackers.put(tracker, trackerTotalTime);
            issuesTotalTime.addEstimateTime(trackerTotalTime.getTimeEstimate());
        }
        issuesTotalTime.recomputeHumanValues();
        totalByTrackers.put("Issues total", issuesTotalTime);
        GitlabIssueTime projectManagmentTime = new GitlabIssueTime();
        int timeEstimate = issuesTotalTime.getTimeEstimate();
        float pm = (float)timeEstimate * this.managementRatio;
        projectManagmentTime.addEstimateTime((int)pm);
        projectManagmentTime.recomputeHumanValues();
        totalByTrackers.put("Project managment", projectManagmentTime);
        GitlabIssueTime totalTime = new GitlabIssueTime();
        totalTime.addEstimateTime(issuesTotalTime.getTimeEstimate());
        totalTime.addEstimateTime(projectManagmentTime.getTimeEstimate());
        totalTime.recomputeHumanValues();
        totalByTrackers.put("Total  ", totalTime);
        ExportModel exportModel = new ExportModel(new MilestoneModel(gitlabMilestone, issues, null), totalByTrackers);
        try (BufferedWriter writer = Files.newBufferedWriter(this.output.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            mustache.execute((Writer)writer, (Object)exportModel).flush();
        }
        this.getLog().info((CharSequence)String.format("Milestone issues exported to to %s", this.output));
    }

    class ExportModel {
        private final MilestoneModel milestoneModel;
        private Map<String, GitlabIssueTime> totalTimeByTrackers;

        ExportModel(MilestoneModel milestoneModel, Map<String, GitlabIssueTime> totalTimeByTrackers) {
            this.milestoneModel = milestoneModel;
            this.totalTimeByTrackers = totalTimeByTrackers;
        }

        public MilestoneModel getMilestoneModel() {
            return this.milestoneModel;
        }

        public Set<Map.Entry<String, GitlabIssueTime>> getTotalTimeByTrackers() {
            return this.totalTimeByTrackers.entrySet();
        }

        public List<IssueModel> getIssues() {
            return this.milestoneModel.getIssues();
        }
    }
}

