/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab;

import io.ultreia.maven.gitlab.GitlabAPIExt;
import io.ultreia.maven.gitlab.GitlabCache;
import io.ultreia.maven.gitlab.GitlabMilestoneExt;
import io.ultreia.maven.gitlab.GitlabMojoSupport;
import io.ultreia.maven.gitlab.MilestoneNotFoundException;
import io.ultreia.maven.gitlab.ProjectNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.gitlab.api.models.GitlabProject;

@Mojo(name="close-milestone", defaultPhase=LifecyclePhase.INITIALIZE)
public class CloseMilestoneMojo
extends GitlabMojoSupport {
    @Parameter(property="gitlab.milestone", required=true, defaultValue="${project.version}")
    private String milestone;
    @Parameter(property="gitlab.fromMilestone")
    private String fromMilestone;
    @Parameter(property="gitlab.addDueDate", defaultValue="true")
    private boolean addDueDate;
    @Parameter(property="gitlab.forceAddDueDate", defaultValue="true")
    private boolean forceAddDueDate;
    @Parameter(property="gitlab.skip")
    private boolean skip;

    @Override
    boolean isSkip() {
        return this.skip || this.shouldSkip();
    }

    @Override
    void execute(GitlabAPIExt api) throws IOException, MilestoneNotFoundException, ProjectNotFoundException {
        this.milestone = this.removeSnapShot(this.milestone);
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)"loading project...");
        }
        String projectPath = this.getGitlabProjectPath();
        GitlabProject gitlabProject = api.getProject((Serializable)((Object)projectPath));
        GitlabCache gitlabCache = this.newCache();
        gitlabCache.setProject(gitlabProject);
        this.getLog().info((CharSequence)String.format("GitLab project (%s) id: %d", projectPath, gitlabProject.getId()));
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)"loading milestones...");
        }
        List<GitlabMilestoneExt> gitlabMilestones = api.getMilestones(gitlabProject, this.fromMilestone);
        this.getLog().info((CharSequence)String.format("found %d milestone(s).", gitlabMilestones.size()));
        Optional<GitlabMilestoneExt> optionalMilestone = gitlabMilestones.stream().filter(m -> this.milestone.equals(m.getTitle())).findFirst();
        if (!optionalMilestone.isPresent()) {
            throw new MilestoneNotFoundException(this.milestone);
        }
        GitlabMilestoneExt milestone = optionalMilestone.get();
        this.getLog().info((CharSequence)String.format("Closing milestone %s.", milestone.getTitle()));
        if (this.addDueDate && (this.forceAddDueDate || milestone.getDueDate() == null)) {
            milestone.setDueDate(new Date());
            if (milestone.getStartDate() != null && DateUtils.isSameDay((Date)milestone.getStartDate(), (Date)milestone.getDueDate())) {
                milestone.setStartDate(DateUtils.addDays((Date)milestone.getStartDate(), (int)-1));
            }
        }
        api.closeMilestone(milestone);
    }
}

