/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab.model;

import io.ultreia.maven.gitlab.model.IssueModel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.gitlab.api.models.GitlabMilestone;

public class MilestoneModel {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("YYYY-MM-dd");
    private final GitlabMilestone milestone;
    private final List<IssueModel> issues;

    public MilestoneModel(GitlabMilestone milestone, Set<IssueModel> issues) {
        this.milestone = milestone;
        this.issues = new ArrayList<IssueModel>(issues);
        this.issues.sort(Comparator.comparing(IssueModel::getId));
    }

    public boolean isWithAdd() {
        return !this.getAddIssues().isEmpty();
    }

    public boolean isWithFix() {
        return !this.getFixIssues().isEmpty();
    }

    public boolean isWithTask() {
        return !this.getTaskIssues().isEmpty();
    }

    public List<IssueModel> getAddIssues() {
        return this.issues.stream().filter(i -> i.getIssueType().equals("add")).collect(Collectors.toList());
    }

    public List<IssueModel> getFixIssues() {
        return this.issues.stream().filter(i -> i.getIssueType().equals("fix")).collect(Collectors.toList());
    }

    public List<IssueModel> getTaskIssues() {
        return this.issues.stream().filter(i -> i.getIssueType().equals("task")).collect(Collectors.toList());
    }

    public List<IssueModel> getIssues() {
        return this.issues;
    }

    public int getId() {
        return this.milestone.getIid();
    }

    public String getTitle() {
        return this.milestone.getTitle();
    }

    public String getDescription() {
        return this.milestone.getDescription();
    }

    public String getDueDate() {
        return Optional.ofNullable(this.milestone.getDueDate()).map(SIMPLE_DATE_FORMAT::format).orElse("");
    }

    public String getState() {
        return this.milestone.getState();
    }
}

