/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab.model;

import java.util.Map;
import org.gitlab.api.models.GitlabIssue;
import org.gitlab.api.models.GitlabUser;

public class IssueModel {
    private final GitlabIssue issue;
    private final String type;

    public IssueModel(GitlabIssue issue, Map<String, String> issueTypeMap) {
        this.issue = issue;
        String type = "unknown";
        for (String label : issue.getLabels()) {
            if (!issueTypeMap.containsKey(label)) continue;
            type = issueTypeMap.get(label);
        }
        this.type = type;
    }

    public String getIssueType() {
        return this.type;
    }

    public int getId() {
        return this.issue.getIid();
    }

    public String getTitle() {
        return this.issue.getTitle();
    }

    public GitlabUser getAssignee() {
        return this.issue.getAssignee();
    }

    public GitlabUser getAuthor() {
        return this.issue.getAuthor();
    }
}

