/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import io.ultreia.maven.gitlab.GitlabAPIExt;
import io.ultreia.maven.gitlab.GitlabCache;
import io.ultreia.maven.gitlab.MilestoneNotFoundException;
import io.ultreia.maven.gitlab.ProjectNotFoundException;
import io.ultreia.maven.gitlab.model.IssueModel;
import io.ultreia.maven.gitlab.model.MilestoneModel;
import io.ultreia.maven.gitlab.model.ProjectModel;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.models.GitlabIssue;
import org.gitlab.api.models.GitlabMilestone;
import org.gitlab.api.models.GitlabProject;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public abstract class GitlabMojoSupport
extends AbstractMojo {
    @Parameter(property="gitlab.host", required=true)
    private String host;
    @Parameter(property="gitlab.organizationId", required=true)
    String organizationId;
    @Parameter(property="gitlab.projectId", required=true)
    String projectId;
    @Parameter(property="gitlab.serverId", required=true)
    private String serverId;
    @Parameter(property="gitlab.cachePath", required=true, defaultValue="${project.build.directory}/gitlab-cache")
    private File cachePath;
    @Parameter(property="gitlab.quiet", defaultValue="true")
    private boolean quiet;
    @Parameter(property="gitlab.runOnlyAtExecutionRoot", defaultValue="true")
    private boolean runOnlyAtExecutionRoot;
    @Parameter(property="basedir", required=true)
    private String basedir;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession mavenSession;
    @Component(hint="gitlab-maven-plugin")
    private SecDispatcher sec;

    abstract boolean isSkip();

    abstract void execute(GitlabAPIExt var1) throws IOException, MilestoneNotFoundException, ProjectNotFoundException;

    boolean isVerbose() {
        return !this.quiet;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skip goal.");
            return;
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Connect to " + this.host));
        }
        GitlabAPIExt api = this.initApi();
        try {
            this.execute(api);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error with api", (Exception)e);
        }
        catch (MilestoneNotFoundException e) {
            throw new MojoExecutionException("Could not find milestone", (Exception)e);
        }
        catch (ProjectNotFoundException e) {
            throw new MojoExecutionException("Could not find project", (Exception)e);
        }
    }

    GitlabCache newCache() {
        return new GitlabCache(this.cachePath.toPath());
    }

    ProjectModel createProjectModel(String milestone, String title, String author, String authorEmail, String trackerAdd, String trackerFix, String trackerTask) throws IOException, ProjectNotFoundException {
        Optional<GitlabProject> gitlabProjectOptional;
        if (milestone.endsWith("-SNAPSHOT")) {
            milestone = StringUtils.removeEnd((String)milestone, (String)"-SNAPSHOT");
        }
        HashMap<String, String> issueTypeMap = new HashMap<String, String>();
        issueTypeMap.put(trackerAdd, "add");
        issueTypeMap.put(trackerFix, "fix");
        issueTypeMap.put(trackerTask, "task");
        GitlabCache gitlabCache = this.newCache();
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)"loading project...");
        }
        if (!(gitlabProjectOptional = gitlabCache.getProject()).isPresent()) {
            throw new ProjectNotFoundException();
        }
        String projectPath = this.organizationId + "/" + this.projectId;
        GitlabProject gitlabProject = gitlabProjectOptional.get();
        this.getLog().info((CharSequence)String.format("GitLab project (%s) id: %d", projectPath, gitlabProject.getId()));
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)"loading milestones...");
        }
        Set<GitlabMilestone> gitlabMilestones = gitlabCache.getMilestones();
        this.getLog().info((CharSequence)String.format("found %d milestone(s).", gitlabMilestones.size()));
        LinkedHashSet<MilestoneModel> milestoneModels = new LinkedHashSet<MilestoneModel>();
        for (GitlabMilestone gitlabMilestone : gitlabMilestones) {
            if (!"closed".equals(gitlabMilestone.getState()) && !milestone.equals(gitlabMilestone.getTitle())) {
                this.getLog().info((CharSequence)String.format("Skip open milestone %s.", gitlabMilestone.getTitle()));
                continue;
            }
            this.getLog().info((CharSequence)String.format("GitLab milestone (%s) id: %d", milestone, gitlabMilestone.getId()));
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)"loading issues...");
            }
            Set<GitlabIssue> issues = gitlabCache.getMilestoneIssues(gitlabMilestone);
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)String.format("found %d issue(s).", issues.size()));
            }
            Set<IssueModel> issueModels = issues.stream().map(i -> new IssueModel((GitlabIssue)i, (Map<String, String>)issueTypeMap)).collect(Collectors.toSet());
            milestoneModels.add(new MilestoneModel(gitlabMilestone, issueModels));
        }
        return new ProjectModel(this.host + "/" + projectPath, title, author, authorEmail, milestoneModels, trackerAdd, trackerFix, trackerTask);
    }

    boolean shouldSkip() {
        if (this.runOnlyAtExecutionRoot && !this.isThisTheExecutionRoot()) {
            this.getLog().info((CharSequence)"Skipping the Changes Report in this project because it's not the Execution Root");
            return true;
        }
        return false;
    }

    Mustache getMustache(String templateName) {
        DefaultMustacheFactory mf = new DefaultMustacheFactory("templates");
        return mf.compile(templateName);
    }

    private GitlabAPIExt initApi() throws MojoExecutionException {
        Server server = this.settings.getServer(this.serverId);
        String encryptedPrivateKey = server.getPrivateKey();
        try {
            String privateKey = this.sec.decrypt(encryptedPrivateKey);
            return new GitlabAPIExt(GitlabAPI.connect((String)this.host, (String)privateKey));
        }
        catch (SecDispatcherException e) {
            throw new MojoExecutionException("Could not decrypt privateKey", (Exception)((Object)e));
        }
    }

    private boolean isThisTheExecutionRoot() {
        this.getLog().debug((CharSequence)("Root Folder:" + this.mavenSession.getExecutionRootDirectory()));
        this.getLog().debug((CharSequence)("Current Folder:" + this.basedir));
        boolean result = this.mavenSession.getExecutionRootDirectory().equalsIgnoreCase(this.basedir);
        if (result) {
            this.getLog().debug((CharSequence)"This is the execution root.");
        } else {
            this.getLog().debug((CharSequence)"This is NOT the execution root.");
        }
        return result;
    }
}

