/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.gitlab.api.models.GitlabIssue;
import org.gitlab.api.models.GitlabMilestone;
import org.gitlab.api.models.GitlabProject;

class GitlabCache {
    private final Path cachePath;
    private final Gson gson;

    GitlabCache(Path cachePath) {
        this.cachePath = cachePath;
        this.gson = new Gson();
    }

    Optional<GitlabProject> getProject() throws IOException {
        Path projectPath = this.cachePath.resolve("project.json");
        if (Files.exists(projectPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(projectPath);){
                GitlabProject gitlabMilestone = (GitlabProject)this.gson.fromJson((Reader)reader, GitlabProject.class);
                Optional<GitlabProject> optional = Optional.of(gitlabMilestone);
                return optional;
            }
        }
        return Optional.empty();
    }

    void setProject(GitlabProject gitlabProject) throws IOException {
        Path projectPath = this.cachePath.resolve("project.json");
        Files.createDirectories(projectPath.getParent(), new FileAttribute[0]);
        try (BufferedWriter reader = Files.newBufferedWriter(projectPath, new OpenOption[0]);){
            this.gson.toJson((Object)gitlabProject, (Appendable)reader);
        }
    }

    Optional<GitlabMilestone> getMilestone(String id) throws IOException {
        Path milestonePath = this.cachePath.resolve("milestones").resolve(id + ".json");
        if (Files.exists(milestonePath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(milestonePath);){
                GitlabMilestone gitlabMilestone = (GitlabMilestone)this.gson.fromJson((Reader)reader, GitlabMilestone.class);
                Optional<GitlabMilestone> optional = Optional.of(gitlabMilestone);
                return optional;
            }
        }
        return Optional.empty();
    }

    Set<GitlabMilestone> getMilestones() throws IOException {
        Path milestonesPath = this.cachePath.resolve("milestones");
        Set<Path> paths = this.getPaths(milestonesPath);
        LinkedHashSet<GitlabMilestone> result = new LinkedHashSet<GitlabMilestone>();
        for (Path path : paths) {
            if (path.toFile().getName().endsWith("-issues.json")) continue;
            BufferedReader reader = Files.newBufferedReader(path);
            Throwable throwable = null;
            try {
                GitlabMilestone gitlabMilestone = (GitlabMilestone)this.gson.fromJson((Reader)reader, GitlabMilestone.class);
                result.add(gitlabMilestone);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((Reader)reader).close();
            }
        }
        return result;
    }

    void setMilestone(GitlabMilestone gitlabMilestone) throws IOException {
        Path milestonePath = this.cachePath.resolve("milestones").resolve(gitlabMilestone.getId() + ".json");
        Files.createDirectories(milestonePath.getParent(), new FileAttribute[0]);
        try (BufferedWriter reader = Files.newBufferedWriter(milestonePath, new OpenOption[0]);){
            this.gson.toJson((Object)gitlabMilestone, (Appendable)reader);
        }
    }

    Set<GitlabIssue> getMilestoneIssues(GitlabMilestone gitlabMilestone) throws IOException {
        Path issuesPath = this.cachePath.resolve("milestones").resolve(gitlabMilestone.getId() + "-issues.json");
        try (BufferedReader reader = Files.newBufferedReader(issuesPath);){
            Type typeOfT = new TypeToken<Set<GitlabIssue>>(){}.getType();
            Set set = (Set)this.gson.fromJson((Reader)reader, typeOfT);
            return set;
        }
    }

    void setMilestoneIssues(GitlabMilestone gitlabMilestone, Iterable<GitlabIssue> gitlabIssues) throws IOException {
        Path issuesPath = this.cachePath.resolve("milestones").resolve(String.format("%d-issues.json", gitlabMilestone.getId()));
        Files.createDirectories(issuesPath.getParent(), new FileAttribute[0]);
        try (BufferedWriter reader = Files.newBufferedWriter(issuesPath, new OpenOption[0]);){
            this.gson.toJson(gitlabIssues, (Appendable)reader);
        }
    }

    private Set<Path> getPaths(Path path) throws IOException {
        final LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toFile().getName().endsWith(".json")) {
                    paths.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return paths;
    }
}

