/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.models.GitlabIssue;
import org.gitlab.api.models.GitlabMilestone;
import org.gitlab.api.models.GitlabProject;

public class GitlabAPIExt {
    private final GitlabAPI delegate;

    public GitlabAPIExt(GitlabAPI delegate) {
        this.delegate = delegate;
    }

    public GitlabProject getProject(Serializable projectId) throws IOException {
        return this.delegate.getProject(projectId);
    }

    public List<GitlabMilestone> getMilestones(GitlabProject project) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/milestones";
        return this.delegate.retrieve().getAll(tailUrl, GitlabMilestone[].class);
    }

    public List<GitlabIssue> getMilestoneIssues(GitlabProject project, GitlabMilestone milestone) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/milestones" + "/" + milestone.getId() + "/issues";
        return this.delegate.retrieve().getAll(tailUrl, GitlabIssue[].class);
    }
}

