/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab;

import com.github.mustachejava.Mustache;
import io.ultreia.maven.gitlab.GitlabAPIExt;
import io.ultreia.maven.gitlab.GitlabMojoSupport;
import io.ultreia.maven.gitlab.MilestoneNotFoundException;
import io.ultreia.maven.gitlab.ProjectNotFoundException;
import io.ultreia.maven.gitlab.model.ProjectModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-changelog", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
@Execute(goal="download-milestones")
public class GenerateChangelogMojo
extends GitlabMojoSupport {
    @Parameter(property="gitlab.milestone", required=true, defaultValue="${project.version}")
    private String milestone;
    @Parameter(property="gitlab.changelogFile", required=true, defaultValue="${project.basedir}/CHANGELOG.md")
    private File changelogFile;
    @Parameter(property="gitlab.changesTitle", required=true)
    private String changesTitle;
    @Parameter(property="gitlab.changesAuthor", required=true)
    private String changesAuthor;
    @Parameter(property="gitlab.changesAuthorEmail", required=true)
    private String changesAuthorEmail;
    @Parameter(property="gitlab.trackerAdd", required=true)
    private String trackerAdd;
    @Parameter(property="gitlab.trackerFix", required=true)
    private String trackerFix;
    @Parameter(property="gitlab.trackerTask", required=true)
    private String trackerTask;
    @Parameter(property="gitlab.skip")
    private boolean skip;

    @Override
    boolean isSkip() {
        return this.skip || this.shouldSkip();
    }

    @Override
    protected void execute(GitlabAPIExt api) throws IOException, MilestoneNotFoundException, ProjectNotFoundException {
        ProjectModel model = this.createProjectModel(this.milestone, this.changesTitle, this.changesAuthor, this.changesAuthorEmail, this.trackerAdd, this.trackerFix, this.trackerTask);
        Mustache mustache = this.getMustache("CHANGELOG.md.mustache");
        try (BufferedWriter writer = Files.newBufferedWriter(this.changelogFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            mustache.execute((Writer)writer, (Object)model).flush();
        }
        this.getLog().info((CharSequence)String.format("CHANGELOG.md generated to %s", this.changelogFile.getParent()));
    }
}

