/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab;

import io.ultreia.maven.gitlab.GitlabAPIExt;
import io.ultreia.maven.gitlab.GitlabCache;
import io.ultreia.maven.gitlab.GitlabMojoSupport;
import io.ultreia.maven.gitlab.MilestoneNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.gitlab.api.models.GitlabIssue;
import org.gitlab.api.models.GitlabMilestone;
import org.gitlab.api.models.GitlabProject;

@Mojo(name="download-milestones", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class DownloadMilestonesMojo
extends GitlabMojoSupport {
    @Parameter(property="gitlab.milestone", required=true, defaultValue="${project.version}")
    private String milestone;
    @Parameter(property="gitlab.skip")
    private boolean skip;
    @Parameter(property="gitlab.force")
    private boolean force;
    @Parameter(property="gitlab.forceForCurrentMilestone", defaultValue="true")
    private boolean forceForCurrentMilestone;

    @Override
    boolean isSkip() {
        return this.skip || this.shouldSkip();
    }

    @Override
    protected void execute(GitlabAPIExt api) throws IOException, MilestoneNotFoundException {
        if (this.milestone.endsWith("-SNAPSHOT")) {
            this.milestone = StringUtils.removeEnd((String)this.milestone, (String)"-SNAPSHOT");
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)"loading project...");
        }
        String projectPath = this.organizationId + "/" + this.projectId;
        GitlabProject gitlabProject = api.getProject((Serializable)((Object)projectPath));
        GitlabCache gitlabCache = this.newCache();
        gitlabCache.setProject(gitlabProject);
        this.getLog().info((CharSequence)String.format("GitLab project (%s) id: %d", projectPath, gitlabProject.getId()));
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)"loading milestones...");
        }
        List<GitlabMilestone> gitlabMilestones = api.getMilestones(gitlabProject);
        this.getLog().info((CharSequence)String.format("found %d milestone(s).", gitlabMilestones.size()));
        Optional<GitlabMilestone> optionalMilestone = gitlabMilestones.stream().filter(m -> this.milestone.equals(m.getTitle())).findFirst();
        for (GitlabMilestone gitlabMilestone : gitlabMilestones) {
            Optional<GitlabMilestone> milestoneOptional;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)String.format("GitLab milestone (%s) id: %d", gitlabMilestone.getTitle(), gitlabMilestone.getId()));
            }
            if ((milestoneOptional = gitlabCache.getMilestone(gitlabMilestone.getId() + "")).isPresent()) {
                if (this.force) {
                    this.storeMilestone(api, gitlabProject, gitlabCache, gitlabMilestone);
                    continue;
                }
                if (this.forceForCurrentMilestone && optionalMilestone.isPresent() && gitlabMilestone.getId() == optionalMilestone.get().getId()) {
                    this.storeMilestone(api, gitlabProject, gitlabCache, gitlabMilestone);
                    continue;
                }
                if (!this.isVerbose()) continue;
                this.getLog().info((CharSequence)"Skip existing milestone");
                continue;
            }
            this.storeMilestone(api, gitlabProject, gitlabCache, gitlabMilestone);
        }
    }

    private void storeMilestone(GitlabAPIExt api, GitlabProject gitlabProject, GitlabCache gitlabCache, GitlabMilestone gitlabMilestone) throws IOException {
        gitlabCache.setMilestone(gitlabMilestone);
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)"loading issues...");
        }
        List<GitlabIssue> issues = api.getMilestoneIssues(gitlabProject, gitlabMilestone);
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)String.format("found %d issue(s).", issues.size()));
        }
        gitlabCache.setMilestoneIssues(gitlabMilestone, issues);
    }
}

