package io.ultreia.maven.gitlab;

/*-
 * #%L
 * Gitlab Maven Plugin
 * %%
 * Copyright (C) 2017 - 2019 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.gitlab.api.models.GitlabMilestone;
import org.nuiton.version.Version;
import org.nuiton.version.Versions;

/**
 * Created by tchemit on 12/03/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class GitlabMilestoneExt extends GitlabMilestone implements Comparable<GitlabMilestoneExt> {

    transient private Version version;

    @Override
    public int compareTo(GitlabMilestoneExt o) {
        return getVersion().compareTo(o.getVersion());
    }

    public Version getVersion() {
        if (version == null) {
            version = Versions.valueOf(getTitle());
        }
        return version;
    }
}
