/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab;

import io.ultreia.maven.gitlab.GitlabMilestoneExt;
import io.ultreia.maven.gitlab.model.GitlabIssueTime;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.models.GitlabIssue;
import org.gitlab.api.models.GitlabMilestone;
import org.gitlab.api.models.GitlabProject;

public class GitlabAPIExt {
    private final GitlabAPI delegate;

    public GitlabAPIExt(GitlabAPI delegate) {
        this.delegate = delegate;
    }

    public GitlabProject getProject(Serializable projectId) throws IOException {
        return this.delegate.getProject(projectId);
    }

    public List<GitlabMilestoneExt> getMilestones(GitlabProject project, String fromMilestone) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/milestones";
        List milestones = this.delegate.retrieve().getAll(tailUrl, GitlabMilestoneExt[].class);
        milestones.sort(GitlabMilestoneExt::compareTo);
        if (fromMilestone != null) {
            GitlabMilestoneExt milestone;
            Iterator iterator = milestones.iterator();
            while (iterator.hasNext() && !Objects.equals((milestone = (GitlabMilestoneExt)iterator.next()).getVersion().toString(), fromMilestone)) {
                iterator.remove();
            }
        }
        return milestones;
    }

    public List<GitlabIssue> getMilestoneIssues(GitlabProject project, GitlabMilestone milestone) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/milestones" + "/" + milestone.getId() + "/issues";
        return this.delegate.retrieve().getAll(tailUrl, GitlabIssue[].class);
    }

    public GitlabMilestone closeMilestone(GitlabMilestone edited) throws IOException {
        return this.delegate.updateMilestone(edited, "close");
    }

    public GitlabMilestone createMilestone(GitlabProject project, String title, String description) throws IOException {
        return this.delegate.createMilestone((Serializable)project.getId(), title, description, null, new Date());
    }

    public GitlabIssueTime getIssueTime(GitlabProject project, Integer issueId) throws IOException {
        String tailUrl = "/projects/" + project.getId() + String.format("/issues/%s/time_stats", issueId);
        return (GitlabIssueTime)this.delegate.retrieve().to(tailUrl, GitlabIssueTime.class);
    }
}

