/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab;

import io.ultreia.maven.gitlab.GitlabAPIExt;
import io.ultreia.maven.gitlab.GitlabCache;
import io.ultreia.maven.gitlab.GitlabMilestoneExt;
import io.ultreia.maven.gitlab.GitlabMojoSupport;
import io.ultreia.maven.gitlab.MilestoneNotFoundException;
import io.ultreia.maven.gitlab.ProjectNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.gitlab.api.models.GitlabProject;

@Mojo(name="create-milestone", defaultPhase=LifecyclePhase.INITIALIZE)
public class CreateMilestoneMojo
extends GitlabMojoSupport {
    @Parameter(property="gitlab.milestone", required=true, defaultValue="${project.version}")
    private String milestone;
    @Parameter(property="gitlab.fromMilestone")
    private String fromMilestone;
    @Parameter(property="gitlab.skip")
    private boolean skip;

    @Override
    boolean isSkip() {
        return this.skip || this.shouldSkip();
    }

    @Override
    void execute(GitlabAPIExt api) throws IOException, MilestoneNotFoundException, ProjectNotFoundException {
        if (this.milestone.endsWith("-SNAPSHOT")) {
            this.milestone = StringUtils.removeEnd((String)this.milestone, (String)"-SNAPSHOT");
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)"loading project...");
        }
        String projectPath = this.getGitlabProjectPath();
        GitlabProject gitlabProject = api.getProject((Serializable)((Object)projectPath));
        GitlabCache gitlabCache = this.newCache();
        gitlabCache.setProject(gitlabProject);
        this.getLog().info((CharSequence)String.format("GitLab project (%s) id: %d", projectPath, gitlabProject.getId()));
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)"loading milestones...");
        }
        List<GitlabMilestoneExt> gitlabMilestones = api.getMilestones(gitlabProject, this.fromMilestone);
        this.getLog().info((CharSequence)String.format("found %d milestone(s).", gitlabMilestones.size()));
        Optional<GitlabMilestoneExt> optionalMilestone = gitlabMilestones.stream().filter(m -> this.milestone.equals(m.getTitle())).findFirst();
        if (optionalMilestone.isPresent()) {
            this.getLog().info((CharSequence)String.format("Skip - milestone %s already exist.", optionalMilestone.get().getTitle()));
        } else {
            this.getLog().info((CharSequence)String.format("Creating milestone %s.", this.milestone));
            api.createMilestone(gitlabProject, this.milestone);
        }
    }
}

