package io.ultreia.maven.gitlab.model;

/*-
 * #%L
 * Gitlab Maven Plugin
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.*;

/**
 * Created by tchemit on 20/02/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class ProjectModel {

    private final String issueUrl;
    private final String title;
    private final String author;
    private final String authorEmail;

    private final String trackerAdd;
    private final String trackerFix;
    private final String trackerTask;

    private final List<MilestoneModel> milestones;

    public ProjectModel(String issueUrl, String title, String author, String authorEmail, Set<MilestoneModel> milestones, String trackerAdd, String trackerFix, String trackerTask) {
        this.issueUrl = issueUrl;
        this.title = title;
        this.author = author;
        this.authorEmail = authorEmail;
        this.trackerAdd = trackerAdd;
        this.trackerFix = trackerFix;
        this.trackerTask = trackerTask;
        this.milestones = new ArrayList<>(milestones);
        this.milestones.sort(Comparator.comparing(MilestoneModel::getId));
        Collections.reverse(this.milestones);
    }

    public Date getNow() {
        return new Date();
    }

    public String getIssueUrl() {
        return issueUrl;
    }

    public String getTitle() {
        return title;
    }

    public String getAuthor() {
        return author;
    }

    public String getAuthorEmail() {
        return authorEmail;
    }

    public String getTrackerAdd() {
        return trackerAdd;
    }

    public String getTrackerFix() {
        return trackerFix;
    }

    public String getTrackerTask() {
        return trackerTask;
    }

    public List<MilestoneModel> getMilestones() {
        return milestones;
    }
}
