package io.ultreia.maven.gitlab.model;

/*-
 * #%L
 * Gitlab Maven Plugin
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.gitlab.api.models.GitlabMilestone;

import java.util.*;
import java.util.stream.Collectors;

/**
 * Created by tchemit on 20/02/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class MilestoneModel {

    private final GitlabMilestone milestone;

    private final List<IssueModel> issues;

    public MilestoneModel(GitlabMilestone milestone, Set<IssueModel> issues) {
        this.milestone = milestone;
        this.issues = new ArrayList<>(issues);
        this.issues.sort(Comparator.comparing(IssueModel::getId));
    }

    public boolean isWithAdd() {
        return !getAddIssues().isEmpty();
    }

    public boolean isWithFix() {
        return !getFixIssues().isEmpty();
    }

    public boolean isWithTask() {
        return !getTaskIssues().isEmpty();
    }

    public List<IssueModel> getAddIssues() {
        return issues.stream().filter(i -> i.getIssueType().equals("add")).collect(Collectors.toList());
    }

    public List<IssueModel> getFixIssues() {
        return issues.stream().filter(i -> i.getIssueType().equals("fix")).collect(Collectors.toList());
    }

    public List<IssueModel> getTaskIssues() {
        return issues.stream().filter(i -> i.getIssueType().equals("task")).collect(Collectors.toList());
    }

    public List<IssueModel> getIssues() {
        return issues;
    }

    public int getId() {
        return milestone.getIid();
    }

    public String getTitle() {
        return milestone.getTitle();
    }

    public String getDescription() {
        return milestone.getDescription();
    }

    public Date getDueDate() {
        return milestone.getDueDate();
    }

    public String getState() {
        return milestone.getState();
    }
}
