/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.validation.api.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.ultreia.java4all.util.json.adapters.ClassAdapter;
import io.ultreia.java4all.validation.api.NuitonValidatorModel;
import io.ultreia.java4all.validation.api.io.NuitonValidatorModelAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NuitonValidatorModelHelper {
    public static final String LOCATION = "META-INF/validation/model-%s.json";
    private static final Logger log = LogManager.getLogger(NuitonValidatorModelHelper.class);

    public static Gson creatGson() {
        return new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Class.class, (Object)new ClassAdapter()).registerTypeAdapter(NuitonValidatorModel.class, new NuitonValidatorModelAdapter()).disableHtmlEscaping().create();
    }

    public List<NuitonValidatorModel<?>> readAll(String name) throws IOException {
        Enumeration<URL> resource = Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResources(this.toLocation(name)));
        Gson gson = NuitonValidatorModelHelper.creatGson();
        LinkedList result = new LinkedList();
        while (resource.hasMoreElements()) {
            URL url = resource.nextElement();
            result.addAll(this.readFile(gson, url));
        }
        return result.stream().sorted(Comparator.comparing(m -> m.getKey().toString(), String::compareTo)).collect(Collectors.toList());
    }

    public List<NuitonValidatorModel<?>> read(String name, Path location) throws IOException {
        URL resource = Objects.requireNonNull(location.resolve(this.toLocation(name)).toUri().toURL());
        Gson gson = NuitonValidatorModelHelper.creatGson();
        return this.readFile(gson, resource).stream().sorted(Comparator.comparing(m -> m.getKey().toString(), String::compareTo)).collect(Collectors.toList());
    }

    public Path write(String name, List<NuitonValidatorModel<?>> models, Path target) throws IOException {
        Gson gson = NuitonValidatorModelHelper.creatGson();
        String content = gson.toJson(models);
        Path location = this.toLocation(name, target);
        if (Files.notExists(location.getParent(), new LinkOption[0])) {
            Files.createDirectories(location.getParent(), new FileAttribute[0]);
        }
        Files.writeString(location, (CharSequence)content, new OpenOption[0]);
        return location;
    }

    public Path toLocation(String name, Path target) {
        return target.resolve(this.toLocation(name));
    }

    public String toLocation(String name) {
        return String.format(LOCATION, name);
    }

    private List<NuitonValidatorModel<?>> readFile(Gson gson, URL url) throws IOException {
        log.info("Loading file: {}", (Object)url);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            List list = (List)gson.fromJson((Reader)reader, new TypeToken<List<NuitonValidatorModel<?>>>(){}.getType());
            return list;
        }
    }
}

