/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.validation.api.io;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import io.ultreia.java4all.util.json.JsonAdapter;
import io.ultreia.java4all.validation.api.NuitonFieldValidatorModel;
import io.ultreia.java4all.validation.api.NuitonValidatorModel;
import io.ultreia.java4all.validation.api.NuitonValidatorModelEntry;
import io.ultreia.java4all.validation.api.NuitonValidatorScope;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class NuitonValidatorModelAdapter<O>
implements JsonSerializer<NuitonValidatorModel<O>>,
JsonDeserializer<NuitonValidatorModel<O>>,
JsonAdapter {
    public static final String TYPE = "type";
    public static final String CONTEXT = "context";

    public Class<?> type() {
        return Class.class;
    }

    public JsonElement serialize(NuitonValidatorModel<O> src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        result.add(TYPE, context.serialize(src.getKey().getType()));
        result.addProperty(CONTEXT, src.getKey().getContext());
        for (NuitonValidatorScope scope : src.getScopes()) {
            JsonObject scopeResult = new JsonObject();
            result.add(scope.name(), (JsonElement)scopeResult);
            List<NuitonFieldValidatorModel> fieldValidatorModels = src.getFieldsByScope().get((Object)scope);
            for (NuitonFieldValidatorModel fieldValidatorModel : fieldValidatorModels) {
                scopeResult.add(fieldValidatorModel.getFieldName(), context.serialize(fieldValidatorModel.getComments()));
            }
        }
        return result;
    }

    public NuitonValidatorModel<O> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        Class type = (Class)context.deserialize(object.get(TYPE), Class.class);
        String keyContext = Optional.ofNullable(object.get(CONTEXT)).map(JsonElement::getAsString).orElse(null);
        TreeMap<NuitonValidatorScope, List<NuitonFieldValidatorModel>> fields = new TreeMap<NuitonValidatorScope, List<NuitonFieldValidatorModel>>();
        for (NuitonValidatorScope scope : NuitonValidatorScope.values()) {
            Optional.ofNullable(object.get(scope.name())).map(JsonElement::getAsJsonObject).ifPresent(f -> {
                Map scopeFields = (Map)context.deserialize((JsonElement)f, new TypeToken<Map<String, TreeSet<String>>>(){}.getType());
                List fieldModels = scopeFields.entrySet().stream().map(e -> new NuitonFieldValidatorModel((String)e.getKey(), (Set)e.getValue())).sorted(Comparator.comparing(NuitonFieldValidatorModel::getFieldName)).collect(Collectors.toList());
                fields.put(scope, fieldModels);
            });
        }
        Set<NuitonValidatorScope> scopes = fields.keySet();
        return new NuitonValidatorModel(new NuitonValidatorModelEntry(type, keyContext, scopes), fields);
    }
}

