/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.validation.api;

import io.ultreia.java4all.validation.api.NuitonValidationContext;
import io.ultreia.java4all.validation.api.NuitonValidatorProvider;
import io.ultreia.java4all.validation.api.NuitonValidatorProviderFactory;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NuitonValidatorProviders {
    private static final Logger log = LogManager.getLogger(NuitonValidatorProviders.class);
    protected static String defaultFactoryName;
    protected static Map<String, NuitonValidatorProviderFactory> factories;

    protected NuitonValidatorProviders() {
    }

    public static NuitonValidatorProvider newProvider(String providerName, NuitonValidationContext validationContext) {
        if (providerName == null) {
            throw new NullPointerException("providerName parameter can not be null.");
        }
        return NuitonValidatorProviders.getFactory(providerName).newProvider(validationContext);
    }

    public static String getDefaultFactoryName() {
        if (defaultFactoryName == null) {
            Map<String, NuitonValidatorProviderFactory> factories = NuitonValidatorProviders.getFactories();
            if (factories.isEmpty()) {
                throw new IllegalStateException("Could not find any provider factory.");
            }
            Collection<NuitonValidatorProviderFactory> candidates = factories.values();
            if (candidates.size() > 1) {
                throw new IllegalStateException(String.format("There is %d provider factories, can't choose for you. You MUST invoke method io.ultreia.java4all.validation.api.NuitonValidatorProviders.setDefaultFactoryName(\"XXX\") where \"XXX\" is from: %s", candidates.size(), factories.keySet()));
            }
            defaultFactoryName = candidates.iterator().next().getName();
            log.info("Set the default provider name to {}", (Object)defaultFactoryName);
        }
        return defaultFactoryName;
    }

    public static void setDefaultFactoryName(String defaultFactoryName) {
        NuitonValidatorProviders.getFactory(defaultFactoryName);
        NuitonValidatorProviders.defaultFactoryName = Objects.requireNonNull(defaultFactoryName);
        log.info("Set the default provider name to {}", (Object)defaultFactoryName);
    }

    private static Map<String, NuitonValidatorProviderFactory> getFactories() {
        if (factories == null) {
            factories = new TreeMap<String, NuitonValidatorProviderFactory>();
            ServiceLoader<NuitonValidatorProviderFactory> serviceLoader = ServiceLoader.load(NuitonValidatorProviderFactory.class);
            for (NuitonValidatorProviderFactory factory : serviceLoader) {
                log.info("obtain validator provider factory {}", (Object)factory.getName());
                factories.put(factory.getName(), factory);
            }
        }
        return factories;
    }

    private static NuitonValidatorProviderFactory getFactory(String providerName) {
        NuitonValidatorProviderFactory factory = NuitonValidatorProviders.getFactories().get(providerName);
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Could not find provider factory named '%s', existing providers are : %s", providerName, NuitonValidatorProviders.getFactories().keySet()));
        }
        return factory;
    }
}

