/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.validation.api;

import io.ultreia.java4all.validation.api.NuitonValidatorModel;
import io.ultreia.java4all.validation.api.NuitonValidatorModelEntry;
import io.ultreia.java4all.validation.api.NuitonValidatorScope;
import io.ultreia.java4all.validation.api.io.NuitonValidatorModelHelper;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class NuitonValidatorModelProvider {
    private final String name;
    protected Set<NuitonValidatorModel<?>> models;

    public NuitonValidatorModelProvider(String name) {
        this.name = name;
    }

    public <O> NuitonValidatorModel<O> getModel(Class<O> type, String context, NuitonValidatorScope ... scopes) {
        NuitonValidatorModelEntry key = NuitonValidatorModelEntry.of(type, context, scopes);
        NuitonValidatorModel model = this.getModels().stream().filter(m -> m.getKey().matchTypeAndContext(key)).findFirst().orElse(null);
        return Objects.requireNonNull(model, String.format("Could not find model for entry: %s", key)).toModel(key);
    }

    public <O> Optional<NuitonValidatorModel<O>> getOptionalModel(Class<O> type, String context, NuitonValidatorScope ... scopes) {
        NuitonValidatorModelEntry key = NuitonValidatorModelEntry.of(type, context, scopes);
        NuitonValidatorModel model = this.getModels().stream().filter(m -> m.getKey().matchTypeAndContext(key)).findFirst().orElse(null);
        if (model == null) {
            return Optional.empty();
        }
        return Optional.of(model.toModel(key));
    }

    protected Set<NuitonValidatorModel<?>> getModels() {
        if (this.models == null) {
            try {
                List<NuitonValidatorModel<?>> validatorModels = new NuitonValidatorModelHelper().readAll(this.name);
                this.models = new LinkedHashSet(validatorModels);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.models;
    }
}

