/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.validation.api;

import io.ultreia.java4all.validation.api.NuitonValidatorScope;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;

public class NuitonValidatorModelEntry<O> {
    protected final Class<O> type;
    protected final String context;
    protected final Set<NuitonValidatorScope> scopes;

    public NuitonValidatorModelEntry(Class<O> type, String context, Set<NuitonValidatorScope> scopes) {
        this.type = type;
        this.context = context;
        this.scopes = scopes;
    }

    public static <O> NuitonValidatorModelEntry<O> of(Class<O> type, String context, NuitonValidatorScope ... scopes) {
        return new NuitonValidatorModelEntry<O>(type, context, new LinkedHashSet<NuitonValidatorScope>(List.of(scopes.length == 0 ? NuitonValidatorScope.values() : scopes)));
    }

    public Class<O> getType() {
        return this.type;
    }

    public String getContext() {
        return this.context;
    }

    public Set<NuitonValidatorScope> getScopes() {
        return this.scopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NuitonValidatorModelEntry)) {
            return false;
        }
        NuitonValidatorModelEntry that = (NuitonValidatorModelEntry)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.context, that.context) && Objects.equals(this.scopes, that.scopes);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.context, this.scopes);
    }

    public String toString() {
        return new StringJoiner(", ", NuitonValidatorModelEntry.class.getSimpleName() + "[", "]").add("type=" + this.type).add("context='" + this.context + "'").add("scopes=" + this.scopes).toString();
    }

    public <Y> boolean matchTypeAndContext(NuitonValidatorModelEntry<Y> that) {
        if (!Objects.equals(this.type, that.type) || !Objects.equals(this.context, that.context)) {
            return false;
        }
        for (NuitonValidatorScope scope : that.scopes) {
            if (!this.scopes.contains((Object)scope)) continue;
            return true;
        }
        return false;
    }

    public Path toPath(Path rootPath, NuitonValidatorScope scope) {
        return rootPath.resolve(this.type.getPackageName().replaceAll("\\.", "/")).resolve(String.format("%s%s-%s-validation.xml", this.type.getSimpleName(), this.context == null ? "" : "-" + this.context, scope.name().toLowerCase()));
    }
}

