/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.validation.api;

import io.ultreia.java4all.validation.api.NuitonFieldValidatorModel;
import io.ultreia.java4all.validation.api.NuitonValidatorModelEntry;
import io.ultreia.java4all.validation.api.NuitonValidatorScope;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class NuitonValidatorModel<O> {
    protected final NuitonValidatorModelEntry<O> key;
    protected final Map<NuitonValidatorScope, List<NuitonFieldValidatorModel>> fieldsByScope;

    public NuitonValidatorModel(NuitonValidatorModelEntry<O> key, Map<NuitonValidatorScope, List<NuitonFieldValidatorModel>> fieldsByScope) {
        this.key = Objects.requireNonNull(key);
        this.fieldsByScope = Collections.unmodifiableMap(Objects.requireNonNull(fieldsByScope));
    }

    public NuitonValidatorModelEntry<O> getKey() {
        return this.key;
    }

    public Class<O> getType() {
        return this.key.getType();
    }

    public String getContext() {
        return this.key.getContext();
    }

    public Set<NuitonValidatorScope> getScopes() {
        return this.key.getScopes();
    }

    public Map<NuitonValidatorScope, List<NuitonFieldValidatorModel>> getFieldsByScope() {
        return this.fieldsByScope;
    }

    public Optional<Set<String>> getFieldNames(NuitonValidatorScope scope) {
        return Optional.ofNullable(this.getFieldsByScope().get((Object)scope)).map(e -> e.stream().map(NuitonFieldValidatorModel::getFieldName).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public String toString() {
        return new StringJoiner(", ", NuitonValidatorModel.class.getSimpleName() + "[", "]").add("key=" + this.key).add("fieldsByScope=" + this.fieldsByScope).toString();
    }

    public NuitonValidatorModel<O> toModel(NuitonValidatorModelEntry<O> key) {
        if (key.equals(this.getKey())) {
            return this;
        }
        TreeMap<NuitonValidatorScope, List<NuitonFieldValidatorModel>> newFieldsByScope = new TreeMap<NuitonValidatorScope, List<NuitonFieldValidatorModel>>();
        for (NuitonValidatorScope scope : key.getScopes()) {
            List<NuitonFieldValidatorModel> value = this.fieldsByScope.get((Object)scope);
            if (value == null) continue;
            newFieldsByScope.put(scope, value);
        }
        return new NuitonValidatorModel<O>(key, newFieldsByScope);
    }
}

