/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.validation.api;

import io.ultreia.java4all.validation.api.NuitonValidatorScope;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;

public abstract class NuitonValidatorFileInfo {
    private final transient Path file;
    private final Class<?> type;
    private final String context;
    private final NuitonValidatorScope scope;
    private final Set<String> fields;
    private Map<String, List<String>> comments;

    public NuitonValidatorFileInfo(Path file, Class<?> type, String context, NuitonValidatorScope scope, Set<String> fields) {
        this.file = file;
        this.type = type;
        this.context = context;
        this.scope = scope;
        this.fields = fields;
    }

    public Path getFile() {
        return this.file;
    }

    public String getOrderKey() {
        return this.type.getName() + "-" + this.context + "-" + this.scope;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getContext() {
        return this.context;
    }

    public NuitonValidatorScope getScope() {
        return this.scope;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    protected abstract Map<String, List<String>> createComments();

    public final Map<String, List<String>> getComments() {
        if (this.comments == null) {
            this.comments = this.createComments();
        }
        return this.comments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NuitonValidatorFileInfo that = (NuitonValidatorFileInfo)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.context, that.context) && this.scope == that.scope;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.context, this.scope});
    }

    public String toString() {
        return new StringJoiner(", ", NuitonValidatorFileInfo.class.getSimpleName() + "[", "]").add("type=" + this.type.getName()).add("context='" + this.context + "'").add("scope=" + this.scope).add("fields=" + this.getFields()).toString();
    }
}

