/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.validation.api;

import io.ultreia.java4all.validation.api.NuitonScopeValidator;
import io.ultreia.java4all.validation.api.NuitonValidationContext;
import io.ultreia.java4all.validation.api.NuitonValidator;
import io.ultreia.java4all.validation.api.NuitonValidatorModel;
import io.ultreia.java4all.validation.api.NuitonValidatorResult;
import io.ultreia.java4all.validation.api.NuitonValidatorScope;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractNuitonValidator<O>
implements NuitonValidator<O> {
    private final NuitonValidatorModel<O> model;
    private Map<NuitonValidatorScope, NuitonScopeValidator<O>> validators;

    protected AbstractNuitonValidator(NuitonValidatorModel<O> model) {
        this.model = Objects.requireNonNull(model);
    }

    protected abstract NuitonScopeValidator<O> createScopeValidator(String var1, NuitonValidatorScope var2, Class<O> var3, Set<String> var4);

    @Override
    public NuitonValidatorModel<O> getModel() {
        return this.model;
    }

    @Override
    public NuitonValidatorResult validate(O object, NuitonValidationContext validationContext) throws NullPointerException {
        Objects.requireNonNull(object);
        NuitonValidatorResult result = new NuitonValidatorResult();
        for (Map.Entry<NuitonValidatorScope, NuitonScopeValidator<O>> entry : this.getValidators().entrySet()) {
            NuitonValidatorScope scope = entry.getKey();
            NuitonScopeValidator<O> validator = entry.getValue();
            Map<String, List<String>> newMessages = validator.validate(object, validationContext);
            result.addMessagesForScope(scope, newMessages);
        }
        return result;
    }

    @Override
    public Set<NuitonValidatorScope> getEffectiveScopes() {
        return this.getValidators().keySet();
    }

    @Override
    public Set<String> getEffectiveFields() {
        return this.getValidators().values().stream().flatMap(s -> s.getFieldNames().stream()).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getEffectiveFields(NuitonValidatorScope scope) {
        HashSet<String> result = new HashSet<String>();
        NuitonScopeValidator<O> scopeValidator = this.getValidators().get((Object)scope);
        if (scopeValidator != null) {
            result.addAll(scopeValidator.getFieldNames());
        }
        return result;
    }

    protected Map<NuitonValidatorScope, NuitonScopeValidator<O>> getValidators() {
        if (this.validators == null) {
            EnumMap validators = new EnumMap(NuitonValidatorScope.class);
            Class<O> type = this.model.getType();
            String context = this.model.getContext();
            for (NuitonValidatorScope scope : this.model.getScopes()) {
                this.model.getFieldNames(scope).ifPresent(fieldNames -> {
                    NuitonScopeValidator<O> newValidator = this.createScopeValidator(context, scope, type, (Set<String>)fieldNames);
                    validators.put(scope, newValidator);
                });
            }
            this.validators = Collections.unmodifiableMap(validators);
        }
        return this.validators;
    }
}

