/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.validation.maven.plugin;

import io.ultreia.java4all.lang.Objects2;
import io.ultreia.java4all.lang.Strings;
import io.ultreia.java4all.util.ImportManager;
import io.ultreia.java4all.validation.impl.NuitonScopeValidatorImpl;
import io.ultreia.java4all.validation.impl.ValidationMessagesCollector;
import io.ultreia.java4all.validation.impl.definition.FieldValidatorDefinition;
import io.ultreia.java4all.validation.impl.definition.FileValidatorDefinition;
import io.ultreia.java4all.validation.impl.definition.FileValidatorEntryDefinition;
import io.ultreia.java4all.validation.impl.definition.ProjectValidatorDefinition;
import io.ultreia.java4all.validation.impl.io.ProjectValidatorDefinitionBuilder;
import io.ultreia.java4all.validation.impl.io.ProjectValidatorFileDefinitionHelper;
import io.ultreia.java4all.validation.impl.io.ProjectValidatorMappingHelper;
import io.ultreia.java4all.validation.maven.plugin.AbstractValidationMojo;
import io.ultreia.java4all.validation.spi.field.generator.FieldValidationGenerator;
import io.ultreia.java4all.validation.spi.field.generator.FieldValidatorGenerators;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.validator.NuitonValidationContext;

@Mojo(name="generate-validators", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateValidatorsMojo
extends AbstractValidationMojo {
    public static final String CONTENT = "package %1$s;\n\n%2$s\n@Generated(\"io.ultreia.java4all.validation.maven.plugin.GenerateValidatorsMojo\")\npublic class %3$s extends NuitonScopeValidatorImpl<%4$s>{\n    public %3$s() {\n        super(%4$s.class , %5$s, Set.of(new String[]{\n%6$s\n        }), %7$s);\n    }\n\n    @Override\n    protected void validate(%4$s bean, NuitonValidationContext validationContext, ValidationMessagesCollector messagesCollector) {\n%8$s\n    }\n\n%9$s\n}";
    @Parameter(defaultValue="${basedir}/src/main/resources", required=true)
    protected File resources;
    @Parameter(defaultValue="${basedir}/src/main/resources", required=true)
    protected File src;
    @Parameter(defaultValue="${basedir}/target/generated-sources/java", required=true)
    protected File target;
    @Parameter(required=true)
    protected String validationContextType;
    private Set<String> missingGenerators = new TreeSet<String>();

    public void execute() throws MojoExecutionException {
        try (URLClassLoader loader = new URLClassLoader(new URL[]{this.src.toURI().toURL(), this.resources.toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader());){
            FieldValidatorGenerators generators = new FieldValidatorGenerators((ClassLoader)loader);
            TreeMap<String, CallSite> classesMapping = new TreeMap<String, CallSite>();
            Path rootPath = this.target.toPath();
            ProjectValidatorDefinition projectValidatorDefinition = new ProjectValidatorDefinitionBuilder((ClassLoader)loader).build(new ProjectValidatorFileDefinitionHelper().toLocation(this.src.toPath()).toUri().toURL());
            this.getLog().info((CharSequence)String.format("%d validator(s) detected.", projectValidatorDefinition.getFilesByEntry().size()));
            this.getLog().info((CharSequence)String.format("Generate at %s", rootPath));
            for (Map.Entry entry : projectValidatorDefinition.getFilesByEntry().entrySet()) {
                FileValidatorEntryDefinition key = (FileValidatorEntryDefinition)entry.getKey();
                String filePackageName = key.getBeanType().getPackageName();
                String fileSimpleName = this.toSimpleClassName(key);
                String fileName = filePackageName + "." + fileSimpleName;
                classesMapping.put(key.getKey(), (CallSite)((Object)fileName));
                FileValidatorDefinition fileValidatorDefinition = (FileValidatorDefinition)entry.getValue();
                Path fileLocation = this.toLocation(rootPath, key, fileSimpleName);
                String fileContent = this.toContent(generators, key, filePackageName, fileSimpleName, fileValidatorDefinition);
                this.getLog().info((CharSequence)String.format("Generate %s.%s at %s", filePackageName, fileSimpleName, fileLocation));
                if (fileContent == null) continue;
                if (Files.notExists(fileLocation.getParent(), new LinkOption[0])) {
                    Files.createDirectories(fileLocation.getParent(), new FileAttribute[0]);
                }
                Files.write(fileLocation, fileContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            this.getLog().info((CharSequence)String.format("%s validator(s) generated.", classesMapping.size()));
            ProjectValidatorMappingHelper mappingHelper = new ProjectValidatorMappingHelper();
            this.getLog().info((CharSequence)String.format("Generate classes mapping at %s", mappingHelper.toLocation(this.target.toPath())));
            mappingHelper.write(classesMapping, this.target.toPath());
            if (!this.missingGenerators.isEmpty()) {
                throw new MojoExecutionException(String.format("There is %d missing generator(s):\n * %s", this.missingGenerators.size(), String.join((CharSequence)"\n * ", this.missingGenerators)));
            }
        }
        catch (IOException | NoSuchMethodException e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    private String toSimpleClassName(FileValidatorEntryDefinition key) {
        return String.format("%sValidatorOn%sFor%s", key.getBeanType().getSimpleName(), key.getContext() == null ? "" : Arrays.stream(key.getContext().split("-")).map(Strings::capitalize).collect(Collectors.joining("")), Strings.capitalize((String)key.getScope()));
    }

    public Path toLocation(Path rootPath, FileValidatorEntryDefinition key, String fileSimpleName) {
        Path packagePath = rootPath.resolve(key.getBeanType().getPackageName().replaceAll("\\.", "/"));
        return packagePath.resolve(fileSimpleName + ".java");
    }

    private String toContent(FieldValidatorGenerators generators, FileValidatorEntryDefinition key, String filePackageName, String fileSimpleName, FileValidatorDefinition fileValidatorDefinition) throws NoSuchMethodException {
        ImportManager importManager = new ImportManager(filePackageName);
        importManager.addImport(NuitonScopeValidatorImpl.class);
        importManager.addImport(Generated.class);
        importManager.addImport(Set.class);
        importManager.addImport(NuitonValidationContext.class);
        importManager.addImport(ValidationMessagesCollector.class);
        importManager.addImport(key.getBeanType());
        LinkedHashMap<CallSite, String> methods = new LinkedHashMap<CallSite, String>();
        int validatorsCount = fileValidatorDefinition.getFields().values().stream().mapToInt(List::size).sum();
        int validatorsIndex = 0;
        for (Map.Entry entry : fileValidatorDefinition.getFields().entrySet()) {
            String fieldName = (String)entry.getKey();
            List validatorDefinitions = (List)entry.getValue();
            LinkedList<String> statements = new LinkedList<String>();
            for (FieldValidatorDefinition validatorDefinition : validatorDefinitions) {
                statements.add(String.format("        // %d - %s\n", validatorsIndex, validatorDefinition.getComment()));
                String supplier = this.generateFieldGeneratorInstance(generators, importManager, key, fieldName, validatorDefinition);
                statements.add(String.format("        validator(%d, %s).validate(bean, validationContext, messagesCollector);\n", validatorsIndex, supplier));
                ++validatorsIndex;
            }
            methods.put((CallSite)((Object)("validate" + Strings.capitalize((String)fieldName))), String.join((CharSequence)"", statements));
        }
        String simpleName = key.getBeanType().getSimpleName();
        return String.format(CONTENT, filePackageName, importManager.getImportsSection("\n"), fileSimpleName, simpleName, key.getContext() == null ? "null" : "\"" + key.getContext() + "\"", fileValidatorDefinition.getFields().keySet().stream().map(s -> "                \"" + s + "\"").collect(Collectors.joining(",\n")), validatorsCount, methods.keySet().stream().map(m -> String.format("        %s(bean, validationContext, messagesCollector);", m)).collect(Collectors.joining("\n")), methods.entrySet().stream().map(e -> String.format("    protected void %1$s(%2$s bean, NuitonValidationContext validationContext, ValidationMessagesCollector messagesCollector) {\n%3$s    }\n", e.getKey(), simpleName, e.getValue())).collect(Collectors.joining("\n")));
    }

    protected String generateFieldGeneratorInstance(FieldValidatorGenerators generators, ImportManager importManager, FileValidatorEntryDefinition key, String fieldName, FieldValidatorDefinition validatorDefinition) throws NoSuchMethodException {
        Class validator = validatorDefinition.getValidator();
        Class beanType = key.getBeanType();
        Optional optionalGenerator = generators.getGenerator(validator);
        if (optionalGenerator.isEmpty()) {
            this.getLog().error((CharSequence)("No generator for type " + validator.getName()));
            String getterName = FieldValidationGenerator.guessGetterName((Class)beanType, (String)fieldName);
            this.missingGenerators.add(validator.getName());
            return String.format("/* FIXME %s */() -> new io.ultreia.java4all.validation.impl.field.RequiredFieldValidator<>(\"%s\", %s::%s, null)", validator.getName(), fieldName, beanType.getSimpleName(), getterName);
        }
        return ((FieldValidationGenerator)optionalGenerator.get()).generate(key, validatorDefinition, Objects2.forName((String)this.validationContextType), importManager);
    }
}

